/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;

class ReadModifyWriteRowCallable
extends UnaryCallable<ReadModifyWriteRow, Row> {
    private final UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> inner;
    private final RequestContext requestContext;
    private final DefaultRowAdapter rowAdapter;

    ReadModifyWriteRowCallable(UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> inner, RequestContext requestContext) {
        this.inner = inner;
        this.requestContext = requestContext;
        this.rowAdapter = new DefaultRowAdapter();
    }

    public ApiFuture<Row> futureCall(ReadModifyWriteRow request, ApiCallContext context) {
        ApiFuture rawResponse = this.inner.futureCall((Object)request.toProto(this.requestContext), context);
        return ApiFutures.transform((ApiFuture)rawResponse, (ApiFunction)new ApiFunction<ReadModifyWriteRowResponse, Row>(){

            public Row apply(ReadModifyWriteRowResponse readModifyWriteRowResponse) {
                return ReadModifyWriteRowCallable.this.convertResponse(readModifyWriteRowResponse);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private Row convertResponse(ReadModifyWriteRowResponse response) {
        return this.rowAdapter.createRowFromProto(response.getRow());
    }
}

