/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.Type;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class ModifyColumnFamiliesRequest {
    private final ModifyColumnFamiliesRequest.Builder modFamilyRequest = com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.newBuilder();
    private final String tableId;

    public static ModifyColumnFamiliesRequest of(String tableId) {
        return new ModifyColumnFamiliesRequest(tableId);
    }

    ModifyColumnFamiliesRequest(String tableId) {
        Preconditions.checkNotNull((Object)tableId);
        this.tableId = tableId;
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId) {
        return this.addFamily(familyId, GCRules.GCRULES.defaultRule());
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId, GCRules.GCRule gcRule) {
        return this.addFamily(familyId, gcRule, Type.raw());
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId, Type valueType) {
        return this.addFamily(familyId, GCRules.GCRULES.defaultRule(), valueType);
    }

    public ModifyColumnFamiliesRequest addFamily(@Nonnull String familyId, @Nonnull GCRules.GCRule gcRule, @Nonnull Type valueType) {
        Preconditions.checkNotNull((Object)gcRule);
        Preconditions.checkNotNull((Object)valueType);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
        ColumnFamily.Builder createBuilder = modification.getCreateBuilder().setGcRule(gcRule.toProto());
        if (!valueType.equals(Type.raw())) {
            createBuilder.setValueType(valueType.toProto());
        }
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    public ModifyColumnFamiliesRequest updateFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull((Object)gcRule);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
        modification.getUpdateBuilder().setGcRule(gcRule.toProto());
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    public ModifyColumnFamiliesRequest dropFamily(String familyId) {
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId).setDrop(true);
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    @InternalApi
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"Project id can't be null");
        Preconditions.checkNotNull((Object)instanceId, (Object)"Instance id can't be null");
        String tableName = NameUtil.formatTableName(projectId, instanceId, this.tableId);
        return this.modFamilyRequest.setName(tableName).build();
    }
}

