/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.bigtable.admin.v2.AuthorizedViewName;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.BackupName;
import com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.CopyBackupRequest;
import com.google.bigtable.admin.v2.CreateAuthorizedViewRequest;
import com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteAuthorizedViewRequest;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.EncryptionInfo;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetAuthorizedViewRequest;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListAuthorizedViewsRequest;
import com.google.bigtable.admin.v2.ListAuthorizedViewsResponse;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.RestoreInfo;
import com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotName;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.bigtable.admin.v2.UndeleteTableRequest;
import com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest;
import com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.MockBigtableTableAdmin;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseBigtableTableAdminClientTest {
    private static MockBigtableTableAdmin mockBigtableTableAdmin;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private BaseBigtableTableAdminClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockBigtableTableAdmin = new MockBigtableTableAdmin();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockBigtableTableAdmin));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        BaseBigtableTableAdminSettings settings = ((BaseBigtableTableAdminSettings.Builder)((BaseBigtableTableAdminSettings.Builder)BaseBigtableTableAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = BaseBigtableTableAdminClient.create((BaseBigtableTableAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String tableId = "tableId-1552905847";
        Table table = Table.newBuilder().build();
        Table actualResponse = this.client.createTable(parent, tableId, table);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableRequest actualRequest = (CreateTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)table, (Object)actualRequest.getTable());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String tableId = "tableId-1552905847";
            Table table = Table.newBuilder().build();
            this.client.createTable(parent, tableId, table);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String tableId = "tableId-1552905847";
        Table table = Table.newBuilder().build();
        Table actualResponse = this.client.createTable(parent, tableId, table);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableRequest actualRequest = (CreateTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)table, (Object)actualRequest.getTable());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String tableId = "tableId-1552905847";
            Table table = Table.newBuilder().build();
            this.client.createTable(parent, tableId, table);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTableFromSnapshotTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createTableFromSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String tableId = "tableId-1552905847";
        SnapshotName sourceSnapshot = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
        Table actualResponse = (Table)this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableFromSnapshotRequest actualRequest = (CreateTableFromSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)sourceSnapshot.toString(), (Object)actualRequest.getSourceSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableFromSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String tableId = "tableId-1552905847";
            SnapshotName sourceSnapshot = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
            this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createTableFromSnapshotTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createTableFromSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String tableId = "tableId-1552905847";
        String sourceSnapshot = "sourceSnapshot-1078634753";
        Table actualResponse = (Table)this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableFromSnapshotRequest actualRequest = (CreateTableFromSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)sourceSnapshot, (Object)actualRequest.getSourceSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableFromSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String tableId = "tableId-1552905847";
            String sourceSnapshot = "sourceSnapshot-1078634753";
            this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createTableFromSnapshotTest3() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createTableFromSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String tableId = "tableId-1552905847";
        SnapshotName sourceSnapshot = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
        Table actualResponse = (Table)this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableFromSnapshotRequest actualRequest = (CreateTableFromSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)sourceSnapshot.toString(), (Object)actualRequest.getSourceSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableFromSnapshotExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String tableId = "tableId-1552905847";
            SnapshotName sourceSnapshot = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
            this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createTableFromSnapshotTest4() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createTableFromSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String tableId = "tableId-1552905847";
        String sourceSnapshot = "sourceSnapshot-1078634753";
        Table actualResponse = (Table)this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableFromSnapshotRequest actualRequest = (CreateTableFromSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)sourceSnapshot, (Object)actualRequest.getSourceSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableFromSnapshotExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String tableId = "tableId-1552905847";
            String sourceSnapshot = "sourceSnapshot-1078634753";
            this.client.createTableFromSnapshotAsync(parent, tableId, sourceSnapshot).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listTablesTest() throws Exception {
        Table responsesElement = Table.newBuilder().build();
        ListTablesResponse expectedResponse = ListTablesResponse.newBuilder().setNextPageToken("").addAllTables(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        BaseBigtableTableAdminClient.ListTablesPagedResponse pagedListResponse = this.client.listTables(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTablesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTablesRequest actualRequest = (ListTablesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTablesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listTables(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTablesTest2() throws Exception {
        Table responsesElement = Table.newBuilder().build();
        ListTablesResponse expectedResponse = ListTablesResponse.newBuilder().setNextPageToken("").addAllTables(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BaseBigtableTableAdminClient.ListTablesPagedResponse pagedListResponse = this.client.listTables(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTablesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTablesRequest actualRequest = (ListTablesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTablesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listTables(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        Table actualResponse = this.client.getTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTableRequest actualRequest = (GetTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            this.client.getTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Table actualResponse = this.client.getTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTableRequest actualRequest = (GetTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        Table table = Table.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Table actualResponse = (Table)this.client.updateTableAsync(table, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateTableRequest actualRequest = (UpdateTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)table, (Object)actualRequest.getTable());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            Table table = Table.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateTableAsync(table, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteTableTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        this.client.deleteTable(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTableRequest actualRequest = (DeleteTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            this.client.deleteTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTableTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteTable(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTableRequest actualRequest = (DeleteTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void undeleteTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("undeleteTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        Table actualResponse = (Table)this.client.undeleteTableAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UndeleteTableRequest actualRequest = (UndeleteTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void undeleteTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            this.client.undeleteTableAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void undeleteTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("undeleteTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Table actualResponse = (Table)this.client.undeleteTableAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UndeleteTableRequest actualRequest = (UndeleteTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void undeleteTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.undeleteTableAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createAuthorizedViewTest() throws Exception {
        AuthorizedView expectedResponse = AuthorizedView.newBuilder().setName(AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]").toString()).setEtag("etag3123477").setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createAuthorizedViewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        TableName parent = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        AuthorizedView authorizedView = AuthorizedView.newBuilder().build();
        String authorizedViewId = "authorizedViewId-2074136549";
        AuthorizedView actualResponse = (AuthorizedView)this.client.createAuthorizedViewAsync(parent, authorizedView, authorizedViewId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAuthorizedViewRequest actualRequest = (CreateAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)authorizedView, (Object)actualRequest.getAuthorizedView());
        Assert.assertEquals((Object)authorizedViewId, (Object)actualRequest.getAuthorizedViewId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAuthorizedViewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName parent = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            AuthorizedView authorizedView = AuthorizedView.newBuilder().build();
            String authorizedViewId = "authorizedViewId-2074136549";
            this.client.createAuthorizedViewAsync(parent, authorizedView, authorizedViewId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createAuthorizedViewTest2() throws Exception {
        AuthorizedView expectedResponse = AuthorizedView.newBuilder().setName(AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]").toString()).setEtag("etag3123477").setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createAuthorizedViewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        AuthorizedView authorizedView = AuthorizedView.newBuilder().build();
        String authorizedViewId = "authorizedViewId-2074136549";
        AuthorizedView actualResponse = (AuthorizedView)this.client.createAuthorizedViewAsync(parent, authorizedView, authorizedViewId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAuthorizedViewRequest actualRequest = (CreateAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)authorizedView, (Object)actualRequest.getAuthorizedView());
        Assert.assertEquals((Object)authorizedViewId, (Object)actualRequest.getAuthorizedViewId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAuthorizedViewExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            AuthorizedView authorizedView = AuthorizedView.newBuilder().build();
            String authorizedViewId = "authorizedViewId-2074136549";
            this.client.createAuthorizedViewAsync(parent, authorizedView, authorizedViewId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listAuthorizedViewsTest() throws Exception {
        AuthorizedView responsesElement = AuthorizedView.newBuilder().build();
        ListAuthorizedViewsResponse expectedResponse = ListAuthorizedViewsResponse.newBuilder().setNextPageToken("").addAllAuthorizedViews(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        TableName parent = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        BaseBigtableTableAdminClient.ListAuthorizedViewsPagedResponse pagedListResponse = this.client.listAuthorizedViews(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAuthorizedViewsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAuthorizedViewsRequest actualRequest = (ListAuthorizedViewsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAuthorizedViewsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName parent = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            this.client.listAuthorizedViews(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAuthorizedViewsTest2() throws Exception {
        AuthorizedView responsesElement = AuthorizedView.newBuilder().build();
        ListAuthorizedViewsResponse expectedResponse = ListAuthorizedViewsResponse.newBuilder().setNextPageToken("").addAllAuthorizedViews(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BaseBigtableTableAdminClient.ListAuthorizedViewsPagedResponse pagedListResponse = this.client.listAuthorizedViews(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAuthorizedViewsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAuthorizedViewsRequest actualRequest = (ListAuthorizedViewsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAuthorizedViewsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAuthorizedViews(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAuthorizedViewTest() throws Exception {
        AuthorizedView expectedResponse = AuthorizedView.newBuilder().setName(AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]").toString()).setEtag("etag3123477").setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        AuthorizedViewName name = AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]");
        AuthorizedView actualResponse = this.client.getAuthorizedView(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAuthorizedViewRequest actualRequest = (GetAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAuthorizedViewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            AuthorizedViewName name = AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]");
            this.client.getAuthorizedView(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAuthorizedViewTest2() throws Exception {
        AuthorizedView expectedResponse = AuthorizedView.newBuilder().setName(AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]").toString()).setEtag("etag3123477").setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AuthorizedView actualResponse = this.client.getAuthorizedView(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAuthorizedViewRequest actualRequest = (GetAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAuthorizedViewExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAuthorizedView(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAuthorizedViewTest() throws Exception {
        AuthorizedView expectedResponse = AuthorizedView.newBuilder().setName(AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]").toString()).setEtag("etag3123477").setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateAuthorizedViewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        AuthorizedView authorizedView = AuthorizedView.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        AuthorizedView actualResponse = (AuthorizedView)this.client.updateAuthorizedViewAsync(authorizedView, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAuthorizedViewRequest actualRequest = (UpdateAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)authorizedView, (Object)actualRequest.getAuthorizedView());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAuthorizedViewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            AuthorizedView authorizedView = AuthorizedView.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateAuthorizedViewAsync(authorizedView, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteAuthorizedViewTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        AuthorizedViewName name = AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]");
        this.client.deleteAuthorizedView(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAuthorizedViewRequest actualRequest = (DeleteAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAuthorizedViewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            AuthorizedViewName name = AuthorizedViewName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]", (String)"[AUTHORIZED_VIEW]");
            this.client.deleteAuthorizedView(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAuthorizedViewTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteAuthorizedView(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAuthorizedViewRequest actualRequest = (DeleteAuthorizedViewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAuthorizedViewExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAuthorizedView(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyColumnFamiliesTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        ArrayList modifications = new ArrayList();
        Table actualResponse = this.client.modifyColumnFamilies(name, modifications);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyColumnFamiliesRequest actualRequest = (ModifyColumnFamiliesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals(modifications, (Object)actualRequest.getModificationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyColumnFamiliesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            ArrayList modifications = new ArrayList();
            this.client.modifyColumnFamilies(name, modifications);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyColumnFamiliesTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ArrayList modifications = new ArrayList();
        Table actualResponse = this.client.modifyColumnFamilies(name, modifications);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyColumnFamiliesRequest actualRequest = (ModifyColumnFamiliesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals(modifications, (Object)actualRequest.getModificationsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyColumnFamiliesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            ArrayList modifications = new ArrayList();
            this.client.modifyColumnFamilies(name, modifications);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void dropRowRangeTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).build();
        this.client.dropRowRange(request);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DropRowRangeRequest actualRequest = (DropRowRangeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getRowKeyPrefix(), (Object)actualRequest.getRowKeyPrefix());
        Assert.assertEquals((Object)request.getDeleteAllDataFromTable(), (Object)actualRequest.getDeleteAllDataFromTable());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void dropRowRangeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).build();
            this.client.dropRowRange(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void generateConsistencyTokenTest() throws Exception {
        GenerateConsistencyTokenResponse expectedResponse = GenerateConsistencyTokenResponse.newBuilder().setConsistencyToken("consistencyToken-1985152319").build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        GenerateConsistencyTokenResponse actualResponse = this.client.generateConsistencyToken(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateConsistencyTokenRequest actualRequest = (GenerateConsistencyTokenRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateConsistencyTokenExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            this.client.generateConsistencyToken(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void generateConsistencyTokenTest2() throws Exception {
        GenerateConsistencyTokenResponse expectedResponse = GenerateConsistencyTokenResponse.newBuilder().setConsistencyToken("consistencyToken-1985152319").build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GenerateConsistencyTokenResponse actualResponse = this.client.generateConsistencyToken(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateConsistencyTokenRequest actualRequest = (GenerateConsistencyTokenRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateConsistencyTokenExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.generateConsistencyToken(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkConsistencyTest() throws Exception {
        CheckConsistencyResponse expectedResponse = CheckConsistencyResponse.newBuilder().setConsistent(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        String consistencyToken = "consistencyToken-1985152319";
        CheckConsistencyResponse actualResponse = this.client.checkConsistency(name, consistencyToken);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CheckConsistencyRequest actualRequest = (CheckConsistencyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)consistencyToken, (Object)actualRequest.getConsistencyToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void checkConsistencyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            String consistencyToken = "consistencyToken-1985152319";
            this.client.checkConsistency(name, consistencyToken);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkConsistencyTest2() throws Exception {
        CheckConsistencyResponse expectedResponse = CheckConsistencyResponse.newBuilder().setConsistent(true).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String consistencyToken = "consistencyToken-1985152319";
        CheckConsistencyResponse actualResponse = this.client.checkConsistency(name, consistencyToken);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CheckConsistencyRequest actualRequest = (CheckConsistencyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)consistencyToken, (Object)actualRequest.getConsistencyToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void checkConsistencyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            String consistencyToken = "consistencyToken-1985152319";
            this.client.checkConsistency(name, consistencyToken);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void snapshotTableTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]").toString()).setSourceTable(Table.newBuilder().build()).setDataSizeBytes(-2110122398L).setCreateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("snapshotTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        ClusterName cluster = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        String snapshotId = "snapshotId-1113817601";
        String description = "description-1724546052";
        Snapshot actualResponse = (Snapshot)this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SnapshotTableRequest actualRequest = (SnapshotTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)cluster.toString(), (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)snapshotId, (Object)actualRequest.getSnapshotId());
        Assert.assertEquals((Object)description, (Object)actualRequest.getDescription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void snapshotTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            ClusterName cluster = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            String snapshotId = "snapshotId-1113817601";
            String description = "description-1724546052";
            this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void snapshotTableTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]").toString()).setSourceTable(Table.newBuilder().build()).setDataSizeBytes(-2110122398L).setCreateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("snapshotTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
        String cluster = "cluster872092154";
        String snapshotId = "snapshotId-1113817601";
        String description = "description-1724546052";
        Snapshot actualResponse = (Snapshot)this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SnapshotTableRequest actualRequest = (SnapshotTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)snapshotId, (Object)actualRequest.getSnapshotId());
        Assert.assertEquals((Object)description, (Object)actualRequest.getDescription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void snapshotTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]");
            String cluster = "cluster872092154";
            String snapshotId = "snapshotId-1113817601";
            String description = "description-1724546052";
            this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void snapshotTableTest3() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]").toString()).setSourceTable(Table.newBuilder().build()).setDataSizeBytes(-2110122398L).setCreateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("snapshotTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        ClusterName cluster = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        String snapshotId = "snapshotId-1113817601";
        String description = "description-1724546052";
        Snapshot actualResponse = (Snapshot)this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SnapshotTableRequest actualRequest = (SnapshotTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)cluster.toString(), (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)snapshotId, (Object)actualRequest.getSnapshotId());
        Assert.assertEquals((Object)description, (Object)actualRequest.getDescription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void snapshotTableExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            ClusterName cluster = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            String snapshotId = "snapshotId-1113817601";
            String description = "description-1724546052";
            this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void snapshotTableTest4() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]").toString()).setSourceTable(Table.newBuilder().build()).setDataSizeBytes(-2110122398L).setCreateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("snapshotTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        String cluster = "cluster872092154";
        String snapshotId = "snapshotId-1113817601";
        String description = "description-1724546052";
        Snapshot actualResponse = (Snapshot)this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SnapshotTableRequest actualRequest = (SnapshotTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)snapshotId, (Object)actualRequest.getSnapshotId());
        Assert.assertEquals((Object)description, (Object)actualRequest.getDescription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void snapshotTableExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            String cluster = "cluster872092154";
            String snapshotId = "snapshotId-1113817601";
            String description = "description-1724546052";
            this.client.snapshotTableAsync(name, cluster, snapshotId, description).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]").toString()).setSourceTable(Table.newBuilder().build()).setDataSizeBytes(-2110122398L).setCreateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setDescription("description-1724546052").build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
        Snapshot actualResponse = this.client.getSnapshot(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnapshotRequest actualRequest = (GetSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
            this.client.getSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]").toString()).setSourceTable(Table.newBuilder().build()).setDataSizeBytes(-2110122398L).setCreateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setDescription("description-1724546052").build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Snapshot actualResponse = this.client.getSnapshot(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnapshotRequest actualRequest = (GetSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        BaseBigtableTableAdminClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            this.client.listSnapshots(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest2() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BaseBigtableTableAdminClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSnapshots(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
        this.client.deleteSnapshot(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[SNAPSHOT]");
            this.client.deleteSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSnapshot(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        String backupId = "backupId2121930365";
        Backup backup = Backup.newBuilder().build();
        Backup actualResponse = (Backup)this.client.createBackupAsync(parent, backupId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBackupRequest actualRequest = (CreateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            String backupId = "backupId2121930365";
            Backup backup = Backup.newBuilder().build();
            this.client.createBackupAsync(parent, backupId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String backupId = "backupId2121930365";
        Backup backup = Backup.newBuilder().build();
        Backup actualResponse = (Backup)this.client.createBackupAsync(parent, backupId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBackupRequest actualRequest = (CreateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String backupId = "backupId2121930365";
            Backup backup = Backup.newBuilder().build();
            this.client.createBackupAsync(parent, backupId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        Backup actualResponse = this.client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBackupRequest actualRequest = (GetBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            this.client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Backup actualResponse = this.client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBackupRequest actualRequest = (GetBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        Backup backup = Backup.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Backup actualResponse = this.client.updateBackup(backup, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateBackupRequest actualRequest = (UpdateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            Backup backup = Backup.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateBackup(backup, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        this.client.deleteBackup(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBackupRequest actualRequest = (DeleteBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            this.client.deleteBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteBackup(name);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBackupRequest actualRequest = (DeleteBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        BaseBigtableTableAdminClient.ListBackupsPagedResponse pagedListResponse = this.client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupsRequest actualRequest = (ListBackupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            this.client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest2() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BaseBigtableTableAdminClient.ListBackupsPagedResponse pagedListResponse = this.client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupsRequest actualRequest = (ListBackupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void restoreTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[TABLE]").toString()).putAllClusterStates(new HashMap()).putAllColumnFamilies(new HashMap()).setRestoreInfo(RestoreInfo.newBuilder().build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().build()).setDeletionProtection(true).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreTableTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        RestoreTableRequest request = RestoreTableRequest.newBuilder().setParent(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setTableId("tableId-1552905847").build();
        Table actualResponse = (Table)this.client.restoreTableAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestoreTableRequest actualRequest = (RestoreTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getTableId(), (Object)actualRequest.getTableId());
        Assert.assertEquals((Object)request.getBackup(), (Object)actualRequest.getBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restoreTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            RestoreTableRequest request = RestoreTableRequest.newBuilder().setParent(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setTableId("tableId-1552905847").build();
            this.client.restoreTableAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void copyBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        String backupId = "backupId2121930365";
        BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CopyBackupRequest actualRequest = (CopyBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertEquals((Object)sourceBackup.toString(), (Object)actualRequest.getSourceBackup());
        Assert.assertEquals((Object)expireTime, (Object)actualRequest.getExpireTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void copyBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            String backupId = "backupId2121930365";
            BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            Timestamp expireTime = Timestamp.newBuilder().build();
            this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void copyBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
        String backupId = "backupId2121930365";
        String sourceBackup = "sourceBackup823134653";
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CopyBackupRequest actualRequest = (CopyBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertEquals((Object)sourceBackup, (Object)actualRequest.getSourceBackup());
        Assert.assertEquals((Object)expireTime, (Object)actualRequest.getExpireTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void copyBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]");
            String backupId = "backupId2121930365";
            String sourceBackup = "sourceBackup823134653";
            Timestamp expireTime = Timestamp.newBuilder().build();
            this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void copyBackupTest3() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String backupId = "backupId2121930365";
        BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CopyBackupRequest actualRequest = (CopyBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertEquals((Object)sourceBackup.toString(), (Object)actualRequest.getSourceBackup());
        Assert.assertEquals((Object)expireTime, (Object)actualRequest.getExpireTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void copyBackupExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String backupId = "backupId2121930365";
            BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            Timestamp expireTime = Timestamp.newBuilder().build();
            this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void copyBackupTest4() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]").toString()).setSourceTable("sourceTable-95372173").setSourceBackup("sourceBackup823134653").setExpireTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setEncryptionInfo(EncryptionInfo.newBuilder().build()).setHotToStandardTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String backupId = "backupId2121930365";
        String sourceBackup = "sourceBackup823134653";
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CopyBackupRequest actualRequest = (CopyBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertEquals((Object)sourceBackup, (Object)actualRequest.getSourceBackup());
        Assert.assertEquals((Object)expireTime, (Object)actualRequest.getExpireTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void copyBackupExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String backupId = "backupId2121930365";
            String sourceBackup = "sourceBackup823134653";
            Timestamp expireTime = Timestamp.newBuilder().build();
            this.client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[CLUSTER]", (String)"[BACKUP]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockBigtableTableAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigtableTableAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigtableTableAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

