/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutures;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeOperationSnapshot;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AutoscalingLimits;
import com.google.bigtable.admin.v2.AutoscalingTargets;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.CreateClusterMetadata;
import com.google.bigtable.admin.v2.CreateInstanceMetadata;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.PartialUpdateClusterMetadata;
import com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.admin.v2.UpdateAppProfileMetadata;
import com.google.bigtable.admin.v2.UpdateClusterMetadata;
import com.google.bigtable.admin.v2.UpdateInstanceMetadata;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.ClusterAutoscalingConfig;
import com.google.cloud.bigtable.admin.v2.models.CreateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateClusterRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.admin.v2.models.PartialListClustersException;
import com.google.cloud.bigtable.admin.v2.models.PartialListInstancesException;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.models.UpdateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.iam.v1.Binding;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class BigtableInstanceAdminClientTests {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.WARN);
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String CLUSTER_ID = "my-cluster";
    private static final String APP_PROFILE_ID = "my-app-profile";
    private static final String PROJECT_NAME = NameUtil.formatProjectName((String)"my-project");
    private static final String INSTANCE_NAME = NameUtil.formatInstanceName((String)"my-project", (String)"my-instance");
    private static final String CLUSTER_NAME = NameUtil.formatClusterName((String)"my-project", (String)"my-instance", (String)"my-cluster");
    private static final String APP_PROFILE_NAME = NameUtil.formatAppProfileName((String)"my-project", (String)"my-instance", (String)"my-app-profile");
    private BigtableInstanceAdminClient adminClient;
    private final Cluster.ClusterConfig clusterConfig = Cluster.ClusterConfig.newBuilder().setClusterAutoscalingConfig(Cluster.ClusterAutoscalingConfig.newBuilder().setAutoscalingLimits(AutoscalingLimits.newBuilder().setMaxServeNodes(10).setMinServeNodes(2).build()).setAutoscalingTargets(AutoscalingTargets.newBuilder().setCpuUtilizationPercent(22).setStorageUtilizationGibPerNode(3000).build())).build();
    @Mock
    private BigtableInstanceAdminStub mockStub;
    @Mock
    private OperationCallable<com.google.bigtable.admin.v2.CreateInstanceRequest, com.google.bigtable.admin.v2.Instance, CreateInstanceMetadata> mockCreateInstanceCallable;
    @Mock
    private OperationCallable<PartialUpdateInstanceRequest, com.google.bigtable.admin.v2.Instance, UpdateInstanceMetadata> mockUpdateInstanceCallable;
    @Mock
    private UnaryCallable<GetInstanceRequest, com.google.bigtable.admin.v2.Instance> mockGetInstanceCallable;
    @Mock
    private UnaryCallable<ListInstancesRequest, ListInstancesResponse> mockListInstancesCallable;
    @Mock
    private UnaryCallable<DeleteInstanceRequest, Empty> mockDeleteInstanceCallable;
    @Mock
    private OperationCallable<com.google.bigtable.admin.v2.CreateClusterRequest, com.google.bigtable.admin.v2.Cluster, CreateClusterMetadata> mockCreateClusterCallable;
    @Mock
    private UnaryCallable<GetClusterRequest, com.google.bigtable.admin.v2.Cluster> mockGetClusterCallable;
    @Mock
    private UnaryCallable<ListClustersRequest, ListClustersResponse> mockListClustersCallable;
    @Mock
    private OperationCallable<com.google.bigtable.admin.v2.Cluster, com.google.bigtable.admin.v2.Cluster, UpdateClusterMetadata> mockUpdateClusterCallable;
    @Mock
    private OperationCallable<PartialUpdateClusterRequest, com.google.bigtable.admin.v2.Cluster, PartialUpdateClusterMetadata> mockPartialUpdateClusterCallable;
    @Mock
    private UnaryCallable<DeleteClusterRequest, Empty> mockDeleteClusterCallable;
    @Mock
    private UnaryCallable<com.google.bigtable.admin.v2.CreateAppProfileRequest, com.google.bigtable.admin.v2.AppProfile> mockCreateAppProfileCallable;
    @Mock
    private UnaryCallable<GetAppProfileRequest, com.google.bigtable.admin.v2.AppProfile> mockGetAppProfileCallable;
    @Mock
    private UnaryCallable<ListAppProfilesRequest, BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse> mockListAppProfilesCallable;
    @Mock
    private OperationCallable<com.google.bigtable.admin.v2.UpdateAppProfileRequest, com.google.bigtable.admin.v2.AppProfile, UpdateAppProfileMetadata> mockUpdateAppProfileCallable;
    @Mock
    private UnaryCallable<DeleteAppProfileRequest, Empty> mockDeleteAppProfileCallable;
    @Mock
    private UnaryCallable<GetIamPolicyRequest, com.google.iam.v1.Policy> mockGetIamPolicyCallable;
    @Mock
    private UnaryCallable<SetIamPolicyRequest, com.google.iam.v1.Policy> mockSetIamPolicyCallable;
    @Mock
    private UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> mockTestIamPermissionsCallable;

    @Before
    public void setUp() {
        this.adminClient = BigtableInstanceAdminClient.create((String)PROJECT_ID, (BigtableInstanceAdminStub)this.mockStub);
    }

    @Test
    public void testProjectName() {
        Truth.assertThat((String)this.adminClient.getProjectId()).isEqualTo((Object)PROJECT_ID);
    }

    @Test
    public void testClose() {
        this.adminClient.close();
        ((BigtableInstanceAdminStub)Mockito.verify((Object)this.mockStub)).close();
    }

    @Test
    public void testCreateInstance() {
        Mockito.when((Object)this.mockStub.createInstanceOperationCallable()).thenReturn(this.mockCreateInstanceCallable);
        com.google.bigtable.admin.v2.CreateInstanceRequest expectedRequest = com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().setParent(PROJECT_NAME).setInstanceId(INSTANCE_ID).setInstance(com.google.bigtable.admin.v2.Instance.newBuilder().setType(Instance.Type.DEVELOPMENT).setDisplayName(INSTANCE_ID)).putClusters("cluster1", com.google.bigtable.admin.v2.Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setServeNodes(1).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).build();
        com.google.bigtable.admin.v2.Instance expectedResponse = com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).build();
        this.mockOperationResult(this.mockCreateInstanceCallable, expectedRequest, expectedResponse);
        Instance actualResult = this.adminClient.createInstance(CreateInstanceRequest.of((String)INSTANCE_ID).setType(Instance.Type.DEVELOPMENT).addCluster("cluster1", "us-east1-c", 1, StorageType.SSD));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse));
    }

    @Test
    public void testCreateInstanceAutoscaling() {
        Mockito.when((Object)this.mockStub.createInstanceOperationCallable()).thenReturn(this.mockCreateInstanceCallable);
        AutoscalingLimits autoscalingLimits = AutoscalingLimits.newBuilder().setMaxServeNodes(5).setMinServeNodes(1).build();
        AutoscalingTargets autoscalingTargets = AutoscalingTargets.newBuilder().setCpuUtilizationPercent(49).build();
        Cluster.ClusterAutoscalingConfig clusterAutoscalingConfig = Cluster.ClusterAutoscalingConfig.newBuilder().setAutoscalingLimits(autoscalingLimits).setAutoscalingTargets(autoscalingTargets).build();
        com.google.bigtable.admin.v2.CreateInstanceRequest expectedRequest = com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().setParent(PROJECT_NAME).setInstanceId(INSTANCE_ID).setInstance(com.google.bigtable.admin.v2.Instance.newBuilder().setType(Instance.Type.DEVELOPMENT).setDisplayName(INSTANCE_ID)).putClusters("cluster1", com.google.bigtable.admin.v2.Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setClusterConfig(Cluster.ClusterConfig.newBuilder().setClusterAutoscalingConfig(clusterAutoscalingConfig).build()).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).build();
        com.google.bigtable.admin.v2.Instance expectedResponse = com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).build();
        this.mockOperationResult(this.mockCreateInstanceCallable, expectedRequest, expectedResponse);
        ClusterAutoscalingConfig autoscalingConfig = ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)"cluster1").setCpuUtilizationTargetPercent(49).setMaxNodes(5).setMinNodes(1);
        Instance actualResult = this.adminClient.createInstance(CreateInstanceRequest.of((String)INSTANCE_ID).setType(Instance.Type.DEVELOPMENT).addCluster("cluster1", "us-east1-c", autoscalingConfig, StorageType.SSD));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse));
    }

    @Test
    public void testUpdateInstance() {
        Mockito.when((Object)this.mockStub.partialUpdateInstanceOperationCallable()).thenReturn(this.mockUpdateInstanceCallable);
        PartialUpdateInstanceRequest expectedRequest = PartialUpdateInstanceRequest.newBuilder().setUpdateMask(FieldMask.newBuilder().addPaths("display_name")).setInstance(com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).setDisplayName("new display name")).build();
        com.google.bigtable.admin.v2.Instance expectedResponse = com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).build();
        this.mockOperationResult(this.mockUpdateInstanceCallable, expectedRequest, expectedResponse);
        Instance actualResult = this.adminClient.updateInstance(UpdateInstanceRequest.of((String)INSTANCE_ID).setDisplayName("new display name"));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse));
    }

    @Test
    public void testUpdateCluster() {
        Mockito.when((Object)this.mockStub.partialUpdateInstanceOperationCallable()).thenReturn(this.mockUpdateInstanceCallable);
        PartialUpdateInstanceRequest expectedRequest = PartialUpdateInstanceRequest.newBuilder().setUpdateMask(FieldMask.newBuilder().addPaths("display_name")).setInstance(com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).setDisplayName("new display name")).build();
        com.google.bigtable.admin.v2.Instance expectedResponse = com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).build();
        this.mockOperationResult(this.mockUpdateInstanceCallable, expectedRequest, expectedResponse);
        Instance actualResult = this.adminClient.updateInstance(UpdateInstanceRequest.of((String)INSTANCE_ID).setDisplayName("new display name"));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse));
    }

    @Test
    public void testGetInstance() {
        Mockito.when((Object)this.mockStub.getInstanceCallable()).thenReturn(this.mockGetInstanceCallable);
        GetInstanceRequest expectedRequest = GetInstanceRequest.newBuilder().setName(INSTANCE_NAME).build();
        com.google.bigtable.admin.v2.Instance expectedResponse = com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME).build();
        Mockito.when((Object)this.mockGetInstanceCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Instance actualResult = this.adminClient.getInstance(INSTANCE_ID);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse));
    }

    @Test
    public void testListInstances() {
        Mockito.when((Object)this.mockStub.listInstancesCallable()).thenReturn(this.mockListInstancesCallable);
        ListInstancesRequest expectedRequest = ListInstancesRequest.newBuilder().setParent(PROJECT_NAME).build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().addInstances(com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME + "1").build()).addInstances(com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME + "2").build()).build();
        Mockito.when((Object)this.mockListInstancesCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        List actualResult = this.adminClient.listInstances();
        Truth.assertThat((Iterable)actualResult).containsExactly(new Object[]{Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse.getInstances(0)), Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse.getInstances(1))});
    }

    @Test
    public void testListInstancesFailedZone() {
        Mockito.when((Object)this.mockStub.listInstancesCallable()).thenReturn(this.mockListInstancesCallable);
        ListInstancesRequest expectedRequest = ListInstancesRequest.newBuilder().setParent(PROJECT_NAME).build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().addInstances(com.google.bigtable.admin.v2.Instance.newBuilder().setName(INSTANCE_NAME + "1").build()).addFailedLocations(NameUtil.formatLocationName((String)PROJECT_ID, (String)"us-east1-d")).build();
        Mockito.when((Object)this.mockListInstancesCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Exception actualError = null;
        try {
            this.adminClient.listInstances();
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(PartialListInstancesException.class);
        assert (actualError != null);
        PartialListInstancesException partialListError = (PartialListInstancesException)actualError;
        Truth.assertThat((Iterable)partialListError.getInstances()).containsExactly(new Object[]{Instance.fromProto((com.google.bigtable.admin.v2.Instance)expectedResponse.getInstances(0))});
        Truth.assertThat((Iterable)partialListError.getUnavailableZones()).containsExactly(new Object[]{"us-east1-d"});
    }

    @Test
    public void testDeleteInstance() {
        Mockito.when((Object)this.mockStub.deleteInstanceCallable()).thenReturn(this.mockDeleteInstanceCallable);
        DeleteInstanceRequest expectedRequest = DeleteInstanceRequest.newBuilder().setName(INSTANCE_NAME).build();
        final AtomicBoolean wasCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mockDeleteInstanceCallable.futureCall((Object)expectedRequest)).thenAnswer((Answer)new Answer<ApiFuture<Empty>>(){

            public ApiFuture<Empty> answer(InvocationOnMock invocationOnMock) {
                wasCalled.set(true);
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }
        });
        this.adminClient.deleteInstance(INSTANCE_ID);
        Truth.assertThat((Boolean)wasCalled.get()).isTrue();
    }

    @Test
    public void testCreateCluster() {
        Mockito.when((Object)this.mockStub.createClusterOperationCallable()).thenReturn(this.mockCreateClusterCallable);
        com.google.bigtable.admin.v2.CreateClusterRequest expectedRequest = com.google.bigtable.admin.v2.CreateClusterRequest.newBuilder().setParent(INSTANCE_NAME).setClusterId(CLUSTER_ID).setCluster(com.google.bigtable.admin.v2.Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setServeNodes(3).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD)).build();
        com.google.bigtable.admin.v2.Cluster expectedResponse = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).build();
        this.mockOperationResult(this.mockCreateClusterCallable, expectedRequest, expectedResponse);
        Cluster actualResult = this.adminClient.createCluster(CreateClusterRequest.of((String)INSTANCE_ID, (String)CLUSTER_ID).setZone("us-east1-c").setServeNodes(3).setStorageType(StorageType.SSD));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse));
    }

    @Test
    public void testCreateClusterAutoscaling() {
        Mockito.when((Object)this.mockStub.createClusterOperationCallable()).thenReturn(this.mockCreateClusterCallable);
        com.google.bigtable.admin.v2.CreateClusterRequest expectedRequest = com.google.bigtable.admin.v2.CreateClusterRequest.newBuilder().setParent(INSTANCE_NAME).setClusterId(CLUSTER_ID).setCluster(com.google.bigtable.admin.v2.Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setClusterConfig(this.clusterConfig).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD)).build();
        com.google.bigtable.admin.v2.Cluster expectedResponse = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).build();
        this.mockOperationResult(this.mockCreateClusterCallable, expectedRequest, expectedResponse);
        Cluster actualResult = this.adminClient.createCluster(CreateClusterRequest.of((String)INSTANCE_ID, (String)CLUSTER_ID).setZone("us-east1-c").setScalingMode(ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setMinNodes(2).setMaxNodes(10).setCpuUtilizationTargetPercent(22).setStorageUtilizationGibPerNode(3000)).setStorageType(StorageType.SSD));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse));
    }

    @Test
    public void testGetCluster() {
        Mockito.when((Object)this.mockStub.getClusterCallable()).thenReturn(this.mockGetClusterCallable);
        GetClusterRequest expectedRequest = GetClusterRequest.newBuilder().setName(CLUSTER_NAME).build();
        com.google.bigtable.admin.v2.Cluster expectedResponse = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).build();
        Mockito.when((Object)this.mockGetClusterCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Cluster actualResult = this.adminClient.getCluster(INSTANCE_ID, CLUSTER_ID);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse));
    }

    @Test
    public void testListClusters() {
        Mockito.when((Object)this.mockStub.listClustersCallable()).thenReturn(this.mockListClustersCallable);
        ListClustersRequest expectedRequest = ListClustersRequest.newBuilder().setParent(INSTANCE_NAME).build();
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().addClusters(com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME + "1")).addClusters(com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME + "2")).build();
        Mockito.when((Object)this.mockListClustersCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        List actualResult = this.adminClient.listClusters(INSTANCE_ID);
        Truth.assertThat((Iterable)actualResult).containsExactly(new Object[]{Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse.getClusters(0)), Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse.getClusters(1))});
    }

    @Test
    public void testListClustersFailedZone() {
        Mockito.when((Object)this.mockStub.listClustersCallable()).thenReturn(this.mockListClustersCallable);
        ListClustersRequest expectedRequest = ListClustersRequest.newBuilder().setParent(INSTANCE_NAME).build();
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().addClusters(com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME)).addFailedLocations(NameUtil.formatLocationName((String)PROJECT_ID, (String)"us-east1-c")).build();
        Mockito.when((Object)this.mockListClustersCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Exception actualError = null;
        try {
            this.adminClient.listClusters(INSTANCE_ID);
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(PartialListClustersException.class);
        assert (actualError != null);
        PartialListClustersException partialListError = (PartialListClustersException)actualError;
        Truth.assertThat((Iterable)partialListError.getClusters()).containsExactly(new Object[]{Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse.getClusters(0))});
        Truth.assertThat((Iterable)partialListError.getUnavailableZones()).containsExactly(new Object[]{"us-east1-c"});
    }

    @Test
    public void testResizeCluster() {
        Mockito.when((Object)this.mockStub.updateClusterOperationCallable()).thenReturn(this.mockUpdateClusterCallable);
        com.google.bigtable.admin.v2.Cluster expectedRequest = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).setServeNodes(30).build();
        com.google.bigtable.admin.v2.Cluster expectedResponse = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).setLocation(NameUtil.formatLocationName((String)PROJECT_ID, (String)"us-east1-c")).setServeNodes(30).build();
        this.mockOperationResult(this.mockUpdateClusterCallable, expectedRequest, expectedResponse);
        Cluster actualResult = this.adminClient.resizeCluster(INSTANCE_ID, CLUSTER_ID, 30);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse));
    }

    @Test
    public void testDisableAutoscaling() {
        Mockito.when((Object)this.mockStub.partialUpdateClusterOperationCallable()).thenReturn(this.mockPartialUpdateClusterCallable);
        com.google.bigtable.admin.v2.Cluster cluster = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).setClusterConfig(Cluster.ClusterConfig.newBuilder().build()).setServeNodes(30).build();
        PartialUpdateClusterRequest expectedRequest = PartialUpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(FieldMask.newBuilder().addPaths("cluster_config.cluster_autoscaling_config").addPaths("serve_nodes").build()).build();
        com.google.bigtable.admin.v2.Cluster expectedResponse = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).setLocation(NameUtil.formatLocationName((String)PROJECT_ID, (String)"us-east1-c")).setServeNodes(30).build();
        this.mockOperationResult(this.mockPartialUpdateClusterCallable, expectedRequest, expectedResponse);
        Cluster actualResult = this.adminClient.disableClusterAutoscaling(INSTANCE_ID, CLUSTER_ID, 30);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse));
    }

    @Test
    public void testPartialUpdateCluster() {
        Mockito.when((Object)this.mockStub.partialUpdateClusterOperationCallable()).thenReturn(this.mockPartialUpdateClusterCallable);
        com.google.bigtable.admin.v2.Cluster cluster = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).setClusterConfig(this.clusterConfig).build();
        PartialUpdateClusterRequest expectedRequest = PartialUpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(FieldMask.newBuilder().addPaths("cluster_config.cluster_autoscaling_config.autoscaling_limits.max_serve_nodes").addPaths("cluster_config.cluster_autoscaling_config.autoscaling_limits.min_serve_nodes").addPaths("cluster_config.cluster_autoscaling_config.autoscaling_targets.cpu_utilization_percent").addPaths("cluster_config.cluster_autoscaling_config.autoscaling_targets.storage_utilization_gib_per_node").build()).build();
        com.google.bigtable.admin.v2.Cluster expectedResponse = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(CLUSTER_NAME).setLocation(NameUtil.formatLocationName((String)PROJECT_ID, (String)"us-east1-c")).setClusterConfig(this.clusterConfig).build();
        this.mockOperationResult(this.mockPartialUpdateClusterCallable, expectedRequest, expectedResponse);
        Cluster actualResult = this.adminClient.updateClusterAutoscalingConfig(ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setMaxNodes(10).setMinNodes(2).setStorageUtilizationGibPerNode(3000).setCpuUtilizationTargetPercent(22));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)expectedResponse));
    }

    @Test
    public void testDeleteCluster() {
        Mockito.when((Object)this.mockStub.deleteClusterCallable()).thenReturn(this.mockDeleteClusterCallable);
        DeleteClusterRequest expectedRequest = DeleteClusterRequest.newBuilder().setName(CLUSTER_NAME).build();
        final AtomicBoolean wasCalled = new AtomicBoolean(false);
        Mockito.when((Object)this.mockDeleteClusterCallable.futureCall((Object)expectedRequest)).thenAnswer((Answer)new Answer<ApiFuture<Empty>>(){

            public ApiFuture<Empty> answer(InvocationOnMock invocationOnMock) {
                wasCalled.set(true);
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }
        });
        this.adminClient.deleteCluster(INSTANCE_ID, CLUSTER_ID);
        Truth.assertThat((Boolean)wasCalled.get()).isTrue();
    }

    @Test
    public void testCreateAppProfile() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance())).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of()));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddSingleClusterId() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1"))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1")).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{"cluster-id-1"})));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddMultipleClusterIds() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1").addClusterIds("cluster-id-2"))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1").addClusterIds("cluster-id-2")).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{"cluster-id-1", "cluster-id-2"})));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddMultipleClusterIdsWithList() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2"))).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{"cluster-id-1", "cluster-id-2"})));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddPriority() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1")).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1")).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM)).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{"cluster-id-1"})).setIsolationPolicy((AppProfile.IsolationPolicy)AppProfile.StandardIsolationPolicy.of((AppProfile.Priority)AppProfile.Priority.MEDIUM)));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddRowAffinity() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance())).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.withRowAffinity()));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddRowAffinityAddMultipleClusterIds() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1").addClusterIds("cluster-id-2").setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1").addClusterIds("cluster-id-2").setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance())).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.withRowAffinity((String[])new String[]{"cluster-id-1", "cluster-id-2"})));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testCreateAppProfileAddRowAffinityAddSetOfClusterIds() {
        Mockito.when((Object)this.mockStub.createAppProfileCallable()).thenReturn(this.mockCreateAppProfileCallable);
        com.google.bigtable.admin.v2.CreateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1").addClusterIds("cluster-id-2").setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()))).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addClusterIds("cluster-id-1").addClusterIds("cluster-id-2").setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance())).build();
        Mockito.when((Object)this.mockCreateAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        HashSet<String> clusterIds = new HashSet<String>();
        clusterIds.add("cluster-id-1");
        clusterIds.add("cluster-id-2");
        AppProfile actualResult = this.adminClient.createAppProfile(CreateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.withRowAffinity(clusterIds)));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testGetAppProfile() {
        Mockito.when((Object)this.mockStub.getAppProfileCallable()).thenReturn(this.mockGetAppProfileCallable);
        GetAppProfileRequest expectedRequest = GetAppProfileRequest.newBuilder().setName(APP_PROFILE_NAME).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).build();
        Mockito.when((Object)this.mockGetAppProfileCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        AppProfile actualResult = this.adminClient.getAppProfile(INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testListAppProfiles() {
        Mockito.when((Object)this.mockStub.listAppProfilesPagedCallable()).thenReturn(this.mockListAppProfilesCallable);
        ListAppProfilesRequest expectedRequest = ListAppProfilesRequest.newBuilder().setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        ArrayList expectedProtos = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            expectedProtos.add(com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME + i).setDescription("profile" + i).setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).build());
        }
        BaseBigtableInstanceAdminClient.ListAppProfilesPage page0 = (BaseBigtableInstanceAdminClient.ListAppProfilesPage)Mockito.mock(BaseBigtableInstanceAdminClient.ListAppProfilesPage.class);
        Mockito.when((Object)page0.getValues()).thenReturn(expectedProtos.subList(0, 2));
        Mockito.when((Object)page0.hasNextPage()).thenReturn((Object)true);
        BaseBigtableInstanceAdminClient.ListAppProfilesPage page1 = (BaseBigtableInstanceAdminClient.ListAppProfilesPage)Mockito.mock(BaseBigtableInstanceAdminClient.ListAppProfilesPage.class);
        Mockito.when((Object)page1.getValues()).thenReturn(expectedProtos.subList(2, 3));
        Mockito.when((Object)page0.getNextPageAsync()).thenReturn((Object)ApiFutures.immediateFuture((Object)page1));
        BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse response0 = (BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse)Mockito.mock(BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse.class);
        Mockito.when((Object)((BaseBigtableInstanceAdminClient.ListAppProfilesPage)response0.getPage())).thenReturn((Object)page0);
        Mockito.when((Object)this.mockListAppProfilesCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)response0));
        List actualResults = this.adminClient.listAppProfiles(INSTANCE_ID);
        ArrayList expectedResults = Lists.newArrayList();
        for (com.google.bigtable.admin.v2.AppProfile expectedProto : expectedProtos) {
            expectedResults.add(AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedProto));
        }
        Truth.assertThat((Iterable)actualResults).containsExactlyElementsIn((Iterable)expectedResults);
    }

    @Test
    public void testUpdateAppProfile() {
        Mockito.when((Object)this.mockStub.updateAppProfileOperationCallable()).thenReturn(this.mockUpdateAppProfileCallable);
        com.google.bigtable.admin.v2.UpdateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("updated description")).setUpdateMask(FieldMask.newBuilder().addPaths("description")).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setDescription("updated description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).build();
        this.mockOperationResult(this.mockUpdateAppProfileCallable, expectedRequest, expectedResponse);
        AppProfile actualResult = this.adminClient.updateAppProfile(UpdateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setDescription("updated description"));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testUpdateAppProfileStandardIsolation() {
        Mockito.when((Object)this.mockStub.updateAppProfileOperationCallable()).thenReturn(this.mockUpdateAppProfileCallable);
        com.google.bigtable.admin.v2.UpdateAppProfileRequest expectedRequest = com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_LOW))).setUpdateMask(FieldMask.newBuilder().addPaths("standard_isolation")).build();
        com.google.bigtable.admin.v2.AppProfile expectedResponse = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(APP_PROFILE_NAME).setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_LOW)).build();
        this.mockOperationResult(this.mockUpdateAppProfileCallable, expectedRequest, expectedResponse);
        AppProfile actualResult = this.adminClient.updateAppProfile(UpdateAppProfileRequest.of((String)INSTANCE_ID, (String)APP_PROFILE_ID).setIsolationPolicy((AppProfile.IsolationPolicy)AppProfile.StandardIsolationPolicy.of((AppProfile.Priority)AppProfile.Priority.LOW)));
        Truth.assertThat((Object)actualResult).isEqualTo((Object)AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)expectedResponse));
    }

    @Test
    public void testDeleteAppProfile() throws Exception {
        Mockito.when((Object)this.mockStub.deleteAppProfileCallable()).thenReturn(this.mockDeleteAppProfileCallable);
        DeleteAppProfileRequest expectedRequest = DeleteAppProfileRequest.newBuilder().setName(APP_PROFILE_NAME).build();
        DeleteAppProfileRequest forceDeleteRequest = DeleteAppProfileRequest.newBuilder().setName(APP_PROFILE_NAME).setIgnoreWarnings(true).build();
        final AtomicInteger wasCalled = new AtomicInteger(0);
        final AtomicInteger forcedDeleteCall = new AtomicInteger(0);
        Mockito.when((Object)this.mockDeleteAppProfileCallable.futureCall((Object)expectedRequest)).thenAnswer((Answer)new Answer<ApiFuture<Empty>>(){

            public ApiFuture<Empty> answer(InvocationOnMock invocationOnMock) {
                wasCalled.incrementAndGet();
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }
        });
        Mockito.when((Object)this.mockDeleteAppProfileCallable.futureCall((Object)forceDeleteRequest)).thenAnswer((Answer)new Answer<ApiFuture<Empty>>(){

            public ApiFuture<Empty> answer(InvocationOnMock invocationOnMock) {
                forcedDeleteCall.incrementAndGet();
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }
        });
        this.adminClient.deleteAppProfile(INSTANCE_ID, APP_PROFILE_ID);
        this.adminClient.deleteAppProfileAsync(INSTANCE_ID, APP_PROFILE_ID).get();
        this.adminClient.deleteAppProfile(INSTANCE_ID, APP_PROFILE_ID, true);
        this.adminClient.deleteAppProfileAsync(INSTANCE_ID, APP_PROFILE_ID, true).get();
        Truth.assertThat((Integer)wasCalled.get()).isEqualTo((Object)2);
        Truth.assertThat((Integer)forcedDeleteCall.get()).isEqualTo((Object)2);
    }

    private <ReqT, RespT, MetaT> void mockOperationResult(OperationCallable<ReqT, RespT, MetaT> callable, ReqT request, RespT response) {
        FakeOperationSnapshot operationSnapshot = FakeOperationSnapshot.newBuilder().setDone(true).setErrorCode((StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.OK)).setName("fake-name").setResponse(response).build();
        OperationFuture operationFuture = OperationFutures.immediateOperationFuture((OperationSnapshot)operationSnapshot);
        Mockito.when((Object)callable.futureCall(request)).thenReturn((Object)operationFuture);
    }

    @Test
    public void testGetIamPolicy() {
        Mockito.when((Object)this.mockStub.getIamPolicyCallable()).thenReturn(this.mockGetIamPolicyCallable);
        GetIamPolicyRequest expectedRequest = GetIamPolicyRequest.newBuilder().setResource(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        com.google.iam.v1.Policy expectedResponse = com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/bigtable.user").addMembers("user:someone@example.com")).setEtag(ByteString.copyFromUtf8((String)"my-etag")).build();
        Mockito.when((Object)this.mockGetIamPolicyCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Policy actualResult = this.adminClient.getIamPolicy(INSTANCE_ID);
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Policy.newBuilder().addIdentity(Role.of((String)"bigtable.user"), Identity.user((String)"someone@example.com"), new Identity[0]).setEtag(BaseEncoding.base64().encode("my-etag".getBytes())).build());
    }

    @Test
    public void testSetIamPolicy() {
        Mockito.when((Object)this.mockStub.setIamPolicyCallable()).thenReturn(this.mockSetIamPolicyCallable);
        SetIamPolicyRequest expectedRequest = SetIamPolicyRequest.newBuilder().setResource(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setPolicy(com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/bigtable.user").addMembers("user:someone@example.com"))).build();
        com.google.iam.v1.Policy expectedResponse = com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/bigtable.user").addMembers("user:someone@example.com")).setEtag(ByteString.copyFromUtf8((String)"my-etag")).build();
        Mockito.when((Object)this.mockSetIamPolicyCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        Policy actualResult = this.adminClient.setIamPolicy(INSTANCE_ID, Policy.newBuilder().addIdentity(Role.of((String)"bigtable.user"), Identity.user((String)"someone@example.com"), new Identity[0]).build());
        Truth.assertThat((Object)actualResult).isEqualTo((Object)Policy.newBuilder().addIdentity(Role.of((String)"bigtable.user"), Identity.user((String)"someone@example.com"), new Identity[0]).setEtag(BaseEncoding.base64().encode("my-etag".getBytes())).build());
    }

    @Test
    public void testTestIamPermissions() {
        Mockito.when((Object)this.mockStub.testIamPermissionsCallable()).thenReturn(this.mockTestIamPermissionsCallable);
        TestIamPermissionsRequest expectedRequest = TestIamPermissionsRequest.newBuilder().setResource(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).addPermissions("bigtable.tables.readRows").build();
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addPermissions("bigtable.tables.readRows").build();
        Mockito.when((Object)this.mockTestIamPermissionsCallable.futureCall((Object)expectedRequest)).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        List actualResult = this.adminClient.testIamPermission(INSTANCE_ID, new String[]{"bigtable.tables.readRows"});
        Truth.assertThat((Iterable)actualResult).containsExactly(new Object[]{"bigtable.tables.readRows"});
    }

    @Test
    public void testExistsTrue() {
        Mockito.when((Object)this.mockStub.getInstanceCallable()).thenReturn(this.mockGetInstanceCallable);
        com.google.bigtable.admin.v2.Instance expectedResponse = com.google.bigtable.admin.v2.Instance.newBuilder().setName(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        Mockito.when((Object)this.mockGetInstanceCallable.futureCall((Object)((GetInstanceRequest)ArgumentMatchers.any(GetInstanceRequest.class)))).thenReturn((Object)ApiFutures.immediateFuture((Object)expectedResponse));
        boolean found = this.adminClient.exists(INSTANCE_ID);
        Truth.assertThat((Boolean)found).isTrue();
    }

    @Test
    public void testExistsFalse() {
        Mockito.when((Object)this.mockStub.getInstanceCallable()).thenReturn(this.mockGetInstanceCallable);
        NotFoundException exception = new NotFoundException("fake-error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        Mockito.when((Object)this.mockGetInstanceCallable.futureCall((Object)((GetInstanceRequest)ArgumentMatchers.any(GetInstanceRequest.class)))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)exception));
        boolean found = this.adminClient.exists(INSTANCE_ID);
        Truth.assertThat((Boolean)found).isFalse();
    }
}

