/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.internal;

import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NameUtilTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void extractBackupIdFromBackupNameTest() {
        String testBackupName = "projects/my-project/instances/my-instance/clusters/my-cluster/backups/my-backup";
        Truth.assertThat((String)NameUtil.extractBackupIdFromBackupName((String)testBackupName)).isEqualTo((Object)"my-backup");
        this.exception.expect(IllegalArgumentException.class);
        NameUtil.extractBackupIdFromBackupName((String)"bad-format");
    }

    @Test
    public void formatBackupNameTest() {
        String testBackupName = "projects/my-project/instances/my-instance/clusters/my-cluster/backups/my-backup";
        Truth.assertThat((String)NameUtil.formatBackupName((String)"my-project", (String)"my-instance", (String)"my-cluster", (String)"my-backup")).isEqualTo((Object)testBackupName);
    }

    @Test
    public void formatAuthorizedViewNameTest() {
        String testAuthorizedViewName = "projects/my-project/instances/my-instance/tables/my-table/authorizedViews/my-authorized-view";
        Truth.assertThat((String)NameUtil.formatAuthorizedViewName((String)"my-project", (String)"my-instance", (String)"my-table", (String)"my-authorized-view")).isEqualTo((Object)testAuthorizedViewName);
    }

    @Test
    public void extractAuthorizedViewIdFromAuthorizedViewNameTest() {
        String testAuthorizedViewName = "projects/my-project/instances/my-instance/tables/my-table/authorizedViews/my-authorized-view";
        Truth.assertThat((String)NameUtil.extractAuthorizedViewIdFromAuthorizedViewName((String)testAuthorizedViewName)).isEqualTo((Object)"my-authorized-view");
        this.exception.expect(IllegalArgumentException.class);
        NameUtil.extractAuthorizedViewIdFromAuthorizedViewName((String)"bad-format");
    }

    @Test
    public void extractTableIdFromAuthorizedViewNameTest() {
        String testAuthorizedViewName = "projects/my-project/instances/my-instance/tables/my-table/authorizedViews/my-authorized-view";
        Truth.assertThat((String)com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTableIdFromAuthorizedViewName((String)testAuthorizedViewName)).isEqualTo((Object)"my-table");
        this.exception.expect(IllegalArgumentException.class);
        com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTableIdFromAuthorizedViewName((String)"bad-format");
    }

    @Test
    public void extractTableNameFromAuthorizedViewNameTest() {
        String testAuthorizedViewName = "projects/my-project/instances/my-instance/tables/my-table/authorizedViews/my-authorized-view";
        Truth.assertThat((String)com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTableNameFromAuthorizedViewName((String)testAuthorizedViewName)).isEqualTo((Object)"projects/my-project/instances/my-instance/tables/my-table");
        this.exception.expect(IllegalArgumentException.class);
        com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTableNameFromAuthorizedViewName((String)"bad-format");
    }

    @Test
    public void testExtractTargetId() {
        String testTableName = "projects/my-project/instances/my-instance/tables/my-table";
        String testAuthorizedViewName = "projects/my-project/instances/my-instance/tables/my-table/authorizedViews/my-authorized-view";
        Truth.assertThat((Object)com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTargetId((String)testTableName, (String)"")).isEqualTo((Object)TableId.of((String)"my-table"));
        Truth.assertThat((Object)com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTargetId((String)"", (String)testAuthorizedViewName)).isEqualTo((Object)AuthorizedViewId.of((String)"my-table", (String)"my-authorized-view"));
        this.exception.expect(IllegalArgumentException.class);
        com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTargetId((String)"", (String)"");
        this.exception.expect(IllegalArgumentException.class);
        com.google.cloud.bigtable.data.v2.internal.NameUtil.extractTargetId((String)testTableName, (String)testAuthorizedViewName);
    }
}

