/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.it;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.Policy;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.CreateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateAuthorizedViewRequest;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableAuthorizedViewIT {
    @ClassRule
    public static final TestEnvRule testEnvRule = new TestEnvRule();
    @Rule
    public final PrefixGenerator prefixGenerator = new PrefixGenerator();
    private static final Logger LOGGER = Logger.getLogger(BigtableAuthorizedViewIT.class.getName());
    private static final int[] BACKOFF_DURATION = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static BigtableTableAdminClient tableAdmin;
    private static BigtableDataClient dataClient;
    private static Table testTable;

    @BeforeClass
    public static void setUpClass() throws InterruptedException {
        TruthJUnit.assume().withMessage("BigtableInstanceAdminClient is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        tableAdmin = testEnvRule.env().getTableAdminClient();
        dataClient = testEnvRule.env().getDataClient();
        testTable = BigtableAuthorizedViewIT.createAndPopulateTestTable(tableAdmin, dataClient);
    }

    @AfterClass
    public static void tearDownClass() {
        if (testTable != null) {
            try {
                tableAdmin.deleteTable(testTable.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAuthorizedViewAndGetAuthorizedViewTest() {
        String authorizedViewId = this.prefixGenerator.newPrefix();
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.of((String)testTable.getId(), (String)authorizedViewId).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#").setFamilySubsets("cf1", FamilySubsets.create().addQualifier("qualifier").addQualifierPrefix("prefix#"))).setDeletionProtection(false);
        try {
            AuthorizedView response = tableAdmin.createAuthorizedView(request);
            Truth.assertWithMessage((String)"Got wrong authorized view Id in CreateAuthorizedView").that(response.getId()).isEqualTo((Object)authorizedViewId);
            Truth.assertWithMessage((String)"Got wrong deletion protection in CreateAuthorizedView").that(Boolean.valueOf(response.isDeletionProtected())).isFalse();
            Truth.assertWithMessage((String)"Got wrong subset view in CreateAuthorizedView").that((Iterable)((SubsetView)response.getAuthorizedViewType()).getRowPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"row#")});
            Truth.assertWithMessage((String)"Got wrong family subsets in CreateAuthorizedView").that(((SubsetView)response.getAuthorizedViewType()).getFamilySubsets()).containsExactly((Object)"cf1", (Object)FamilySubsets.create().addQualifier("qualifier").addQualifierPrefix("prefix#"), new Object[0]);
            response = tableAdmin.getAuthorizedView(testTable.getId(), authorizedViewId);
            Truth.assertWithMessage((String)"Got wrong authorized view Id in getAuthorizedView").that(response.getId()).isEqualTo((Object)authorizedViewId);
            Truth.assertWithMessage((String)"Got wrong deletion protection in getAuthorizedView").that(Boolean.valueOf(response.isDeletionProtected())).isFalse();
            Truth.assertWithMessage((String)"Got wrong subset view in getAuthorizedView").that((Iterable)((SubsetView)response.getAuthorizedViewType()).getRowPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"row#")});
            Truth.assertWithMessage((String)"Got wrong family subsets in getAuthorizedView").that(((SubsetView)response.getAuthorizedViewType()).getFamilySubsets()).containsExactly((Object)"cf1", (Object)FamilySubsets.create().addQualifier("qualifier").addQualifierPrefix("prefix#"), new Object[0]);
        }
        finally {
            tableAdmin.deleteAuthorizedView(testTable.getId(), authorizedViewId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listAuthorizedViewsTest() {
        String authorizedViewId1 = this.prefixGenerator.newPrefix();
        String authorizedViewId2 = this.prefixGenerator.newPrefix();
        try {
            tableAdmin.createAuthorizedView(this.createAuthorizedViewRequest(authorizedViewId1));
            tableAdmin.createAuthorizedView(this.createAuthorizedViewRequest(authorizedViewId2));
            List response = tableAdmin.listAuthorizedViews(testTable.getId());
            Truth.assertWithMessage((String)"Got wrong authorized view Ids in listAuthorizedViews").that((Iterable)response).containsAtLeast((Object)tableAdmin.getAuthorizedView(testTable.getId(), authorizedViewId1).getId(), (Object)tableAdmin.getAuthorizedView(testTable.getId(), authorizedViewId2).getId(), new Object[0]);
        }
        finally {
            tableAdmin.deleteAuthorizedView(testTable.getId(), authorizedViewId1);
            tableAdmin.deleteAuthorizedView(testTable.getId(), authorizedViewId2);
        }
    }

    @Test
    public void updateAuthorizedViewAndDeleteAuthorizedViewTest() throws InterruptedException {
        String authorizedViewId = this.prefixGenerator.newPrefix();
        CreateAuthorizedViewRequest request = this.createAuthorizedViewRequest(authorizedViewId).setDeletionProtection(true);
        AuthorizedView response = tableAdmin.createAuthorizedView(request);
        Truth.assertWithMessage((String)"Got wrong deletion protection in CreateAuthorizedView").that(Boolean.valueOf(response.isDeletionProtected())).isTrue();
        try {
            tableAdmin.deleteAuthorizedView(testTable.getId(), authorizedViewId);
            Assert.fail((String)"A delete-protected authorized view should not have been able to be deleted");
        }
        catch (FailedPreconditionException e) {
            Truth.assertWithMessage((String)"Incorrect exception type").that(e.getCause()).isInstanceOf(StatusRuntimeException.class);
        }
        UpdateAuthorizedViewRequest updateRequest = UpdateAuthorizedViewRequest.of((String)testTable.getId(), (String)authorizedViewId).setDeletionProtection(false);
        response = tableAdmin.updateAuthorizedView(updateRequest);
        Truth.assertWithMessage((String)"Got wrong deletion protection in UpdateAuthorizedView").that(Boolean.valueOf(response.isDeletionProtected())).isFalse();
        tableAdmin.deleteAuthorizedView(testTable.getId(), authorizedViewId);
        try {
            for (int i = 0; i < BACKOFF_DURATION.length; ++i) {
                tableAdmin.getAuthorizedView(testTable.getId(), authorizedViewId);
                LOGGER.info("Wait for " + BACKOFF_DURATION[i] + " seconds for deleting authorized view " + authorizedViewId);
                Thread.sleep(BACKOFF_DURATION[i] * 1000);
            }
            Assert.fail((String)"AuthorizedView was not deleted.");
        }
        catch (NotFoundException e) {
            Truth.assertWithMessage((String)"Incorrect exception type").that(e.getCause()).isInstanceOf(StatusRuntimeException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void authorizedViewIamTest() {
        String authorizedViewId = this.prefixGenerator.newPrefix();
        try {
            tableAdmin.createAuthorizedView(this.createAuthorizedViewRequest(authorizedViewId));
            Policy policy = tableAdmin.getAuthorizedViewIamPolicy(testTable.getId(), authorizedViewId);
            Truth.assertThat((Object)policy).isNotNull();
            Exception actualEx = null;
            try {
                Truth.assertThat((Object)tableAdmin.setAuthorizedViewIamPolicy(testTable.getId(), authorizedViewId, policy)).isNotNull();
            }
            catch (Exception iamException) {
                actualEx = iamException;
            }
            Truth.assertThat((Throwable)actualEx).isNull();
            List permissions = tableAdmin.testAuthorizedViewIamPermission(testTable.getId(), authorizedViewId, new String[]{"bigtable.authorizedViews.get", "bigtable.authorizedViews.update", "bigtable.authorizedViews.delete"});
            Truth.assertThat((Iterable)permissions).hasSize(3);
        }
        finally {
            tableAdmin.deleteAuthorizedView(testTable.getId(), authorizedViewId);
        }
    }

    private CreateAuthorizedViewRequest createAuthorizedViewRequest(String authorizedViewId) {
        return CreateAuthorizedViewRequest.of((String)testTable.getId(), (String)authorizedViewId).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create());
    }

    private static Table createAndPopulateTestTable(BigtableTableAdminClient tableAdmin, BigtableDataClient dataClient) throws InterruptedException {
        String tableId = PrefixGenerator.newPrefix("BigtableAuthorizedViewIT#createAndPopulateTestTable");
        Table testTable = tableAdmin.createTable(CreateTableRequest.of((String)tableId).addFamily("cf1"));
        byte[] rowBytes = new byte[1024];
        Random random = new Random();
        random.nextBytes(rowBytes);
        try (Batcher batcher = dataClient.newBulkMutationBatcher(tableId);){
            for (int i = 0; i < 10; ++i) {
                batcher.add((Object)RowMutationEntry.create((String)("test-row-" + i)).setCell("cf1", ByteString.EMPTY, ByteString.copyFrom((byte[])rowBytes)));
            }
        }
        return testTable;
    }
}

