/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.it;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.Policy;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.CopyBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@RunWith(value=JUnit4.class)
public class BigtableBackupIT {
    @ClassRule
    public static final TestEnvRule testEnvRule = new TestEnvRule();
    @Rule
    public final PrefixGenerator prefixGenerator = new PrefixGenerator();
    private static final Logger LOGGER = Logger.getLogger(BigtableBackupIT.class.getName());
    private static final int[] BACKOFF_DURATION = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static BigtableTableAdminClient tableAdmin;
    private static BigtableTableAdminClient tableAdminHot;
    private static BigtableInstanceAdminClient instanceAdmin;
    private static BigtableDataClient dataClient;
    private static String targetCluster;
    private static String targetClusterHot;
    private static Table testTable;
    private static Table testTableHot;

    @BeforeClass
    public static void setUpClass() throws InterruptedException, IOException {
        TruthJUnit.assume().withMessage("BigtableInstanceAdminClient is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        tableAdmin = testEnvRule.env().getTableAdminClient();
        instanceAdmin = testEnvRule.env().getInstanceAdminClient();
        dataClient = testEnvRule.env().getDataClient();
        targetCluster = testEnvRule.env().getPrimaryClusterId();
        testTable = BigtableBackupIT.createAndPopulateTestTable(tableAdmin, dataClient);
        String newInstanceId = PrefixGenerator.newPrefix("backupIT");
        targetClusterHot = newInstanceId + "-c1";
        instanceAdmin.createInstance(CreateInstanceRequest.of((String)newInstanceId).addCluster(targetClusterHot, testEnvRule.env().getPrimaryZone(), 1, StorageType.SSD));
        tableAdminHot = BigtableTableAdminClient.create((BigtableTableAdminSettings)testEnvRule.env().getTableAdminSettings().toBuilder().setInstanceId(newInstanceId).build());
        testTableHot = tableAdminHot.createTable(CreateTableRequest.of((String)PrefixGenerator.newPrefix("hot-table")).addFamily("cf"));
    }

    @AfterClass
    public static void tearDownClass() {
        if (testTable != null) {
            try {
                tableAdmin.deleteTable(testTable.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void deleteBackupIgnoreErrors(BigtableTableAdminClient tableAdmin, String clusterId, String backupId) {
        try {
            tableAdmin.deleteBackup(clusterId, backupId);
        }
        catch (DeadlineExceededException ex) {
            LOGGER.log(Level.WARNING, "Error deleting backup", ex);
        }
    }

    private void deleteBackupIgnoreErrors(String clusterId, String backupId) {
        BigtableBackupIT.deleteBackupIgnoreErrors(tableAdmin, clusterId, backupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAndGetBackupTest() {
        String backupId = this.prefixGenerator.newPrefix();
        Instant expireTime = Instant.now().plus((TemporalAmount)Duration.ofHours((long)6L));
        CreateBackupRequest request = CreateBackupRequest.of((String)targetCluster, (String)backupId).setSourceTableId(testTable.getId()).setExpireTime(expireTime);
        try {
            Backup response = tableAdmin.createBackup(request);
            Truth.assertWithMessage((String)"Got wrong backup Id in CreateBackup").that(response.getId()).isEqualTo((Object)backupId);
            Truth.assertWithMessage((String)"Got wrong source table name in CreateBackup").that(response.getSourceTableId()).isEqualTo((Object)testTable.getId());
            Truth.assertWithMessage((String)"Got wrong expire time in CreateBackup").that((Comparable)response.getExpireTime()).isEqualTo((Object)expireTime);
            Backup result = tableAdmin.getBackup(targetCluster, backupId);
            Truth.assertWithMessage((String)"Got wrong backup Id in GetBackup API").that(result.getId()).isEqualTo((Object)backupId);
            Truth.assertWithMessage((String)"Got wrong source table name in GetBackup API").that(result.getSourceTableId()).isEqualTo((Object)testTable.getId());
            Truth.assertWithMessage((String)"Got wrong expire time in GetBackup API").that((Comparable)result.getExpireTime()).isEqualTo((Object)expireTime);
            Truth.assertWithMessage((String)"Got empty start time in GetBackup API").that((Comparable)result.getStartTime()).isNotNull();
            Truth.assertWithMessage((String)"Got wrong size bytes in GetBackup API").that(Long.valueOf(result.getSizeBytes())).isEqualTo((Object)0L);
            Truth.assertWithMessage((String)"Got wrong state in GetBackup API").that((Comparable)result.getState()).isAnyOf((Object)Backup.State.CREATING, (Object)Backup.State.READY, new Object[0]);
        }
        finally {
            this.deleteBackupIgnoreErrors(targetCluster, backupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAndGetHotBackupTest() {
        String backupId = this.prefixGenerator.newPrefix();
        Instant expireTime = Instant.now().plus((TemporalAmount)Duration.ofHours((long)24L));
        Instant hotToStandardTime = Instant.now().plus((TemporalAmount)Duration.ofHours((long)24L));
        CreateBackupRequest request = CreateBackupRequest.of((String)targetClusterHot, (String)backupId).setSourceTableId(testTableHot.getId()).setExpireTime(expireTime).setBackupType(Backup.BackupType.HOT).setHotToStandardTime(hotToStandardTime);
        try {
            Backup response = tableAdminHot.createBackup(request);
            Truth.assertWithMessage((String)"Got wrong backup Id in CreateBackup").that(response.getId()).isEqualTo((Object)backupId);
            Truth.assertWithMessage((String)"Got wrong source table name in CreateBackup").that(response.getSourceTableId()).isEqualTo((Object)testTableHot.getId());
            Truth.assertWithMessage((String)"Got wrong expire time in CreateBackup").that((Comparable)response.getExpireTime()).isEqualTo((Object)expireTime);
            Truth.assertWithMessage((String)"Got wrong backup type in CreateBackup").that((Comparable)response.getBackupType()).isEqualTo((Object)Backup.BackupType.HOT);
            Truth.assertWithMessage((String)"Got wrong hot to standard time in CreateBackup").that((Comparable)response.getHotToStandardTime()).isEqualTo((Object)hotToStandardTime);
            Backup result = tableAdminHot.getBackup(targetClusterHot, backupId);
            Truth.assertWithMessage((String)"Got wrong backup Id in GetBackup API").that(result.getId()).isEqualTo((Object)backupId);
            Truth.assertWithMessage((String)"Got wrong source table name in GetBackup API").that(result.getSourceTableId()).isEqualTo((Object)testTableHot.getId());
            Truth.assertWithMessage((String)"Got wrong expire time in GetBackup API").that((Comparable)result.getExpireTime()).isEqualTo((Object)expireTime);
            Truth.assertWithMessage((String)"Got wrong hot to standard time in GetBackup API").that((Comparable)result.getHotToStandardTime()).isEqualTo((Object)hotToStandardTime);
            Truth.assertWithMessage((String)"Got empty start time in GetBackup API").that((Comparable)result.getStartTime()).isNotNull();
            Truth.assertWithMessage((String)"Got wrong size bytes in GetBackup API").that(Long.valueOf(result.getSizeBytes())).isEqualTo((Object)0L);
            Truth.assertWithMessage((String)"Got wrong state in GetBackup API").that((Comparable)result.getState()).isAnyOf((Object)Backup.State.CREATING, (Object)Backup.State.READY, new Object[0]);
            Truth.assertWithMessage((String)"Got wrong backup type in GetBackup API").that((Comparable)result.getBackupType()).isEqualTo((Object)Backup.BackupType.HOT);
        }
        finally {
            BigtableBackupIT.deleteBackupIgnoreErrors(tableAdminHot, targetClusterHot, backupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listBackupTest() {
        String backupId1 = this.prefixGenerator.newPrefix();
        String backupId2 = this.prefixGenerator.newPrefix();
        try {
            tableAdmin.createBackup(this.createBackupRequest(backupId1));
            tableAdmin.createBackup(this.createBackupRequest(backupId2));
            List response = tableAdmin.listBackups(targetCluster);
            Truth.assertWithMessage((String)"Incorrect backup name").that((Iterable)response).containsAtLeast((Object)backupId1, (Object)backupId2, new Object[0]);
        }
        finally {
            this.deleteBackupIgnoreErrors(targetCluster, backupId1);
            this.deleteBackupIgnoreErrors(targetCluster, backupId2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateBackupTest() {
        String backupId = this.prefixGenerator.newPrefix();
        tableAdminHot.createBackup(CreateBackupRequest.of((String)targetClusterHot, (String)backupId).setSourceTableId(testTableHot.getId()).setExpireTime(Instant.now().plus((TemporalAmount)Duration.ofDays((long)15L))).setBackupType(Backup.BackupType.HOT).setHotToStandardTime(Instant.now().plus((TemporalAmount)Duration.ofDays((long)10L))));
        Instant expireTime = Instant.now().plus((TemporalAmount)Duration.ofDays((long)20L));
        UpdateBackupRequest req = UpdateBackupRequest.of((String)targetClusterHot, (String)backupId).setExpireTime(expireTime).clearHotToStandardTime();
        try {
            Backup backup = tableAdminHot.updateBackup(req);
            Truth.assertWithMessage((String)"Incorrect expire time").that((Comparable)backup.getExpireTime()).isEqualTo((Object)expireTime);
            Truth.assertWithMessage((String)"Incorrect hot to standard time").that((Comparable)backup.getHotToStandardTime()).isNull();
        }
        finally {
            BigtableBackupIT.deleteBackupIgnoreErrors(tableAdminHot, targetClusterHot, backupId);
        }
    }

    @Test
    public void deleteBackupTest() {
        String backupId = this.prefixGenerator.newPrefix();
        tableAdmin.createBackup(this.createBackupRequest(backupId));
        tableAdmin.deleteBackup(targetCluster, backupId);
        Assert.assertThrows(NotFoundException.class, () -> tableAdmin.getBackup(targetCluster, backupId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void restoreTableTest() throws InterruptedException, ExecutionException {
        String backupId = this.prefixGenerator.newPrefix();
        String restoredTableId = this.prefixGenerator.newPrefix();
        tableAdmin.createBackup(this.createBackupRequest(backupId));
        Thread.sleep(120000L);
        try {
            RestoreTableRequest req = RestoreTableRequest.of((String)targetCluster, (String)backupId).setTableId(restoredTableId);
            RestoredTableResult result = tableAdmin.restoreTable(req);
            Truth.assertWithMessage((String)"Incorrect restored table id").that(result.getTable().getId()).isEqualTo((Object)restoredTableId);
            if (result.getOptimizeRestoredTableOperationToken() != null) {
                tableAdmin.awaitOptimizeRestoredTable(result.getOptimizeRestoredTableOperationToken());
                Table restoredTable = tableAdmin.getTable(restoredTableId);
                Truth.assertWithMessage((String)"Incorrect restored table id").that(restoredTable.getId()).isEqualTo((Object)restoredTableId);
            }
        }
        finally {
            this.deleteBackupIgnoreErrors(targetCluster, backupId);
            tableAdmin.deleteTable(restoredTableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crossInstanceRestoreTest() throws InterruptedException, IOException, ExecutionException, TimeoutException {
        String backupId = this.prefixGenerator.newPrefix();
        String restoredTableId = this.prefixGenerator.newPrefix();
        tableAdmin.createBackup(CreateBackupRequest.of((String)targetCluster, (String)backupId).setSourceTableId(testTable.getId()).setExpireTime(Instant.now().plus((TemporalAmount)Duration.ofHours((long)6L))));
        Stopwatch stopwatch = Stopwatch.createStarted();
        String targetInstance = this.prefixGenerator.newPrefix();
        instanceAdmin.createInstance(CreateInstanceRequest.of((String)targetInstance).addCluster(targetInstance, testEnvRule.env().getSecondaryZone(), 1, StorageType.SSD).setDisplayName("backups-dest-test-instance").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
        try (BigtableTableAdminClient destTableAdmin = testEnvRule.env().getTableAdminClientForInstance(targetInstance);){
            Thread.sleep(Duration.ofMinutes((long)2L).minus(Duration.ofMillis((long)stopwatch.elapsed(TimeUnit.MILLISECONDS))).toMillis());
            try {
                RestoreTableRequest req = RestoreTableRequest.of((String)testEnvRule.env().getInstanceId(), (String)targetCluster, (String)backupId).setTableId(restoredTableId);
                RestoredTableResult result = destTableAdmin.restoreTable(req);
                Truth.assertWithMessage((String)"Incorrect restored table id").that(result.getTable().getId()).isEqualTo((Object)restoredTableId);
                Truth.assertWithMessage((String)"Incorrect instance id").that(result.getTable().getInstanceId()).isEqualTo((Object)targetInstance);
                Truth.assertWithMessage((String)"Empty OptimizeRestoredTable token").that((Object)result.getOptimizeRestoredTableOperationToken()).isNotNull();
                destTableAdmin.awaitOptimizeRestoredTable(result.getOptimizeRestoredTableOperationToken());
                destTableAdmin.getTable(restoredTableId);
            }
            finally {
                this.deleteBackupIgnoreErrors(targetCluster, backupId);
                instanceAdmin.deleteInstance(targetInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyBackupTest() throws InterruptedException, IOException, ExecutionException, TimeoutException {
        String backupId = this.prefixGenerator.newPrefix();
        String copiedBackupId = this.prefixGenerator.newPrefix();
        Instant expireTime = Instant.now().plus((TemporalAmount)Duration.ofHours((long)36L));
        tableAdmin.createBackup(CreateBackupRequest.of((String)targetCluster, (String)backupId).setSourceTableId(testTable.getId()).setExpireTime(expireTime));
        try {
            CopyBackupRequest req = CopyBackupRequest.of((String)targetCluster, (String)backupId).setDestination(targetCluster, copiedBackupId).setExpireTime(expireTime);
            Backup result = tableAdmin.copyBackup(req);
            Truth.assertWithMessage((String)"Got wrong copied backup id in CopyBackup API").that(result.getId()).isEqualTo((Object)copiedBackupId);
            Truth.assertWithMessage((String)"Got wrong source backup id in CopyBackup API").that(result.getSourceBackupId()).isEqualTo((Object)backupId);
            Truth.assertWithMessage((String)"Got wrong expire time in CopyBackup API").that((Comparable)result.getExpireTime()).isEqualTo((Object)expireTime);
            Truth.assertWithMessage((String)"Got empty start time in CopyBackup API").that((Comparable)result.getStartTime()).isNotNull();
            Truth.assertWithMessage((String)"Got wrong state in CopyBackup API").that((Comparable)result.getState()).isAnyOf((Object)Backup.State.CREATING, (Object)Backup.State.READY, new Object[0]);
        }
        finally {
            this.deleteBackupIgnoreErrors(targetCluster, copiedBackupId);
            this.deleteBackupIgnoreErrors(targetCluster, backupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crossInstanceCopyBackupTest() throws InterruptedException, IOException, ExecutionException, TimeoutException {
        String backupId = this.prefixGenerator.newPrefix();
        String copiedBackupId = this.prefixGenerator.newPrefix();
        Instant expireTime = Instant.now().plus((TemporalAmount)Duration.ofHours((long)36L));
        tableAdmin.createBackup(CreateBackupRequest.of((String)targetCluster, (String)backupId).setSourceTableId(testTable.getId()).setExpireTime(expireTime));
        String destInstance = this.prefixGenerator.newPrefix();
        String destCluster = this.prefixGenerator.newPrefix();
        instanceAdmin.createInstance(CreateInstanceRequest.of((String)destInstance).addCluster(destCluster, testEnvRule.env().getSecondaryZone(), 1, StorageType.SSD).setDisplayName("backups-dest-test-instance").addLabel("state", "readytodelete").setType(Instance.Type.PRODUCTION));
        try (BigtableTableAdminClient destTableAdmin = testEnvRule.env().getTableAdminClientForInstance(destInstance);){
            try {
                CopyBackupRequest req = CopyBackupRequest.of((String)targetCluster, (String)backupId).setSourceInstance(testEnvRule.env().getInstanceId()).setDestination(destCluster, copiedBackupId).setExpireTime(expireTime);
                Backup result = destTableAdmin.copyBackup(req);
                Truth.assertWithMessage((String)"Got wrong copied backup id in CopyBackup API").that(result.getId()).isEqualTo((Object)copiedBackupId);
                Truth.assertWithMessage((String)"Got wrong source backup id in CopyBackup API").that(result.getSourceBackupId()).isEqualTo((Object)backupId);
                Truth.assertWithMessage((String)"Got wrong expire time in CopyBackup API").that((Comparable)result.getExpireTime()).isEqualTo((Object)expireTime);
                Truth.assertWithMessage((String)"Got empty start time in CopyBackup API").that((Comparable)result.getStartTime()).isNotNull();
                Truth.assertWithMessage((String)"Got wrong state in CopyBackup API").that((Comparable)result.getState()).isAnyOf((Object)Backup.State.CREATING, (Object)Backup.State.READY, new Object[0]);
            }
            finally {
                BigtableBackupIT.deleteBackupIgnoreErrors(destTableAdmin, destCluster, copiedBackupId);
                this.deleteBackupIgnoreErrors(targetCluster, backupId);
                instanceAdmin.deleteInstance(destInstance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backupIamTest() {
        String backupId = this.prefixGenerator.newPrefix();
        try {
            tableAdmin.createBackup(this.createBackupRequest(backupId));
            Policy policy = tableAdmin.getBackupIamPolicy(targetCluster, backupId);
            Truth.assertThat((Object)policy).isNotNull();
            Exception actualEx = null;
            try {
                Truth.assertThat((Object)tableAdmin.setBackupIamPolicy(targetCluster, backupId, policy)).isNotNull();
            }
            catch (Exception iamException) {
                actualEx = iamException;
            }
            Truth.assertThat((Throwable)actualEx).isNull();
            List permissions = tableAdmin.testBackupIamPermission(targetCluster, backupId, new String[]{"bigtable.backups.get", "bigtable.backups.delete", "bigtable.backups.update", "bigtable.backups.restore"});
            Truth.assertThat((Iterable)permissions).hasSize(4);
        }
        finally {
            this.deleteBackupIgnoreErrors(targetCluster, backupId);
        }
    }

    private CreateBackupRequest createBackupRequest(String backupId) {
        return CreateBackupRequest.of((String)targetCluster, (String)backupId).setSourceTableId(testTable.getId()).setExpireTime(Instant.now().plus((TemporalAmount)Duration.ofDays((long)15L)));
    }

    private static Table createAndPopulateTestTable(BigtableTableAdminClient tableAdmin, BigtableDataClient dataClient) throws InterruptedException {
        String tableId = PrefixGenerator.newPrefix("BigtableBackupIT#createAndPopulateTestTable");
        Table testTable = tableAdmin.createTable(CreateTableRequest.of((String)tableId).addFamily("cf1"));
        byte[] rowBytes = new byte[1024];
        Random random = new Random();
        random.nextBytes(rowBytes);
        try (Batcher batcher = dataClient.newBulkMutationBatcher(tableId);){
            for (int i = 0; i < 10; ++i) {
                batcher.add((Object)RowMutationEntry.create((String)("test-row-" + i)).setCell("cf1", ByteString.EMPTY, ByteString.copyFrom((byte[])rowBytes)));
            }
        }
        return testTable;
    }
}

