/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.it;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.Policy;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.cloud.bigtable.admin.v2.models.ConsistencyRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateTableRequest;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.collect.Maps;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BigtableTableAdminClientIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    @Rule
    public final PrefixGenerator prefixGenerator = new PrefixGenerator();
    private BigtableTableAdminClient tableAdmin;
    private String tableId;

    @Before
    public void setUp() {
        this.tableAdmin = testEnvRule.env().getTableAdminClient();
        this.tableId = this.prefixGenerator.newPrefix();
    }

    @After
    public void tearDown() {
        try {
            testEnvRule.env().getTableAdminClient().deleteTable(this.tableId);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void createTable() {
        TruthJUnit.assume().withMessage("Emulator doesn't return proper responses for CreateTable").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        CreateTableRequest createTableReq = CreateTableRequest.of((String)this.tableId).addFamily("cf1").addFamily("cf2", (GCRules.GCRule)GCRules.GCRULES.maxVersions(10)).addSplit(ByteString.copyFromUtf8((String)"b")).addSplit(ByteString.copyFromUtf8((String)"q")).addChangeStreamRetention(Duration.ofDays((long)2L));
        Table tableResponse = this.tableAdmin.createTable(createTableReq);
        Assert.assertEquals((Object)this.tableId, (Object)tableResponse.getId());
        HashMap columnFamilyById = Maps.newHashMap();
        for (ColumnFamily columnFamily : tableResponse.getColumnFamilies()) {
            columnFamilyById.put(columnFamily.getId(), columnFamily);
        }
        Assert.assertEquals((long)2L, (long)tableResponse.getColumnFamilies().size());
        Assert.assertFalse((boolean)((ColumnFamily)columnFamilyById.get("cf1")).hasGCRule());
        Assert.assertTrue((boolean)((ColumnFamily)columnFamilyById.get("cf2")).hasGCRule());
        Assert.assertEquals((long)10L, (long)((GCRules.VersionRule)((ColumnFamily)columnFamilyById.get("cf2")).getGCRule()).getMaxVersions());
        Assert.assertEquals((Object)Duration.ofDays((long)2L), (Object)tableResponse.getChangeStreamRetention());
        UpdateTableRequest updateTableRequest = UpdateTableRequest.of((String)this.tableId).disableChangeStreamRetention();
        this.tableAdmin.updateTable(updateTableRequest);
    }

    @Test
    public void updateTable() {
        TruthJUnit.assume().withMessage("Emulator doesn't return proper responses for CreateTable").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        CreateTableRequest createTableReq = CreateTableRequest.of((String)this.tableId).addFamily("cf1").addChangeStreamRetention(Duration.ofDays((long)2L));
        Table tableResponse = this.tableAdmin.createTable(createTableReq);
        Assert.assertEquals((Object)this.tableId, (Object)tableResponse.getId());
        Assert.assertEquals((Object)Duration.ofDays((long)2L), (Object)tableResponse.getChangeStreamRetention());
        UpdateTableRequest updateTableRequest = UpdateTableRequest.of((String)this.tableId).addChangeStreamRetention(Duration.ofDays((long)4L));
        tableResponse = this.tableAdmin.updateTable(updateTableRequest);
        Assert.assertEquals((Object)this.tableId, (Object)tableResponse.getId());
        Assert.assertEquals((Object)Duration.ofDays((long)4L), (Object)tableResponse.getChangeStreamRetention());
        updateTableRequest = UpdateTableRequest.of((String)this.tableId).disableChangeStreamRetention();
        tableResponse = this.tableAdmin.updateTable(updateTableRequest);
        Assert.assertEquals((Object)this.tableId, (Object)tableResponse.getId());
        Assert.assertNull((Object)tableResponse.getChangeStreamRetention());
    }

    @Test
    public void modifyFamilies() {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        ModifyColumnFamiliesRequest modifyFamiliesReq = ModifyColumnFamiliesRequest.of((String)this.tableId).addFamily("mf1").addFamily("mf2", (GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1000L, (long)20000L))).updateFamily("mf1", (GCRules.GCRule)GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)100L))).rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1))).addFamily("mf3", (GCRules.GCRule)GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)2000L))).rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(10))).addFamily("mf4", (GCRules.GCRule)GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)360L)))).addFamily("mf5").addFamily("mf6").dropFamily("mf5").dropFamily("mf6").addFamily("mf7");
        Table tableResponse = this.tableAdmin.modifyFamilies(modifyFamiliesReq);
        HashMap columnFamilyById = Maps.newHashMap();
        for (ColumnFamily columnFamily : tableResponse.getColumnFamilies()) {
            columnFamilyById.put(columnFamily.getId(), columnFamily);
        }
        Assert.assertEquals((long)5L, (long)columnFamilyById.size());
        Assert.assertNotNull(columnFamilyById.get("mf1"));
        Assert.assertNotNull(columnFamilyById.get("mf2"));
        Assert.assertEquals((long)2L, (long)((GCRules.UnionRule)((ColumnFamily)columnFamilyById.get("mf1")).getGCRule()).getRulesList().size());
        Assert.assertEquals((long)1000L, (long)((GCRules.DurationRule)((ColumnFamily)columnFamilyById.get("mf2")).getGCRule()).getMaxAge().getSeconds());
        Assert.assertEquals((long)20000L, (long)((GCRules.DurationRule)((ColumnFamily)columnFamilyById.get("mf2")).getGCRule()).getMaxAge().getNano());
        Assert.assertEquals((long)2L, (long)((GCRules.IntersectionRule)((ColumnFamily)columnFamilyById.get("mf3")).getGCRule()).getRulesList().size());
        Assert.assertEquals((long)360L, (long)((GCRules.DurationRule)((ColumnFamily)columnFamilyById.get("mf4")).getGCRule()).getMaxAge().getSeconds());
        Assert.assertNotNull(columnFamilyById.get("mf7"));
    }

    @Test
    public void deleteTable() {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        this.tableAdmin.deleteTable(this.tableId);
    }

    @Test
    public void getTable() {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        Table tableResponse = this.tableAdmin.getTable(this.tableId);
        Assert.assertNotNull((Object)tableResponse);
        Assert.assertEquals((Object)this.tableId, (Object)tableResponse.getId());
    }

    @Test
    public void listTables() {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        List tables = this.tableAdmin.listTables();
        Assert.assertNotNull((Object)tables);
        Assert.assertFalse((String)"List tables did not return any tables", (boolean)tables.isEmpty());
    }

    @Test
    public void listTablesAsync() throws Exception {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        List tables = (List)this.tableAdmin.listTablesAsync().get();
        Assert.assertNotNull((Object)tables);
        Assert.assertFalse((String)"List tables did not return any tables", (boolean)tables.isEmpty());
    }

    @Test
    public void dropRowRange() {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        this.tableAdmin.dropRowRange(this.tableId, "rowPrefix");
        this.tableAdmin.dropAllRows(this.tableId);
    }

    @Test
    public void awaitReplication() {
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        this.tableAdmin.awaitReplication(this.tableId);
    }

    @Test
    @Ignore
    public void awaitDataBoostConsistency() {
        TruthJUnit.assume().withMessage("Data Boost consistency not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        ConsistencyRequest consistencyRequest = ConsistencyRequest.forDataBoost((String)this.tableId);
        this.tableAdmin.awaitConsistency(consistencyRequest);
    }

    @Test
    public void iamUpdateTest() {
        TruthJUnit.assume().withMessage("Emulator doesn't return proper responses for IAM Policy operations").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        this.tableAdmin.createTable(CreateTableRequest.of((String)this.tableId));
        Policy policy = this.tableAdmin.getIamPolicy(this.tableId);
        Truth.assertThat((Object)policy).isNotNull();
        Exception actualEx = null;
        try {
            Truth.assertThat((Object)this.tableAdmin.setIamPolicy(this.tableId, policy)).isNotNull();
        }
        catch (Exception iamException) {
            actualEx = iamException;
        }
        Truth.assertThat((Throwable)actualEx).isNull();
        List permissions = this.tableAdmin.testIamPermission(this.tableId, new String[]{"bigtable.tables.readRows", "bigtable.tables.mutateRows"});
        Truth.assertThat((Iterable)permissions).hasSize(2);
    }
}

