/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AppProfileTest {
    private static final com.google.bigtable.admin.v2.AppProfile TEST_PROTO = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true).build()).setEtag("my-etag").build();

    @Test
    public void testFromProto() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)TEST_PROTO);
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true));
    }

    @Test
    public void testFromProtoWithMultiCluster() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.MultiClusterRoutingPolicy.of());
    }

    @Test
    public void testFromProtoWithMultiClusterWithIds() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.MultiClusterRoutingPolicy.of((String[])new String[]{"cluster-id-1", "cluster-id-2"}));
    }

    @Test
    public void testFromProtoWithStandardIsolation() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true).build()).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM).build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true));
        Truth.assertThat((Object)profile.getIsolationPolicy()).isEqualTo((Object)AppProfile.StandardIsolationPolicy.of((AppProfile.Priority)AppProfile.Priority.MEDIUM));
    }

    @Test
    public void testNoNameError() {
        Exception actualException = null;
        try {
            AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)TEST_PROTO.toBuilder().setName("").build());
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testNoPolicyError() {
        Exception actualException = null;
        try {
            AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)TEST_PROTO.toBuilder().clearSingleClusterRouting().build());
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testEquals() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest = UpdateAppProfileRequest.of((AppProfile)profile);
        UpdateAppProfileRequest updateAppProfileRequest2 = UpdateAppProfileRequest.of((AppProfile)profile);
        Truth.assertThat((Object)updateAppProfileRequest).isEqualTo((Object)updateAppProfileRequest2);
        AppProfile profile2 = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project-2", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest3 = UpdateAppProfileRequest.of((AppProfile)profile2);
        Truth.assertThat((Object)updateAppProfileRequest).isNotEqualTo((Object)updateAppProfileRequest3);
    }

    @Test
    public void testHashCode() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest = UpdateAppProfileRequest.of((AppProfile)profile);
        UpdateAppProfileRequest updateAppProfileRequest2 = UpdateAppProfileRequest.of((AppProfile)profile);
        Truth.assertThat((Integer)updateAppProfileRequest.hashCode()).isEqualTo((Object)updateAppProfileRequest2.hashCode());
        AppProfile profile2 = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project-2", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).build()).setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_MEDIUM).build()).setEtag("my-etag").build());
        UpdateAppProfileRequest updateAppProfileRequest3 = UpdateAppProfileRequest.of((AppProfile)profile2);
        Truth.assertThat((Integer)updateAppProfileRequest.hashCode()).isNotEqualTo((Object)updateAppProfileRequest3.hashCode());
    }

    @Test
    public void testFromProtoWithDataBoostIsolation() {
        AppProfile producer = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true).build()).setDataBoostIsolationReadOnly(AppProfile.DataBoostIsolationReadOnly.newBuilder().setComputeBillingOwner(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.HOST_PAYS)).setEtag("my-etag").build());
        Truth.assertThat((String)producer.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)producer.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)producer.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)producer.getPolicy()).isEqualTo((Object)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true));
        Truth.assertThat((Object)producer.getIsolationPolicy()).isEqualTo((Object)AppProfile.DataBoostIsolationReadOnlyPolicy.of((AppProfile.ComputeBillingOwner)AppProfile.ComputeBillingOwner.HOST_PAYS));
        AppProfile consumer = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true).build()).setDataBoostIsolationReadOnly(AppProfile.DataBoostIsolationReadOnly.newBuilder().setComputeBillingOwner(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.COMPUTE_BILLING_OWNER_UNSPECIFIED)).setEtag("my-etag").build());
        Truth.assertThat((String)consumer.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)consumer.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)consumer.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)consumer.getPolicy()).isEqualTo((Object)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true));
        Truth.assertThat((Object)consumer.getIsolationPolicy()).isEqualTo((Object)AppProfile.DataBoostIsolationReadOnlyPolicy.of((AppProfile.ComputeBillingOwner)AppProfile.ComputeBillingOwner.UNSPECIFIED));
    }

    @Test
    public void testFromProtoWithRowAffinityNoClusterGroup() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()).build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        System.out.println(profile.getPolicy());
        System.out.println(AppProfile.MultiClusterRoutingPolicy.withRowAffinity());
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.MultiClusterRoutingPolicy.withRowAffinity());
    }

    @Test
    public void testFromProtoWithRowAffinityClusterGroup() {
        AppProfile profile = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)com.google.bigtable.admin.v2.AppProfile.newBuilder().setName(AppProfileName.of((String)"my-project", (String)"my-instance", (String)"my-profile").toString()).setDescription("my description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds((Iterable)ImmutableList.of((Object)"cluster-id-1", (Object)"cluster-id-2")).setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()).build()).setEtag("my-etag").build());
        Truth.assertThat((String)profile.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)profile.getId()).isEqualTo((Object)"my-profile");
        Truth.assertThat((String)profile.getDescription()).isEqualTo((Object)"my description");
        Truth.assertThat((Object)profile.getPolicy()).isEqualTo((Object)AppProfile.MultiClusterRoutingPolicy.withRowAffinity((String[])new String[]{"cluster-id-1", "cluster-id-2"}));
    }
}

