/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.bigtable.admin.v2.AuthorizedViewName;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AuthorizedViewTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String TABLE_ID = "my-table";
    private static final String AUTHORIZED_VIEW_ID = "my-authorized-view";

    @Test
    public void testFromProto() {
        AuthorizedViewName authorizedViewName = AuthorizedViewName.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        AuthorizedView.SubsetView subsetViewProto = AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row1#")).addRowPrefixes(ByteString.copyFromUtf8((String)"row2#")).putFamilySubsets("family1", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column1")).addQualifiers(ByteString.copyFromUtf8((String)"column2")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"column3#")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"column4#")).build()).putFamilySubsets("family2", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column5")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"")).build()).build();
        com.google.bigtable.admin.v2.AuthorizedView authorizedViewProto = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(authorizedViewName.toString()).setDeletionProtection(true).setSubsetView(subsetViewProto).build();
        AuthorizedView result = AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)authorizedViewProto);
        Truth.assertThat((String)result.getId()).isEqualTo((Object)AUTHORIZED_VIEW_ID);
        Truth.assertThat((String)result.getTableId()).isEqualTo((Object)TABLE_ID);
        Truth.assertThat((Boolean)result.isDeletionProtected()).isTrue();
        SubsetView subsetViewResult = (SubsetView)result.getAuthorizedViewType();
        Truth.assertThat((Object)subsetViewResult).isEqualTo((Object)SubsetView.fromProto((AuthorizedView.SubsetView)subsetViewProto));
        Truth.assertThat((Iterable)subsetViewResult.getRowPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"row1#"), ByteString.copyFromUtf8((String)"row2#")});
        Map familySubsetsResult = subsetViewResult.getFamilySubsets();
        Truth.assertThat((Map)familySubsetsResult).containsExactly((Object)"family1", (Object)FamilySubsets.fromProto((AuthorizedView.FamilySubsets)subsetViewProto.getFamilySubsetsOrThrow("family1")), new Object[]{"family2", FamilySubsets.fromProto((AuthorizedView.FamilySubsets)subsetViewProto.getFamilySubsetsOrThrow("family2"))});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family1")).getQualifiers()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column1"), ByteString.copyFromUtf8((String)"column2")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family1")).getQualifierPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column3#"), ByteString.copyFromUtf8((String)"column4#")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family2")).getQualifiers()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column5")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family2")).getQualifierPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"")});
    }

    @Test
    public void testRequiresName() {
        com.google.bigtable.admin.v2.AuthorizedView proto = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setDeletionProtection(true).setSubsetView(AuthorizedView.SubsetView.newBuilder().build()).build();
        Exception actualException = null;
        try {
            AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)proto);
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testRequiresAuthorizedViewType() {
        AuthorizedViewName authorizedViewName = AuthorizedViewName.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        com.google.bigtable.admin.v2.AuthorizedView proto = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(authorizedViewName.toString()).setDeletionProtection(true).build();
        Exception actualException = null;
        try {
            AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)proto);
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testEquality() {
        AuthorizedViewName authorizedViewName = AuthorizedViewName.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        com.google.bigtable.admin.v2.AuthorizedView proto = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(authorizedViewName.toString()).setDeletionProtection(true).setSubsetView(AuthorizedView.SubsetView.newBuilder().build()).build();
        AuthorizedView authorizedView = AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)proto);
        Truth.assertThat((Object)authorizedView).isEqualTo((Object)AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)proto));
        Truth.assertThat((Object)authorizedView).isNotEqualTo((Object)com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(authorizedViewName.toString()).setDeletionProtection(false).setSubsetView(AuthorizedView.SubsetView.newBuilder().build()).build());
    }

    @Test
    public void testHashCode() {
        AuthorizedViewName authorizedViewName = AuthorizedViewName.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        com.google.bigtable.admin.v2.AuthorizedView proto = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(authorizedViewName.toString()).setDeletionProtection(true).setSubsetView(AuthorizedView.SubsetView.newBuilder().build()).build();
        AuthorizedView authorizedView = AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)proto);
        Truth.assertThat((Integer)authorizedView.hashCode()).isEqualTo((Object)AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)proto).hashCode());
        Truth.assertThat((Integer)authorizedView.hashCode()).isNotEqualTo((Object)com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(authorizedViewName.toString()).setDeletionProtection(false).setSubsetView(AuthorizedView.SubsetView.newBuilder().build()).build().hashCode());
    }
}

