/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AutoscalingLimits;
import com.google.bigtable.admin.v2.AutoscalingTargets;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.ClusterAutoscalingConfig;
import com.google.common.truth.Truth;
import com.google.protobuf.FieldMask;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ClusterAutoscalingConfigTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String CLUSTER_ID = "my-cluster";

    @Test
    public void testToProto() {
        ClusterAutoscalingConfig request = ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setMaxNodes(10).setMinNodes(3).setCpuUtilizationTargetPercent(30);
        PartialUpdateClusterRequest partialUpdateClusterRequestProto = request.toProto(PROJECT_ID);
        AutoscalingTargets autoscalingTargets = AutoscalingTargets.newBuilder().setCpuUtilizationPercent(30).build();
        AutoscalingLimits autoscalingLimits = AutoscalingLimits.newBuilder().setMinServeNodes(3).setMaxServeNodes(10).build();
        Cluster.ClusterAutoscalingConfig clusterAutoscalingConfig = Cluster.ClusterAutoscalingConfig.newBuilder().setAutoscalingTargets(autoscalingTargets).setAutoscalingLimits(autoscalingLimits).build();
        Cluster.ClusterConfig clusterConfig = Cluster.ClusterConfig.newBuilder().setClusterAutoscalingConfig(clusterAutoscalingConfig).build();
        Cluster cluster = Cluster.newBuilder().setName(NameUtil.formatClusterName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID)).setClusterConfig(clusterConfig).build();
        PartialUpdateClusterRequest requestProto = PartialUpdateClusterRequest.newBuilder().setUpdateMask(FieldMask.newBuilder().addPaths("cluster_config.cluster_autoscaling_config.autoscaling_limits.max_serve_nodes").addPaths("cluster_config.cluster_autoscaling_config.autoscaling_limits.min_serve_nodes").addPaths("cluster_config.cluster_autoscaling_config.autoscaling_targets.cpu_utilization_percent")).setCluster(cluster).build();
        Truth.assertThat((Object)partialUpdateClusterRequestProto).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        ClusterAutoscalingConfig request = ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setCpuUtilizationTargetPercent(10).setMaxNodes(2).setMinNodes(1);
        Truth.assertThat((Object)request).isEqualTo((Object)ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setCpuUtilizationTargetPercent(10).setMaxNodes(2).setMinNodes(1));
        Truth.assertThat((Object)request).isNotEqualTo((Object)ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setCpuUtilizationTargetPercent(1).setMaxNodes(2).setMinNodes(1));
    }

    @Test
    public void testHashCode() {
        ClusterAutoscalingConfig request = ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setMaxNodes(10);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setMaxNodes(10).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)ClusterAutoscalingConfig.of((String)INSTANCE_ID, (String)CLUSTER_ID).setMinNodes(50).hashCode());
    }
}

