/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Cluster;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ClusterTest {
    @Test
    public void testFromProto() {
        com.google.bigtable.admin.v2.Cluster proto = com.google.bigtable.admin.v2.Cluster.newBuilder().setName("projects/my-project/instances/my-instance/clusters/my-cluster").setLocation("projects/my-project/locations/us-east1-c").setState(Cluster.State.READY).setServeNodes(30).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build();
        Cluster result = Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)proto);
        Truth.assertThat((String)result.getId()).isEqualTo((Object)"my-cluster");
        Truth.assertThat((String)result.getInstanceId()).isEqualTo((Object)"my-instance");
        Truth.assertThat((String)result.getZone()).isEqualTo((Object)"us-east1-c");
        Truth.assertThat((Comparable)result.getState()).isEqualTo((Object)Cluster.State.READY);
        Truth.assertThat((Integer)result.getServeNodes()).isEqualTo((Object)30);
        Truth.assertThat((Comparable)result.getStorageType()).isEqualTo((Object)StorageType.SSD);
        Truth.assertThat((String)result.getKmsKeyName()).isEqualTo(null);
    }

    @Test
    public void testFromProtoCmek() {
        com.google.bigtable.admin.v2.Cluster proto = com.google.bigtable.admin.v2.Cluster.newBuilder().setName("projects/my-project/instances/my-instance/clusters/my-cluster").setLocation("projects/my-project/locations/us-east1-c").setState(Cluster.State.READY).setServeNodes(30).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().setKmsKeyName("projects/my-project/locations/us-east1-c/keyRings/my-key-ring/cryptoKeys/my-key").build()).build();
        Cluster result = Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)proto);
        Truth.assertThat((String)result.getKmsKeyName()).isEqualTo((Object)"projects/my-project/locations/us-east1-c/keyRings/my-key-ring/cryptoKeys/my-key");
    }

    @Test
    public void testRequiresName() {
        com.google.bigtable.admin.v2.Cluster proto = com.google.bigtable.admin.v2.Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setState(Cluster.State.READY).setServeNodes(30).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build();
        Exception actualException = null;
        try {
            Cluster.fromProto((com.google.bigtable.admin.v2.Cluster)proto);
        }
        catch (Exception e) {
            actualException = e;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testStateEnumUpToDate() {
        ArrayList validProtoValues = Lists.newArrayList((Object[])Cluster.State.values());
        ArrayList validModelValues = Lists.newArrayList((Object[])Cluster.State.values());
        ArrayList actualModelValues = Lists.newArrayList();
        for (Cluster.State protoValue : validProtoValues) {
            Cluster.State modelValue = Cluster.State.fromProto((Cluster.State)protoValue);
            actualModelValues.add(modelValue);
        }
        Truth.assertThat((Iterable)actualModelValues).containsExactlyElementsIn((Iterable)validModelValues);
    }
}

