/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.cloud.bigtable.admin.v2.models.ConsistencyRequest;
import com.google.cloud.bigtable.data.v2.internal.TableAdminRequestContext;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConsistencyRequestTest {
    private final String PROJECT_ID = "my-project";
    private final String INSTANCE_ID = "my-instance";
    private final String TABLE_ID = "my-table";
    private final String CONSISTENCY_TOKEN = "my-token";

    @Test
    public void testToCheckConsistencyProtoWithStandard() {
        ConsistencyRequest consistencyRequest = ConsistencyRequest.forReplication((String)"my-table");
        TableAdminRequestContext requestContext = TableAdminRequestContext.create((String)"my-project", (String)"my-instance");
        CheckConsistencyRequest checkConsistencyRequest = consistencyRequest.toCheckConsistencyProto(requestContext, "my-token");
        Truth.assertThat((Boolean)checkConsistencyRequest.getName().equals("my-table"));
        Truth.assertThat((Boolean)checkConsistencyRequest.getConsistencyToken().equals("my-token"));
        Truth.assertThat((Boolean)checkConsistencyRequest.getModeCase().equals((Object)CheckConsistencyRequest.ModeCase.STANDARD_READ_REMOTE_WRITES));
    }

    @Test
    public void testToCheckConsistencyProtoWithDataBoost() {
        ConsistencyRequest consistencyRequest = ConsistencyRequest.forDataBoost((String)"my-table");
        TableAdminRequestContext requestContext = TableAdminRequestContext.create((String)"my-project", (String)"my-instance");
        CheckConsistencyRequest checkConsistencyRequest = consistencyRequest.toCheckConsistencyProto(requestContext, "my-token");
        Truth.assertThat((Boolean)checkConsistencyRequest.getName().equals("my-table"));
        Truth.assertThat((Boolean)checkConsistencyRequest.getConsistencyToken().equals("my-token"));
        Truth.assertThat((Boolean)checkConsistencyRequest.getModeCase().equals((Object)CheckConsistencyRequest.ModeCase.DATA_BOOST_READ_LOCAL_WRITES));
    }

    @Test
    public void testToGenerateTokenProto() {
        ConsistencyRequest consistencyRequest = ConsistencyRequest.forDataBoost((String)"my-table");
        TableAdminRequestContext requestContext = TableAdminRequestContext.create((String)"my-project", (String)"my-instance");
        GenerateConsistencyTokenRequest generateRequest = consistencyRequest.toGenerateTokenProto(requestContext);
        Truth.assertThat((Boolean)generateRequest.getName().equals("my-table"));
    }
}

