/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.CopyBackupRequest;
import com.google.common.truth.Truth;
import com.google.protobuf.util.Timestamps;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@RunWith(value=JUnit4.class)
public class CopyBackupRequestTest {
    private static final String BACKUP_ID = "my-backup";
    private static final String CLUSTER_ID = "my-cluster";
    private static final String INSTANCE_ID = "my-instance";
    private static final String PROJECT_ID = "my-project";
    private static final String SOURCE_BACKUP_ID = "source-backup-id";
    private static final String SOURCE_CLUSTER_ID = "source-cluster-id";
    private static final String SOURCE_INSTANCE_ID = "source-instance-id";
    private static final String SOURCE_PROJECT_ID = "source-project-id";
    private static final Instant EXPIRE_TIME = Instant.now().plus((TemporalAmount)Duration.ofDays((long)15L));

    @Test
    public void testToProto() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        com.google.bigtable.admin.v2.CopyBackupRequest requestProto = com.google.bigtable.admin.v2.CopyBackupRequest.newBuilder().setParent(NameUtil.formatClusterName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID)).setSourceBackup(NameUtil.formatBackupName((String)PROJECT_ID, (String)INSTANCE_ID, (String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID)).setExpireTime(Timestamps.fromMillis((long)EXPIRE_TIME.toEpochMilli())).setBackupId(BACKUP_ID).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testToProtoCrossInstance() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        com.google.bigtable.admin.v2.CopyBackupRequest requestProto = com.google.bigtable.admin.v2.CopyBackupRequest.newBuilder().setParent(NameUtil.formatClusterName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID)).setSourceBackup(NameUtil.formatBackupName((String)PROJECT_ID, (String)SOURCE_INSTANCE_ID, (String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID)).setExpireTime(Timestamps.fromMillis((long)EXPIRE_TIME.toEpochMilli())).setBackupId(BACKUP_ID).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testToProtoCrossProject() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        com.google.bigtable.admin.v2.CopyBackupRequest requestProto = com.google.bigtable.admin.v2.CopyBackupRequest.newBuilder().setParent(NameUtil.formatClusterName((String)PROJECT_ID, (String)INSTANCE_ID, (String)CLUSTER_ID)).setSourceBackup(NameUtil.formatBackupName((String)SOURCE_PROJECT_ID, (String)SOURCE_INSTANCE_ID, (String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID)).setExpireTime(Timestamps.fromMillis((long)EXPIRE_TIME.toEpochMilli())).setBackupId(BACKUP_ID).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Object)request).isEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME));
        Truth.assertThat((Object)request).isNotEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, "another-backup").setExpireTime(EXPIRE_TIME));
    }

    @Test
    public void testEqualityCrossInstance() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Object)request).isEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME));
        Truth.assertThat((Object)request).isNotEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, "another-backup").setExpireTime(EXPIRE_TIME));
    }

    @Test
    public void testEqualityCrossProject() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Object)request).isEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME));
        Truth.assertThat((Object)request).isNotEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, "another-backup").setExpireTime(EXPIRE_TIME));
    }

    @Test
    public void testHashCode() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setDestination(CLUSTER_ID, "another-backup").setExpireTime(EXPIRE_TIME).hashCode());
    }

    @Test
    public void testHashCodeCrossInstance() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, "another-backup").setExpireTime(EXPIRE_TIME).hashCode());
    }

    @Test
    public void testHashCodeCrossProject() {
        CopyBackupRequest request = CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, BACKUP_ID).setExpireTime(EXPIRE_TIME).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)CopyBackupRequest.of((String)SOURCE_CLUSTER_ID, (String)SOURCE_BACKUP_ID).setSourceInstance(SOURCE_PROJECT_ID, SOURCE_INSTANCE_ID).setDestination(CLUSTER_ID, "another-backup").setExpireTime(EXPIRE_TIME).hashCode());
    }
}

