/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.CreateAppProfileRequest;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CreateAppProfileRequestTest {
    @Test
    public void testToProto() {
        CreateAppProfileRequest wrapper = CreateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true)).setIgnoreWarnings(true);
        Truth.assertThat((Object)wrapper.toProto("my-project")).isEqualTo((Object)com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder().setParent(InstanceName.of((String)"my-project", (String)"my-instance").toString()).setAppProfileId("my-profile").setAppProfile(AppProfile.newBuilder().setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true))).setIgnoreWarnings(true).build());
    }

    @Test
    public void testMultiClusterRouting() {
        CreateAppProfileRequest wrapper = CreateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of());
        Truth.assertThat((Object)wrapper.toProto("my-project").getAppProfile().getMultiClusterRoutingUseAny()).isEqualTo((Object)AppProfile.MultiClusterRoutingUseAny.getDefaultInstance());
    }

    @Test
    public void testDefaultDescription() {
        CreateAppProfileRequest wrapper = CreateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of());
        Truth.assertThat((String)wrapper.toProto("my-project").getAppProfile().getDescription()).isEqualTo((Object)"my-profile");
    }

    @Test
    public void testStandardIsolation() {
        CreateAppProfileRequest wrapper = CreateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of()).setIsolationPolicy((AppProfile.IsolationPolicy)AppProfile.StandardIsolationPolicy.of());
        Truth.assertThat((Object)wrapper.toProto("my-project").getAppProfile().getStandardIsolation()).isEqualTo((Object)AppProfile.StandardIsolation.getDefaultInstance());
    }

    @Test
    public void testDataBoostIsolationReadOnly() {
        CreateAppProfileRequest wrapper = CreateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.of()).setIsolationPolicy((AppProfile.IsolationPolicy)AppProfile.DataBoostIsolationReadOnlyPolicy.of((AppProfile.ComputeBillingOwner)AppProfile.ComputeBillingOwner.HOST_PAYS));
        Truth.assertThat((Object)wrapper.toProto("my-project").getAppProfile().getDataBoostIsolationReadOnly()).isEqualTo((Object)AppProfile.DataBoostIsolationReadOnly.newBuilder().setComputeBillingOwner(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.HOST_PAYS).build());
    }

    @Test
    public void testRowAffinity() {
        CreateAppProfileRequest wrapper = CreateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.withRowAffinity());
        Truth.assertThat((Object)wrapper.toProto("my-project").getAppProfile().getMultiClusterRoutingUseAny()).isEqualTo((Object)AppProfile.MultiClusterRoutingUseAny.newBuilder().setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()).build());
    }
}

