/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.CreateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CreateAuthorizedViewRequestTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String TABLE_ID = "my-table";
    private static final String AUTHORIZED_VIEW_ID = "my-authorized-view";

    @Test
    public void testToProto() {
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setDeletionProtection(true).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#").addRowPrefix("another-row#").setFamilySubsets("family", FamilySubsets.create().addQualifier("column").addQualifierPrefix("column#")));
        com.google.bigtable.admin.v2.CreateAuthorizedViewRequest requestProto = com.google.bigtable.admin.v2.CreateAuthorizedViewRequest.newBuilder().setParent(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAuthorizedViewId(AUTHORIZED_VIEW_ID).setAuthorizedView(AuthorizedView.newBuilder().setDeletionProtection(true).setSubsetView(AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row#")).addRowPrefixes(ByteString.copyFromUtf8((String)"another-row#")).putFamilySubsets("family", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"column#")).build()))).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")).setDeletionProtection(false);
        Truth.assertThat((Object)request).isEqualTo((Object)CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")));
        Truth.assertThat((Object)request).isNotEqualTo((Object)CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("another-row#")));
    }

    @Test
    public void testHashCode() {
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")).setDeletionProtection(false);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)CreateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("another-row#")).hashCode());
    }
}

