/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.Instance;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.common.truth.extensions.proto.ProtoTruth;
import com.google.protobuf.Message;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CreateClusterRequestTest {
    @Test
    public void testProductionSingle() {
        CreateInstanceRequest input = CreateInstanceRequest.of((String)"my-instance").setType(Instance.Type.PRODUCTION).addCluster("cluster1", "us-east1-c", 3, StorageType.SSD);
        com.google.bigtable.admin.v2.CreateInstanceRequest actual = input.toProto("my-project");
        com.google.bigtable.admin.v2.CreateInstanceRequest expected = com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().setParent(NameUtil.formatProjectName((String)"my-project")).setInstanceId("my-instance").setInstance(Instance.newBuilder().setDisplayName("my-instance").setType(Instance.Type.PRODUCTION)).putClusters("cluster1", Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setServeNodes(3).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).build();
        ProtoTruth.assertThat((Message)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testProductionReplication() {
        CreateInstanceRequest input = CreateInstanceRequest.of((String)"my-instance").setType(Instance.Type.PRODUCTION).addCluster("cluster1", "us-east1-c", 3, StorageType.SSD).addCluster("cluster2", "us-east1-a", 3, StorageType.SSD);
        com.google.bigtable.admin.v2.CreateInstanceRequest actual = input.toProto("my-project");
        com.google.bigtable.admin.v2.CreateInstanceRequest expected = com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().setParent(NameUtil.formatProjectName((String)"my-project")).setInstanceId("my-instance").setInstance(Instance.newBuilder().setDisplayName("my-instance").setType(Instance.Type.PRODUCTION)).putClusters("cluster1", Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setServeNodes(3).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).putClusters("cluster2", Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-a").setServeNodes(3).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).build();
        ProtoTruth.assertThat((Message)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testDevelopment() {
        CreateInstanceRequest input = CreateInstanceRequest.of((String)"my-instance").setType(Instance.Type.DEVELOPMENT).addDevelopmentCluster("cluster1", "us-east1-c", StorageType.SSD);
        com.google.bigtable.admin.v2.CreateInstanceRequest actual = input.toProto("my-project");
        com.google.bigtable.admin.v2.CreateInstanceRequest expected = com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().setParent(NameUtil.formatProjectName((String)"my-project")).setInstanceId("my-instance").setInstance(Instance.newBuilder().setDisplayName("my-instance").setType(Instance.Type.DEVELOPMENT)).putClusters("cluster1", Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).build();
        ProtoTruth.assertThat((Message)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testOptionalFields() {
        CreateInstanceRequest input = CreateInstanceRequest.of((String)"my-instance").setDisplayName("custom display name").addLabel("my label", "with some value").addLabel("my other label", "with some value").setType(Instance.Type.DEVELOPMENT).addCluster("cluster1", "us-east1-c", 1, StorageType.SSD);
        com.google.bigtable.admin.v2.CreateInstanceRequest actual = input.toProto("my-project");
        com.google.bigtable.admin.v2.CreateInstanceRequest expected = com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().setParent(NameUtil.formatProjectName((String)"my-project")).setInstanceId("my-instance").setInstance(Instance.newBuilder().setDisplayName("custom display name").putLabels("my label", "with some value").putLabels("my other label", "with some value").setType(Instance.Type.DEVELOPMENT)).putClusters("cluster1", Cluster.newBuilder().setLocation("projects/my-project/locations/us-east1-c").setServeNodes(1).setDefaultStorageType(com.google.bigtable.admin.v2.StorageType.SSD).build()).build();
        ProtoTruth.assertThat((Message)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testCmek() {
        String kmsKeyName = "projects/my-project/locations/us-east1-c/keyRings/my-key-ring/cryptoKeys/my-key";
        CreateInstanceRequest input = CreateInstanceRequest.of((String)"my-instance").addCmekCluster("cluster1", "us-east1-c", 1, StorageType.SSD, kmsKeyName);
        com.google.bigtable.admin.v2.CreateInstanceRequest actual = input.toProto("my-project");
        ProtoTruth.assertThat((Message)actual).comparingExpectedFieldsOnly().isEqualTo((Message)com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder().putClusters("cluster1", Cluster.newBuilder().setEncryptionConfig(Cluster.EncryptionConfig.newBuilder().setKmsKeyName(kmsKeyName).build()).build()).build());
    }
}

