/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.Type;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class CreateTableRequestTest {
    private static final String TABLE_ID = "my-table";
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final ByteString splitKey = ByteString.copyFromUtf8((String)"first-split");

    @Test
    public void testToProto() {
        ByteString secondSplitKey = ByteString.copyFromUtf8((String)"second-split");
        CreateTableRequest request = CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addFamily("another-family", (GCRules.GCRule)GCRules.GCRULES.maxAge(100L, TimeUnit.HOURS)).addSplit(splitKey).addSplit(secondSplitKey).addChangeStreamRetention(Duration.ofHours((long)24L)).setDeletionProtection(true);
        com.google.bigtable.admin.v2.CreateTableRequest requestProto = com.google.bigtable.admin.v2.CreateTableRequest.newBuilder().setTableId(TABLE_ID).setTable(Table.newBuilder().putColumnFamilies("family-id", ColumnFamily.getDefaultInstance()).putColumnFamilies("another-family", ColumnFamily.newBuilder().setGcRule(GcRule.newBuilder().setMaxAge(com.google.protobuf.Duration.newBuilder().setSeconds(360000L)).build()).build()).setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(86400L)).build()).setDeletionProtection(true)).setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).addInitialSplits(CreateTableRequest.Split.newBuilder().setKey(splitKey)).addInitialSplits(CreateTableRequest.Split.newBuilder().setKey(secondSplitKey)).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testToProtoWithTypes() {
        CreateTableRequest request = CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addFamily("another-family", (GCRules.GCRule)GCRules.GCRULES.maxAge(100L, TimeUnit.HOURS)).addFamily("int-sum-family", (Type)Type.int64Sum()).addFamily("int-sum-family-2", (GCRules.GCRule)GCRules.GCRULES.maxAge(100L, TimeUnit.HOURS), (Type)Type.int64Sum());
        com.google.bigtable.admin.v2.CreateTableRequest requestProto = com.google.bigtable.admin.v2.CreateTableRequest.newBuilder().setTableId(TABLE_ID).setTable(Table.newBuilder().putColumnFamilies("family-id", ColumnFamily.getDefaultInstance()).putColumnFamilies("another-family", ColumnFamily.newBuilder().setGcRule(GcRule.newBuilder().setMaxAge(com.google.protobuf.Duration.newBuilder().setSeconds(360000L)).build()).build()).putColumnFamilies("int-sum-family", ColumnFamily.newBuilder().setGcRule(GcRule.getDefaultInstance()).setValueType(Type.int64Sum().toProto()).build()).putColumnFamilies("int-sum-family-2", ColumnFamily.newBuilder().setGcRule(GcRule.newBuilder().setMaxAge(com.google.protobuf.Duration.newBuilder().setSeconds(360000L)).build()).setValueType(Type.int64Sum().toProto()).build())).setParent(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        CreateTableRequest request = CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addFamily("another-family", (GCRules.GCRule)GCRules.GCRULES.maxAge(100L, TimeUnit.HOURS)).addSplit(splitKey);
        Truth.assertThat((Object)request).isEqualTo((Object)CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addFamily("another-family", (GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofHours((long)100L))).addSplit(splitKey));
        Truth.assertThat((Object)request).isNotEqualTo((Object)CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addFamily("another-family").addSplit(splitKey));
    }

    @Test
    public void testHashCode() {
        CreateTableRequest request = CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addSplit(splitKey);
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)CreateTableRequest.of((String)TABLE_ID).addFamily("family-id").addSplit(splitKey).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)CreateTableRequest.of((String)TABLE_ID).addFamily("other-family").hashCode());
    }
}

