/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.GcRule;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.common.truth.Truth;
import com.google.protobuf.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class GCRulesTest {
    @Test
    public void duration() {
        GCRules.DurationRule actual = GCRules.GCRULES.maxAge(Duration.ofSeconds((long)61L, (long)9L));
        GcRule expected = GCRulesTest.buildAgeRule(61L, 9);
        Assert.assertNotNull((Object)actual.getMaxAge());
        Truth.assertThat((Object)actual.toProto()).isEqualTo((Object)expected);
    }

    @Test
    public void durationSeconds() {
        GcRule actual = GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L)).toProto();
        GcRule expected = GCRulesTest.buildAgeRule(1L, 0);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void durationNanos() {
        GcRule actual = GCRules.GCRULES.maxAge(Duration.ofNanos((long)11L)).toProto();
        GcRule expected = GCRulesTest.buildAgeRule(0L, 11);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void durationTimeUnitSeconds() {
        GcRule actual = GCRules.GCRULES.maxAge(1L, TimeUnit.DAYS).toProto();
        GcRule expected = GCRulesTest.buildAgeRule(86400L, 0);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void durationTimeUnitMinutes() {
        GcRule actual = GCRules.GCRULES.maxAge(1L, TimeUnit.MINUTES).toProto();
        GcRule expected = GCRulesTest.buildAgeRule(60L, 0);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void durationTimeUnitNanos() {
        GcRule actual = GCRules.GCRULES.maxAge(1L, TimeUnit.NANOSECONDS).toProto();
        GcRule expected = GCRulesTest.buildAgeRule(0L, 1);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void durationTimeUnitNegative() {
        GcRule actual = GCRules.GCRULES.maxAge(-1L, TimeUnit.MINUTES).toProto();
        GcRule expected = GCRulesTest.buildAgeRule(-60L, 0);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void versions() {
        GCRules.VersionRule actual = GCRules.GCRULES.maxVersions(10);
        GcRule expected = GCRulesTest.buildVersionsRule(10);
        Assert.assertNotNull((Object)actual.getMaxVersions());
        Truth.assertThat((Object)actual.toProto()).isEqualTo((Object)expected);
    }

    @Test
    public void unionEmpty() {
        GcRule actual = GCRules.GCRULES.union().toProto();
        GcRule expected = GcRule.newBuilder().build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void unionOne() {
        GcRule actual = GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).toProto();
        GcRule expected = GCRulesTest.buildVersionsRule(1);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void unionTwo() {
        GcRule actual = GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L))).toProto();
        GcRule expected = GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0))).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void unionThree() {
        GcRule actual = GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L))).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofNanos((long)1L))).toProto();
        GcRule expected = GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0)).addRules(GCRulesTest.buildAgeRule(0L, 1))).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void intersectionEmpty() {
        GcRule actual = GCRules.GCRULES.intersection().toProto();
        GcRule expected = GcRule.newBuilder().build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void intersectionOne() {
        GcRule actual = GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).toProto();
        GcRule expected = GCRulesTest.buildVersionsRule(1);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void intersectionTwo() {
        GcRule actual = GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L))).toProto();
        GcRule expected = GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0))).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void intersectionThree() {
        GcRule actual = GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L))).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofNanos((long)1L))).toProto();
        GcRule expected = GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0)).addRules(GCRulesTest.buildAgeRule(0L, 1))).build();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void unionOfIntersections() {
        GCRules.UnionRule actual = GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L)))).rule((GCRules.GCRule)GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L))));
        GcRule expected = GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0)))).addRules(GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0))))).build();
        Assert.assertEquals((long)2L, (long)actual.getRulesList().size());
        Truth.assertThat((Object)actual.toProto()).isEqualTo((Object)expected);
    }

    @Test
    public void intersectionOfUnions() {
        GCRules.IntersectionRule actual = GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L)))).rule((GCRules.GCRule)GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L))));
        GcRule expected = GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0)))).addRules(GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 0))))).build();
        Assert.assertEquals((long)2L, (long)actual.getRulesList().size());
        Truth.assertThat((Object)actual.toProto()).isEqualTo((Object)expected);
    }

    @Test
    public void unionOfRules() {
        GcRule protoGCRule = GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GCRulesTest.buildAgeRule(10L, 0)).addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(20L, 2))).build();
        GCRules.UnionRule modelGCRule = GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)10L))).rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)20L, (long)2L)));
        Truth.assertThat((Object)GCRules.GCRULES.fromProto(protoGCRule)).isEqualTo((Object)modelGCRule);
    }

    @Test
    public void intersectionWithFromProto() {
        GcRule protoGCRule = GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildAgeRule(10L, 5)).addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildVersionsRule(2))).build();
        GCRules.IntersectionRule modelGCRule = GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)10L, (long)5L))).rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(2));
        Truth.assertThat((Object)GCRules.GCRULES.fromProto(protoGCRule)).isEqualTo((Object)modelGCRule);
    }

    @Test
    public void unionOfIntersectionFromProto() {
        GcRule protoGCRule = GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addRules(GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildVersionsRule(10)).addRules(GCRulesTest.buildAgeRule(2L, 4)).build()).build()).addRules(GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addRules(GCRulesTest.buildVersionsRule(1)).addRules(GCRulesTest.buildAgeRule(1L, 1)).build()).build())).build();
        GCRules.UnionRule modelGCRule = GCRules.GCRULES.union().rule((GCRules.GCRule)GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(10)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)2L, (long)4L)))).rule((GCRules.GCRule)GCRules.GCRULES.intersection().rule((GCRules.GCRule)GCRules.GCRULES.maxVersions(1)).rule((GCRules.GCRule)GCRules.GCRULES.maxAge(Duration.ofSeconds((long)1L, (long)1L))));
        Truth.assertThat((Object)GCRules.GCRULES.fromProto(protoGCRule)).isEqualTo((Object)modelGCRule);
    }

    public static GcRule buildAgeRule(long seconds, int nanos) {
        Duration.Builder duartionBuilder = com.google.protobuf.Duration.newBuilder();
        duartionBuilder.setSeconds(seconds);
        duartionBuilder.setNanos(nanos);
        return GcRule.newBuilder().setMaxAge(duartionBuilder).build();
    }

    public static GcRule buildVersionsRule(int maxVer) {
        return GcRule.newBuilder().setMaxNumVersions(maxVer).build();
    }
}

