/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SubsetViewTest {
    @Test
    public void testFromProto() {
        AuthorizedView.SubsetView subsetViewProto = AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row1#")).addRowPrefixes(ByteString.copyFromUtf8((String)"row2#")).putFamilySubsets("family1", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column1")).addQualifiers(ByteString.copyFromUtf8((String)"column2")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"column3#")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"column4#")).build()).putFamilySubsets("family2", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column5")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"")).build()).build();
        SubsetView result = SubsetView.fromProto((AuthorizedView.SubsetView)subsetViewProto);
        Truth.assertThat((Iterable)result.getRowPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"row1#"), ByteString.copyFromUtf8((String)"row2#")});
        Map familySubsetsResult = result.getFamilySubsets();
        Truth.assertThat((Map)familySubsetsResult).containsExactly((Object)"family1", (Object)FamilySubsets.fromProto((AuthorizedView.FamilySubsets)subsetViewProto.getFamilySubsetsOrThrow("family1")), new Object[]{"family2", FamilySubsets.fromProto((AuthorizedView.FamilySubsets)subsetViewProto.getFamilySubsetsOrThrow("family2"))});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family1")).getQualifiers()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column1"), ByteString.copyFromUtf8((String)"column2")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family1")).getQualifierPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column3#"), ByteString.copyFromUtf8((String)"column4#")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family2")).getQualifiers()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column5")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family2")).getQualifierPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"")});
    }

    @Test
    public void testToProto() {
        SubsetView subsetView = SubsetView.create().addRowPrefix("row1#").addRowPrefix("row2#").setFamilySubsets("family1", FamilySubsets.create().addQualifier("column1").addQualifierPrefix("prefix1#")).setFamilySubsets("family1", FamilySubsets.create().addQualifier("column2").addQualifierPrefix("prefix2#")).setFamilySubsets("family2", FamilySubsets.create().addQualifier("column").addQualifierPrefix(""));
        AuthorizedView.SubsetView subsetViewProto = AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row1#")).addRowPrefixes(ByteString.copyFromUtf8((String)"row2#")).putFamilySubsets("family1", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column2")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"prefix2#")).build()).putFamilySubsets("family2", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"column")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"")).build()).build();
        Truth.assertThat((Iterable)subsetView.getRowPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"row1#"), ByteString.copyFromUtf8((String)"row2#")});
        Map familySubsetsResult = subsetView.getFamilySubsets();
        Truth.assertThat((Map)familySubsetsResult).containsExactly((Object)"family1", (Object)FamilySubsets.fromProto((AuthorizedView.FamilySubsets)subsetViewProto.getFamilySubsetsOrThrow("family1")), new Object[]{"family2", FamilySubsets.fromProto((AuthorizedView.FamilySubsets)subsetViewProto.getFamilySubsetsOrThrow("family2"))});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family1")).getQualifiers()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column2")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family1")).getQualifierPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"prefix2#")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family2")).getQualifiers()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"column")});
        Truth.assertThat((Iterable)((FamilySubsets)familySubsetsResult.get("family2")).getQualifierPrefixes()).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"")});
        Truth.assertThat((Object)subsetView.toProto()).isEqualTo((Object)subsetViewProto);
    }

    @Test
    public void testEquality() {
        AuthorizedView.SubsetView proto = AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row1#")).build();
        SubsetView subsetView = SubsetView.fromProto((AuthorizedView.SubsetView)proto);
        Truth.assertThat((Object)subsetView).isEqualTo((Object)SubsetView.fromProto((AuthorizedView.SubsetView)proto));
        Truth.assertThat((Object)subsetView).isNotEqualTo((Object)SubsetView.fromProto((AuthorizedView.SubsetView)AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row2#")).build()));
    }

    @Test
    public void testHashCode() {
        AuthorizedView.SubsetView proto = AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row1#")).build();
        SubsetView subsetView = SubsetView.fromProto((AuthorizedView.SubsetView)proto);
        Truth.assertThat((Integer)subsetView.hashCode()).isEqualTo((Object)SubsetView.fromProto((AuthorizedView.SubsetView)proto).hashCode());
        Truth.assertThat((Integer)subsetView.hashCode()).isNotEqualTo((Object)SubsetView.fromProto((AuthorizedView.SubsetView)AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row2#")).build()).hashCode());
    }
}

