/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.cloud.bigtable.admin.v2.TypeProtos;
import com.google.cloud.bigtable.admin.v2.models.Type;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeTest {
    @Test
    public void rawBytes() {
        Type.Bytes type = Type.rawBytes();
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)com.google.bigtable.admin.v2.Type.newBuilder().setBytesType(TypeProtos.bytesType()).build());
    }

    @Test
    public void bytes() {
        Type.Bytes type = Type.bytes((Type.Bytes.Encoding)Type.Bytes.Encoding.raw());
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)com.google.bigtable.admin.v2.Type.newBuilder().setBytesType(TypeProtos.bytesType()).build());
    }

    @Test
    public void bigEndianInt64() {
        Type.Int64 type = Type.bigEndianInt64();
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.int64Type());
    }

    @Test
    public void int64WithEncoding() {
        Type.Int64 type = Type.int64((Type.Int64.Encoding)Type.Int64.Encoding.BigEndianBytes.create());
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.int64Type());
    }

    @Test
    public void int64Sum() {
        Type.Aggregate type = Type.int64Sum();
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intSumType());
    }

    @Test
    public void sum() {
        Type.Aggregate type = Type.sum((Type.SumAggregateInput)Type.bigEndianInt64());
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intSumType());
    }

    @Test
    public void intSumFromProtoToProto() {
        com.google.bigtable.admin.v2.Type proto = TypeProtos.intSumType();
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto)).isEqualTo((Object)Type.int64Sum());
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto).toProto()).isEqualTo((Object)proto);
    }

    @Test
    public void int64Min() {
        Type.Aggregate type = Type.int64Min();
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intMinType());
    }

    @Test
    public void min() {
        Type.Aggregate type = Type.min((Type.MinAggregateInput)Type.bigEndianInt64());
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intMinType());
    }

    @Test
    public void intMinFromProtoToProto() {
        com.google.bigtable.admin.v2.Type proto = TypeProtos.intMinType();
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto)).isEqualTo((Object)Type.int64Min());
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto).toProto()).isEqualTo((Object)proto);
    }

    @Test
    public void int64Max() {
        Type.Aggregate type = Type.int64Max();
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intMaxType());
    }

    @Test
    public void max() {
        Type.Aggregate type = Type.max((Type.MaxAggregateInput)Type.bigEndianInt64());
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intMaxType());
    }

    @Test
    public void intMaxFromProtoToProto() {
        com.google.bigtable.admin.v2.Type proto = TypeProtos.intMaxType();
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto)).isEqualTo((Object)Type.int64Max());
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto).toProto()).isEqualTo((Object)proto);
    }

    @Test
    public void bytesHll() {
        Type.Aggregate type = Type.int64Hll();
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intHllType());
    }

    @Test
    public void hll() {
        Type.Aggregate type = Type.hll((Type.HllAggregateInput)Type.bigEndianInt64());
        Truth.assertThat((Object)type.toProto()).isEqualTo((Object)TypeProtos.intHllType());
    }

    @Test
    public void bytesHllFromProtoToProto() {
        com.google.bigtable.admin.v2.Type proto = TypeProtos.intHllType();
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto)).isEqualTo((Object)Type.int64Hll());
        Truth.assertThat((Object)Type.fromProto((com.google.bigtable.admin.v2.Type)proto).toProto()).isEqualTo((Object)proto);
    }
}

