/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import com.google.common.truth.Truth;
import com.google.protobuf.FieldMask;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UpdateAppProfileRequestTest {
    @Test
    public void testToProto() {
        UpdateAppProfileRequest wrapper = UpdateAppProfileRequest.of((String)"my-instance", (String)"my-profile").setDescription("my description").setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.SingleClusterRoutingPolicy.of((String)"my-cluster", (boolean)true)).setIgnoreWarnings(true);
        Truth.assertThat((Object)wrapper.toProto("my-project")).isEqualTo((Object)com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(com.google.bigtable.admin.v2.AppProfile.newBuilder().setName("projects/my-project/instances/my-instance/appProfiles/my-profile").setDescription("my description").setSingleClusterRouting(AppProfile.SingleClusterRouting.newBuilder().setClusterId("my-cluster").setAllowTransactionalWrites(true))).setIgnoreWarnings(true).setUpdateMask(FieldMask.newBuilder().addPaths("description").addPaths("single_cluster_routing")).build());
    }

    @Test
    public void testUpdateExisting() {
        com.google.bigtable.admin.v2.AppProfile existingProto = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName("projects/my-project/instances/my-instance/appProfiles/my-profile").setEtag("my-etag").setDescription("description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).build();
        AppProfile existingWrapper = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)existingProto);
        UpdateAppProfileRequest updateWrapper = UpdateAppProfileRequest.of((AppProfile)existingWrapper).setDescription("new description");
        Truth.assertThat((Object)updateWrapper.toProto("my-project")).isEqualTo((Object)com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(existingProto.toBuilder().setDescription("new description")).setUpdateMask(FieldMask.newBuilder().addPaths("description")).build());
    }

    @Test
    public void testUpdateExistingStandardIsolation() {
        com.google.bigtable.admin.v2.AppProfile existingProto = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName("projects/my-project/instances/my-instance/appProfiles/my-profile").setEtag("my-etag").setDescription("description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).setStandardIsolation(AppProfile.StandardIsolation.getDefaultInstance()).build();
        AppProfile existingWrapper = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)existingProto);
        UpdateAppProfileRequest updateWrapper = UpdateAppProfileRequest.of((AppProfile)existingWrapper).setIsolationPolicy((AppProfile.IsolationPolicy)AppProfile.StandardIsolationPolicy.of((AppProfile.Priority)AppProfile.Priority.LOW));
        Truth.assertThat((Object)updateWrapper.toProto("my-project")).isEqualTo((Object)com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(existingProto.toBuilder().setStandardIsolation(AppProfile.StandardIsolation.newBuilder().setPriority(AppProfile.Priority.PRIORITY_LOW).build())).setUpdateMask(FieldMask.newBuilder().addPaths("standard_isolation")).build());
    }

    @Test
    public void testUpdateExistingDataBoostIsolationReadOnly() {
        com.google.bigtable.admin.v2.AppProfile existingProto = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName("projects/my-project/instances/my-instance/appProfiles/my-profile").setEtag("my-etag").setDescription("description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).setStandardIsolation(AppProfile.StandardIsolation.getDefaultInstance()).build();
        AppProfile existingWrapper = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)existingProto);
        UpdateAppProfileRequest updateWrapper = UpdateAppProfileRequest.of((AppProfile)existingWrapper).setIsolationPolicy((AppProfile.IsolationPolicy)AppProfile.DataBoostIsolationReadOnlyPolicy.of((AppProfile.ComputeBillingOwner)AppProfile.ComputeBillingOwner.HOST_PAYS));
        Truth.assertThat((Object)updateWrapper.toProto("my-project")).isEqualTo((Object)com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(existingProto.toBuilder().setDataBoostIsolationReadOnly(AppProfile.DataBoostIsolationReadOnly.newBuilder().setComputeBillingOwner(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.HOST_PAYS).build())).setUpdateMask(FieldMask.newBuilder().addPaths("data_boost_isolation_read_only")).build());
    }

    @Test
    public void testUpdateRowAffinity() {
        com.google.bigtable.admin.v2.AppProfile existingProto = com.google.bigtable.admin.v2.AppProfile.newBuilder().setName("projects/my-project/instances/my-instance/appProfiles/my-profile").setEtag("my-etag").setDescription("description").setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance()).build();
        AppProfile existingWrapper = AppProfile.fromProto((com.google.bigtable.admin.v2.AppProfile)existingProto);
        UpdateAppProfileRequest updateWrapper = UpdateAppProfileRequest.of((AppProfile)existingWrapper).setRoutingPolicy((AppProfile.RoutingPolicy)AppProfile.MultiClusterRoutingPolicy.withRowAffinity());
        Truth.assertThat((Object)updateWrapper.toProto("my-project")).isEqualTo((Object)com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(existingProto.toBuilder().setMultiClusterRoutingUseAny(AppProfile.MultiClusterRoutingUseAny.newBuilder().setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()))).setUpdateMask(FieldMask.newBuilder().addPaths("multi_cluster_routing_use_any")).build());
    }
}

