/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.cloud.bigtable.admin.v2.models.UpdateAuthorizedViewRequest;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UpdateAuthorizedViewRequestTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String TABLE_ID = "my-table";
    private static final String AUTHORIZED_VIEW_ID = "my-authorized-view";

    @Test
    public void testToProto() {
        UpdateAuthorizedViewRequest request = UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setDeletionProtection(true).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")).setIgnoreWarnings(true);
        com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest requestProto = com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest.newBuilder().setAuthorizedView(com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setDeletionProtection(true).setSubsetView(AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row#")))).setUpdateMask(FieldMask.newBuilder().addPaths("deletion_protection").addPaths("subset_view")).setIgnoreWarnings(true).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testUpdateDeletionProtection() {
        com.google.bigtable.admin.v2.AuthorizedView existingAuthorizedView = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setDeletionProtection(true).setSubsetView(AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row#"))).build();
        UpdateAuthorizedViewRequest request = UpdateAuthorizedViewRequest.of((AuthorizedView)AuthorizedView.fromProto((com.google.bigtable.admin.v2.AuthorizedView)existingAuthorizedView)).setDeletionProtection(false);
        com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest requestProto = com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest.newBuilder().setAuthorizedView(existingAuthorizedView.toBuilder().setDeletionProtection(false)).setUpdateMask(FieldMask.newBuilder().addPaths("deletion_protection")).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testUpdateSubsetView() {
        com.google.bigtable.admin.v2.AuthorizedView authorizedViewProto = com.google.bigtable.admin.v2.AuthorizedView.newBuilder().setName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setSubsetView(AuthorizedView.SubsetView.newBuilder().addRowPrefixes(ByteString.copyFromUtf8((String)"row#")).putFamilySubsets("cf", AuthorizedView.FamilySubsets.newBuilder().addQualifiers(ByteString.copyFromUtf8((String)"qualifier")).addQualifierPrefixes(ByteString.copyFromUtf8((String)"prefix#")).build())).build();
        UpdateAuthorizedViewRequest request = UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#").setFamilySubsets("cf", FamilySubsets.create().addQualifier("qualifier").addQualifierPrefix("prefix#")));
        com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest requestProto = com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest.newBuilder().setAuthorizedView(authorizedViewProto).setUpdateMask(FieldMask.newBuilder().addPaths("subset_view")).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEquality() {
        UpdateAuthorizedViewRequest request = UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#"));
        Truth.assertThat((Object)request).isEqualTo((Object)UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")));
        Truth.assertThat((Object)request).isNotEqualTo((Object)UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("another-row#")));
    }

    @Test
    public void testHashCode() {
        UpdateAuthorizedViewRequest request = UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#"));
        Truth.assertThat((Integer)request.hashCode()).isEqualTo((Object)UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("row#")).hashCode());
        Truth.assertThat((Integer)request.hashCode()).isNotEqualTo((Object)UpdateAuthorizedViewRequest.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("another-row#")).hashCode());
    }
}

