/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.admin.v2.Table;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.UpdateTableRequest;
import com.google.common.truth.Truth;
import com.google.protobuf.FieldMask;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class UpdateTableRequestTest {
    private static final String TABLE_ID = "my-table";
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";

    @Test
    public void testEnableChangeStreamToProto() {
        UpdateTableRequest request = UpdateTableRequest.of((String)TABLE_ID).addChangeStreamRetention(Duration.ofHours((long)24L));
        com.google.bigtable.admin.v2.UpdateTableRequest requestProto = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder().setTable(Table.newBuilder().setName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(86400L)).build())).setUpdateMask(FieldMask.newBuilder().addPaths("change_stream_config.retention_period").build()).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testDisableChangeStreamToProto() {
        UpdateTableRequest request = UpdateTableRequest.of((String)TABLE_ID).addChangeStreamRetention(Duration.ofHours((long)0L));
        com.google.bigtable.admin.v2.UpdateTableRequest requestProto = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder().setTable(Table.newBuilder().setName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID))).setUpdateMask(FieldMask.newBuilder().addPaths("change_stream_config").build()).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testNoChangeChangeStreamToProto() {
        UpdateTableRequest request = UpdateTableRequest.of((String)TABLE_ID);
        com.google.bigtable.admin.v2.UpdateTableRequest requestProto = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder().setTable(Table.newBuilder().setName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID))).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testEnableDeletionProtection() {
        UpdateTableRequest request = UpdateTableRequest.of((String)TABLE_ID).setDeletionProtection(true);
        com.google.bigtable.admin.v2.UpdateTableRequest requestProto = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder().setTable(Table.newBuilder().setName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setDeletionProtection(true)).setUpdateMask(FieldMask.newBuilder().addPaths("deletion_protection").build()).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }

    @Test
    public void testDisableDeletionProtection() {
        UpdateTableRequest request = UpdateTableRequest.of((String)TABLE_ID).setDeletionProtection(false);
        com.google.bigtable.admin.v2.UpdateTableRequest requestProto = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder().setTable(Table.newBuilder().setName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setDeletionProtection(false)).setUpdateMask(FieldMask.newBuilder().addPaths("deletion_protection").build()).build();
        Truth.assertThat((Object)request.toProto(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)requestProto);
    }
}

