/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.common;

import com.google.bigtable.v2.Type;
import com.google.cloud.bigtable.common.Type;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeTest {
    @Test
    public void simpleTypes_TypeToString() {
        Truth.assertThat((String)Type.String.create().toString()).isEqualTo((Object)"STRING");
        Truth.assertThat((String)Type.Bytes.create().toString()).isEqualTo((Object)"BYTES");
        Truth.assertThat((String)Type.Int64.create().toString()).isEqualTo((Object)"INT64");
        Truth.assertThat((String)Type.Float64.create().toString()).isEqualTo((Object)"FLOAT64");
        Truth.assertThat((String)Type.Float32.create().toString()).isEqualTo((Object)"FLOAT32");
        Truth.assertThat((String)Type.Bool.create().toString()).isEqualTo((Object)"BOOL");
        Truth.assertThat((String)Type.Timestamp.create().toString()).isEqualTo((Object)"TIMESTAMP");
        Truth.assertThat((String)Type.Date.create().toString()).isEqualTo((Object)"DATE");
        Truth.assertThat((String)Type.SchemalessStruct.create().toString()).isEqualTo((Object)"STRUCT");
    }

    @Test
    public void simpleTypes_equals() {
        Truth.assertThat((Object)Type.String.create()).isEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Bytes.create()).isEqualTo((Object)Type.Bytes.create());
        Truth.assertThat((Object)Type.Int64.create()).isEqualTo((Object)Type.Int64.create());
        Truth.assertThat((Object)Type.Float32.create()).isEqualTo((Object)Type.Float32.create());
        Truth.assertThat((Object)Type.Float64.create()).isEqualTo((Object)Type.Float64.create());
        Truth.assertThat((Object)Type.Bool.create()).isEqualTo((Object)Type.Bool.create());
        Truth.assertThat((Object)Type.Timestamp.create()).isEqualTo((Object)Type.Timestamp.create());
        Truth.assertThat((Object)Type.Date.create()).isEqualTo((Object)Type.Date.create());
        Truth.assertThat((Object)Type.SchemalessStruct.create()).isEqualTo((Object)Type.SchemalessStruct.create());
        Truth.assertThat((Object)Type.String.create()).isNotEqualTo((Object)Type.Bytes.create());
        Truth.assertThat((Object)Type.Bytes.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Int64.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Float32.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Float64.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Bool.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Timestamp.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.Date.create()).isNotEqualTo((Object)Type.String.create());
        Truth.assertThat((Object)Type.SchemalessStruct.create()).isNotEqualTo((Object)Type.String.create());
    }

    @Test
    public void array_equals() {
        Truth.assertThat((Object)Type.Array.create((SqlType)Type.String.create())).isEqualTo((Object)Type.Array.create((SqlType)Type.String.create()));
        Truth.assertThat((Object)Type.Array.create((SqlType)Type.String.create())).isNotEqualTo((Object)Type.Array.create((SqlType)Type.Bytes.create()));
        Truth.assertThat((Object)Type.Array.create((SqlType)Type.Array.create((SqlType)Type.String.create()))).isEqualTo((Object)Type.Array.create((SqlType)Type.Array.create((SqlType)Type.String.create())));
        Truth.assertThat((Object)Type.Array.create((SqlType)Type.Array.create((SqlType)Type.String.create()))).isNotEqualTo((Object)Type.Array.create((SqlType)Type.Array.create((SqlType)Type.Bytes.create())));
    }

    @Test
    public void map_equals() {
        Truth.assertThat((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.String.create())).isEqualTo((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.String.create()));
        Truth.assertThat((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.String.create())).isNotEqualTo((Object)Type.Map.create((SqlType)Type.String.create(), (SqlType)Type.String.create()));
        Truth.assertThat((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.String.create())).isNotEqualTo((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.Bytes.create()));
        Truth.assertThat((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.Map.create((SqlType)Type.String.create(), (SqlType)Type.Bytes.create()))).isEqualTo((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.Map.create((SqlType)Type.String.create(), (SqlType)Type.Bytes.create())));
        Truth.assertThat((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.Map.create((SqlType)Type.String.create(), (SqlType)Type.Bytes.create()))).isNotEqualTo((Object)Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.Map.create((SqlType)Type.String.create(), (SqlType)Type.String.create())));
    }

    @Test
    public void structWithSchema_equals() {
        Type structProto = SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType()));
        Type complexStructProto = SqlProtoFactory.structType(SqlProtoFactory.structField("map", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType())), SqlProtoFactory.structField("array", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())));
        new EqualsTester().addEqualityGroup(new Object[]{Type.StructWithSchema.fromProto((Type.Struct)structProto.getStructType()), Type.StructWithSchema.fromProto((Type.Struct)structProto.getStructType())}).addEqualityGroup(new Object[]{Type.StructWithSchema.fromProto((Type.Struct)complexStructProto.getStructType()), Type.StructWithSchema.fromProto((Type.Struct)complexStructProto.getStructType())}).testEquals();
    }

    @Test
    public void structWithSchema_fields() {
        Type.StructWithSchema struct = Type.StructWithSchema.fromProto((Type.Struct)SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())).getStructType());
        Truth.assertThat((Iterable)struct.getFields()).hasSize(2);
        Truth.assertThat((String)((Type.StructWithSchema.Field)struct.getFields().get(0)).name()).isEqualTo((Object)"timestamp");
        Truth.assertThat((Object)((Type.StructWithSchema.Field)struct.getFields().get(0)).type()).isEqualTo((Object)Type.Timestamp.create());
        Truth.assertThat((Object)struct.getType(0)).isEqualTo((Object)Type.Timestamp.create());
        Truth.assertThat((Object)struct.getType("timestamp")).isEqualTo((Object)Type.Timestamp.create());
        Truth.assertThat((Integer)struct.getColumnIndex("timestamp")).isEqualTo((Object)0);
        Truth.assertThat((String)((Type.StructWithSchema.Field)struct.getFields().get(1)).name()).isEqualTo((Object)"value");
        Truth.assertThat((Object)((Type.StructWithSchema.Field)struct.getFields().get(1)).type()).isEqualTo((Object)Type.Bytes.create());
        Truth.assertThat((Object)struct.getType(1)).isEqualTo((Object)Type.Bytes.create());
        Truth.assertThat((Object)struct.getType("value")).isEqualTo((Object)Type.Bytes.create());
        Truth.assertThat((Integer)struct.getColumnIndex("value")).isEqualTo((Object)1);
    }

    @Test
    public void structWithSchema_handlesAmbiguousFields() {
        Type.StructWithSchema struct = Type.StructWithSchema.fromProto((Type.Struct)SqlProtoFactory.structType(SqlProtoFactory.structField("foo", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("foo", SqlProtoFactory.bytesType())).getStructType());
        Truth.assertThat((Iterable)struct.getFields()).hasSize(2);
        Truth.assertThat((Object)struct.getType(0)).isEqualTo((Object)Type.Timestamp.create());
        Truth.assertThat((Object)struct.getType(1)).isEqualTo((Object)Type.Bytes.create());
        Assert.assertThrows(IllegalArgumentException.class, () -> struct.getType("foo"));
        Assert.assertThrows(IllegalArgumentException.class, () -> struct.getColumnIndex("foo"));
    }

    @Test
    public void structWithSchema_toString() {
        Type.StructWithSchema struct = Type.StructWithSchema.fromProto((Type.Struct)SqlProtoFactory.structType(SqlProtoFactory.structField("test", SqlProtoFactory.stringType()), SqlProtoFactory.structField("test2", SqlProtoFactory.int64Type())).getStructType());
        Truth.assertThat((String)struct.toString()).isEqualTo((Object)"STRUCT{fields=[Field{name=test, type=STRING}, Field{name=test2, type=INT64}]}");
    }

    @Test
    public void schemalessStruct_throwsExceptionOnSchemaAccess() {
        Type.SchemalessStruct struct = Type.SchemalessStruct.create();
        Assert.assertThrows(UnsupportedOperationException.class, () -> struct.getType("foo"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> struct.getType(0));
        Assert.assertThrows(UnsupportedOperationException.class, () -> struct.getColumnIndex("foo"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((Type.SchemalessStruct)struct).getFields());
    }

    @Test
    public void array_toString() {
        Type.Array array = Type.Array.create((SqlType)Type.String.create());
        Truth.assertThat((String)array.toString()).isEqualTo((Object)"ARRAY{elementType=STRING}");
    }

    @Test
    public void simpleMap_toString() {
        Type.Map map = Type.Map.create((SqlType)Type.Bytes.create(), (SqlType)Type.String.create());
        Truth.assertThat((String)map.toString()).isEqualTo((Object)"MAP{keyType=BYTES, valueType=STRING}");
    }

    @Test
    public void historicalMap_toString() {
        SqlType.Map historicalMap = SqlType.historicalMap();
        Truth.assertThat((String)historicalMap.toString()).isEqualTo((Object)"MAP{keyType=BYTES, valueType=ARRAY{elementType=STRUCT}}");
    }
}

