/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.FeatureFlags;
import com.google.bigtable.v2.InstanceName;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataClientFactory;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.NoopMetricsProvider;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import io.grpc.Attributes;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigtableDataClientFactoryTest {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    private static final String DEFAULT_PROJECT_ID = "fake-project";
    private static final String DEFAULT_INSTANCE_ID = "fake-instance";
    private static final String DEFAULT_APP_PROFILE_ID = "fake-app-profile";
    private Server server;
    private FakeBigtableService service;
    private TransportChannelProvider transportChannelProvider;
    private CredentialsProvider credentialsProvider;
    private ExecutorProvider executorProvider;
    private WatchdogProvider watchdogProvider;
    private ApiClock apiClock;
    private BigtableDataSettings defaultSettings;
    private final BlockingQueue<Attributes> setUpAttributes = new LinkedBlockingDeque<Attributes>();
    private final BlockingQueue<Attributes> terminateAttributes = new LinkedBlockingDeque<Attributes>();
    private final BlockingQueue<Metadata> requestMetadata = new LinkedBlockingDeque<Metadata>();

    @Before
    public void setUp() throws IOException {
        this.service = new FakeBigtableService();
        this.server = FakeServiceBuilder.create(new BindableService[]{this.service}).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                BigtableDataClientFactoryTest.this.requestMetadata.add(headers);
                return next.startCall(call, headers);
            }
        }).addTransportFilter(new ServerTransportFilter(){

            public Attributes transportReady(Attributes transportAttrs) {
                BigtableDataClientFactoryTest.this.setUpAttributes.add(transportAttrs);
                return super.transportReady(transportAttrs);
            }

            public void transportTerminated(Attributes transportAttrs) {
                BigtableDataClientFactoryTest.this.terminateAttributes.add(transportAttrs);
            }
        }).start();
        BigtableDataSettings.Builder builder = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(DEFAULT_PROJECT_ID).setInstanceId(DEFAULT_INSTANCE_ID).setAppProfileId(DEFAULT_APP_PROFILE_ID);
        this.transportChannelProvider = (TransportChannelProvider)Mockito.mock(TransportChannelProvider.class, new BuilderAnswer(TransportChannelProvider.class, builder.stubSettings().getTransportChannelProvider()));
        this.credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class, new BuilderAnswer(CredentialsProvider.class, builder.stubSettings().getCredentialsProvider()));
        this.executorProvider = (ExecutorProvider)Mockito.mock(ExecutorProvider.class, new BuilderAnswer(ExecutorProvider.class, builder.stubSettings().getBackgroundExecutorProvider()));
        this.watchdogProvider = (WatchdogProvider)Mockito.mock(WatchdogProvider.class, new BuilderAnswer(WatchdogProvider.class, builder.stubSettings().getStreamWatchdogProvider()));
        this.apiClock = builder.stubSettings().getClock();
        ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)builder.stubSettings().setTransportChannelProvider(this.transportChannelProvider)).setCredentialsProvider(this.credentialsProvider)).setExecutorProvider(this.executorProvider)).setStreamWatchdogProvider(this.watchdogProvider)).setClock(this.apiClock);
        this.defaultSettings = builder.build();
    }

    @After
    public void tearDown() {
        this.server.shutdown();
    }

    @Test
    public void testNewClientsShareTransportChannel() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.defaultSettings.toBuilder().setMetricsProvider((MetricsProvider)NoopMetricsProvider.INSTANCE).build());
             BigtableDataClient ignored1 = factory.createForInstance("project1", "instance1");
             BigtableDataClient ignored2 = factory.createForInstance("project2", "instance2");
             BigtableDataClient ignored3 = factory.createForInstance("project3", "instance3");){
            ((TransportChannelProvider)Mockito.verify((Object)this.transportChannelProvider, (VerificationMode)Mockito.times((int)1))).getTransportChannel();
            ((CredentialsProvider)Mockito.verify((Object)this.credentialsProvider, (VerificationMode)Mockito.times((int)1))).getCredentials();
            ((ExecutorProvider)Mockito.verify((Object)this.executorProvider, (VerificationMode)Mockito.times((int)1))).getExecutor();
            ((WatchdogProvider)Mockito.verify((Object)this.watchdogProvider, (VerificationMode)Mockito.times((int)1))).getWatchdog();
        }
    }

    @Test
    public void testCreateDefaultKeepsSettings() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.defaultSettings);
             BigtableDataClient client = factory.createDefault();){
            client.mutateRow(RowMutation.create((String)"some-table", (String)"some-key").deleteRow());
        }
        Truth.assertThat((String)this.service.lastRequest.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)DEFAULT_PROJECT_ID, (String)DEFAULT_INSTANCE_ID, (String)"some-table"));
        Truth.assertThat((String)this.service.lastRequest.getAppProfileId()).isEqualTo((Object)DEFAULT_APP_PROFILE_ID);
    }

    @Test
    public void testCreateForAppProfileHasCorrectSettings() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.defaultSettings);
             BigtableDataClient client = factory.createForAppProfile("other-app-profile");){
            client.mutateRow(RowMutation.create((String)"some-table", (String)"some-key").deleteRow());
        }
        Truth.assertThat((String)this.service.lastRequest.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)DEFAULT_PROJECT_ID, (String)DEFAULT_INSTANCE_ID, (String)"some-table"));
        Truth.assertThat((String)this.service.lastRequest.getAppProfileId()).isEqualTo((Object)"other-app-profile");
    }

    @Test
    public void testCreateForInstanceHasCorrectSettings() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.defaultSettings);
             BigtableDataClient client = factory.createForInstance("other-project", "other-instance");){
            client.mutateRow(RowMutation.create((String)"some-table", (String)"some-key").deleteRow());
        }
        Truth.assertThat((String)this.service.lastRequest.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)"other-project", (String)"other-instance", (String)"some-table"));
        Truth.assertThat((String)this.service.lastRequest.getAppProfileId()).isEmpty();
    }

    @Test
    public void testCreateForInstanceWithAppProfileHasCorrectSettings() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.defaultSettings);
             BigtableDataClient client = factory.createForInstance("other-project", "other-instance", "other-app-profile");){
            client.mutateRow(RowMutation.create((String)"some-table", (String)"some-key").deleteRow());
        }
        Truth.assertThat((String)this.service.lastRequest.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)"other-project", (String)"other-instance", (String)"some-table"));
        Truth.assertThat((String)this.service.lastRequest.getAppProfileId()).isEqualTo((Object)"other-app-profile");
    }

    @Test
    public void testCreateWithRefreshingChannel() throws Exception {
        int poolSize = 3;
        BigtableDataSettings.Builder builder = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(DEFAULT_PROJECT_ID).setInstanceId(DEFAULT_INSTANCE_ID).setAppProfileId(DEFAULT_APP_PROFILE_ID).setRefreshingChannel(true);
        ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)builder.stubSettings().setCredentialsProvider(this.credentialsProvider)).setStreamWatchdogProvider(this.watchdogProvider)).setExecutorProvider(this.executorProvider);
        InstantiatingGrpcChannelProvider channelProvider = (InstantiatingGrpcChannelProvider)builder.stubSettings().getTransportChannelProvider();
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = channelProvider.toBuilder();
        channelProviderBuilder.setPoolSize(poolSize);
        builder.stubSettings().setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build());
        BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)builder.build());
        factory.createDefault();
        factory.createForAppProfile("other-appprofile");
        factory.createForInstance("other-project", "other-instance");
        ((CredentialsProvider)Mockito.verify((Object)this.credentialsProvider, (VerificationMode)Mockito.times((int)1))).getCredentials();
        ((ExecutorProvider)Mockito.verify((Object)this.executorProvider, (VerificationMode)Mockito.times((int)1))).getExecutor();
        ((WatchdogProvider)Mockito.verify((Object)this.watchdogProvider, (VerificationMode)Mockito.times((int)1))).getWatchdog();
        Truth.assertThat(this.setUpAttributes).hasSize(poolSize);
        Truth.assertThat(this.service.pingAndWarmRequests).hasSize(poolSize);
        LinkedList<PingAndWarmRequest> expectedRequests = new LinkedList<PingAndWarmRequest>();
        for (int i = 0; i < poolSize; ++i) {
            expectedRequests.add(PingAndWarmRequest.newBuilder().setName(InstanceName.format((String)DEFAULT_PROJECT_ID, (String)DEFAULT_INSTANCE_ID)).setAppProfileId(DEFAULT_APP_PROFILE_ID).build());
        }
        Truth.assertThat(this.service.pingAndWarmRequests).containsExactly(expectedRequests.toArray());
        factory.close();
        long sleepTimeMs = 1000L;
        Thread.sleep(sleepTimeMs);
        Truth.assertThat(this.terminateAttributes).hasSize(poolSize);
    }

    @Test
    public void testFeatureFlags() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.defaultSettings);
             BigtableDataClient client = factory.createDefault();){
            this.requestMetadata.clear();
            client.mutateRow(RowMutation.create((String)"some-table", (String)"some-key").deleteRow());
        }
        Metadata metadata = this.requestMetadata.take();
        String encodedValue = (String)metadata.get(Metadata.Key.of((String)"bigtable-features", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        FeatureFlags featureFlags = FeatureFlags.parseFrom((byte[])BaseEncoding.base64Url().decode((CharSequence)encodedValue));
        Truth.assertThat((Boolean)featureFlags.getReverseScans()).isTrue();
    }

    @Test
    public void testBulkMutationFlowControllerConfigured() throws Exception {
        BigtableDataSettings settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("my-project").setInstanceId("my-instance").setCredentialsProvider(this.credentialsProvider).enableBatchMutationLatencyBasedThrottling(10L).build();
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)settings);){
            BatcherImpl batcher2;
            BigtableDataClient client1 = factory.createDefault();
            BigtableDataClient client2 = factory.createForAppProfile("app-profile");
            try (BatcherImpl batcher1 = (BatcherImpl)client1.newBulkMutationBatcher("my-table");){
                batcher2 = (BatcherImpl)client1.newBulkMutationBatcher("my-table");
                try {
                    Truth.assertThat((Object)batcher1.getFlowController()).isSameInstanceAs((Object)batcher2.getFlowController());
                }
                finally {
                    if (batcher2 != null) {
                        batcher2.close();
                    }
                }
            }
            batcher1 = (BatcherImpl)client1.newBulkMutationBatcher("my-table");
            try {
                batcher2 = (BatcherImpl)client2.newBulkMutationBatcher("my-table");
                try {
                    Truth.assertThat((Object)batcher1.getFlowController()).isNotSameInstanceAs((Object)batcher2.getFlowController());
                }
                finally {
                    if (batcher2 != null) {
                        batcher2.close();
                    }
                }
            }
            finally {
                if (batcher1 != null) {
                    batcher1.close();
                }
            }
        }
    }

    private static class FakeBigtableService
    extends BigtableGrpc.BigtableImplBase {
        volatile MutateRowRequest lastRequest;
        BlockingQueue<ReadRowsRequest> readRowsRequests = new LinkedBlockingDeque<ReadRowsRequest>();
        BlockingQueue<PingAndWarmRequest> pingAndWarmRequests = new LinkedBlockingDeque<PingAndWarmRequest>();
        private ApiFunction<ReadRowsRequest, ReadRowsResponse> readRowsCallback = new ApiFunction<ReadRowsRequest, ReadRowsResponse>(){

            public ReadRowsResponse apply(ReadRowsRequest readRowsRequest) {
                return ReadRowsResponse.getDefaultInstance();
            }
        };
        private ApiFunction<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallback = new ApiFunction<PingAndWarmRequest, PingAndWarmResponse>(){

            public PingAndWarmResponse apply(PingAndWarmRequest pingAndWarmRequest) {
                return PingAndWarmResponse.getDefaultInstance();
            }
        };

        private FakeBigtableService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            try {
                this.readRowsRequests.add(request);
                responseObserver.onNext((Object)((ReadRowsResponse)this.readRowsCallback.apply((Object)request)));
                responseObserver.onCompleted();
            }
            catch (RuntimeException e) {
                responseObserver.onError((Throwable)e);
            }
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            this.lastRequest = request;
            responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void pingAndWarm(PingAndWarmRequest request, StreamObserver<PingAndWarmResponse> responseObserver) {
            this.pingAndWarmRequests.add(request);
            responseObserver.onNext((Object)((PingAndWarmResponse)this.pingAndWarmCallback.apply((Object)request)));
            responseObserver.onCompleted();
        }
    }

    private static class BuilderAnswer<T>
    implements Answer {
        private final Class<T> targetClass;
        private T targetInstance;

        private BuilderAnswer(Class<T> targetClass, T targetInstance) {
            this.targetClass = targetClass;
            this.targetInstance = targetInstance;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object r = invocation.getMethod().invoke(this.targetInstance, invocation.getArguments());
            if (method.getName().startsWith("with") && this.targetClass.isAssignableFrom(method.getReturnType())) {
                this.targetInstance = this.castToTarget(r);
                r = invocation.getMock();
            }
            return r;
        }

        private T castToTarget(Object o) {
            Preconditions.checkArgument((boolean)this.targetClass.isAssignableFrom(this.targetClass), (Object)("Expected instance of " + this.targetClass));
            return (T)o;
        }
    }
}

