/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.ArrayValue;
import com.google.bigtable.v2.ColumnMetadata;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.v2.Type;
import com.google.bigtable.v2.Value;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.AbstractProtoStructReader;
import com.google.cloud.bigtable.data.v2.internal.AutoValue_AbstractProtoStructReaderTest_TestProtoStruct;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoStruct;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.models.sql.Struct;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class AbstractProtoStructReaderTest {
    private static final long MAX_TS_SECONDS = 9223372036854L;

    @RunWith(value=Parameterized.class)
    public static class TypesTest {
        @Parameterized.Parameter(value=0)
        public List<ColumnMetadata> schema;
        @Parameterized.Parameter(value=1)
        public List<Value> values;
        @Parameterized.Parameter(value=2)
        public Integer index;
        @Parameterized.Parameter(value=3)
        public String columnName;
        @Parameterized.Parameter(value=4)
        public BiFunction<TestProtoStruct, String, Object> getByColumn;
        @Parameterized.Parameter(value=5)
        public BiFunction<TestProtoStruct, Integer, Object> getByIndex;
        @Parameterized.Parameter(value=6)
        public Object expectedJavaValue;

        @Parameterized.Parameters
        public static List<Object[]> parameters() {
            return Arrays.asList({Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.bytesType())), Collections.singletonList(SqlProtoFactory.bytesValue("test")), 0, "testField", AbstractProtoStructReader::getBytes, AbstractProtoStructReader::getBytes, ByteString.copyFromUtf8((String)"test")}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.stringType())), Collections.singletonList(SqlProtoFactory.stringValue("test")), 0, "testField", AbstractProtoStructReader::getString, AbstractProtoStructReader::getString, "test"}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.int64Type())), Collections.singletonList(SqlProtoFactory.int64Value(110L)), 0, "testField", AbstractProtoStructReader::getLong, AbstractProtoStructReader::getLong, 110L}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.float64Type())), Collections.singletonList(SqlProtoFactory.floatValue(100.3)), 0, "testField", AbstractProtoStructReader::getDouble, AbstractProtoStructReader::getDouble, 100.3}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.float32Type())), Collections.singletonList(SqlProtoFactory.floatValue(100.3f)), 0, "testField", AbstractProtoStructReader::getFloat, AbstractProtoStructReader::getFloat, Float.valueOf(100.3f)}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.boolType())), Collections.singletonList(SqlProtoFactory.boolValue(true)), 0, "testField", AbstractProtoStructReader::getBoolean, AbstractProtoStructReader::getBoolean, true}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.timestampType())), Collections.singletonList(SqlProtoFactory.timestampValue(1000000L, 100)), 0, "testField", AbstractProtoStructReader::getTimestamp, AbstractProtoStructReader::getTimestamp, Instant.ofEpochSecond(1000000L, 100L)}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.timestampType())), Collections.singletonList(SqlProtoFactory.timestampValue(9223372036854L, 0)), 0, "testField", AbstractProtoStructReader::getTimestamp, AbstractProtoStructReader::getTimestamp, Instant.ofEpochSecond(9223372036854L)}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.dateType())), Collections.singletonList(SqlProtoFactory.dateValue(2024, 6, 1)), 0, "testField", AbstractProtoStructReader::getDate, AbstractProtoStructReader::getDate, Date.fromYearMonthDay((int)2024, (int)6, (int)1)}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType()), SqlProtoFactory.structField("intField", SqlProtoFactory.int64Type()), SqlProtoFactory.structField("listField", SqlProtoFactory.arrayType(SqlProtoFactory.stringType()))))), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("test"), SqlProtoFactory.int64Value(100L), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("nested"), SqlProtoFactory.stringValue("nested2")))), 0, "testField", AbstractProtoStructReader::getStruct, AbstractProtoStructReader::getStruct, ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType()), SqlProtoFactory.structField("intField", SqlProtoFactory.int64Type()), SqlProtoFactory.structField("listField", SqlProtoFactory.arrayType(SqlProtoFactory.stringType()))))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("test"), SqlProtoFactory.int64Value(100L), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("nested"), SqlProtoFactory.stringValue("nested2"))).getArrayValue())}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.arrayType(SqlProtoFactory.stringType()))), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"), SqlProtoFactory.stringValue("baz"))), 0, "testField", (row, field) -> row.getList(field, SqlType.arrayOf((SqlType)SqlType.string())), (row, index) -> row.getList(index, SqlType.arrayOf((SqlType)SqlType.string())), Arrays.asList("foo", "bar", "baz")}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.arrayType(SqlProtoFactory.stringType()))), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.nullValue(), SqlProtoFactory.stringValue("baz"))), 0, "testField", (row, field) -> row.getList(field, SqlType.arrayOf((SqlType)SqlType.string())), (row, index) -> row.getList(index, SqlType.arrayOf((SqlType)SqlType.string())), Arrays.asList("foo", null, "baz")}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.arrayType(SqlProtoFactory.float32Type()))), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.1f), SqlProtoFactory.floatValue(1.2f), SqlProtoFactory.floatValue(1.3f))), 0, "testField", (row, field) -> row.getList(field, SqlType.arrayOf((SqlType)SqlType.float32())), (row, index) -> row.getList(index, SqlType.arrayOf((SqlType)SqlType.float32())), Arrays.asList(Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f))}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.arrayType(SqlProtoFactory.float64Type()))), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.11), SqlProtoFactory.floatValue(1.22), SqlProtoFactory.floatValue(1.33))), 0, "testField", (row, field) -> row.getList(field, SqlType.arrayOf((SqlType)SqlType.float64())), (row, index) -> row.getList(index, SqlType.arrayOf((SqlType)SqlType.float64())), Arrays.asList(1.11, 1.22, 1.33)}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.stringType()))), Collections.singletonList(SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("foo"), SqlProtoFactory.stringValue("bar")), SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("key"), SqlProtoFactory.stringValue("val")))), 0, "testField", (row, field) -> row.getMap(field, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string())), (row, index) -> row.getMap(index, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string())), new HashMap<ByteString, String>(){
                {
                    this.put(ByteString.copyFromUtf8((String)"foo"), "bar");
                    this.put(ByteString.copyFromUtf8((String)"key"), "val");
                }
            }}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.stringType()))), Collections.singletonList(SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("foo"), SqlProtoFactory.nullValue()), SqlProtoFactory.mapElement(SqlProtoFactory.nullValue(), SqlProtoFactory.stringValue("val")))), 0, "testField", (row, field) -> row.getMap(field, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string())), (row, index) -> row.getMap(index, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string())), new HashMap<ByteString, String>(){
                {
                    this.put(ByteString.copyFromUtf8((String)"foo"), null);
                    this.put(null, "val");
                }
            }}, {Collections.singletonList(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.arrayType(SqlProtoFactory.stringType())))), Collections.singletonList(SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("key1"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("1.1"), SqlProtoFactory.stringValue("1.2"))), SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("key2"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("2.1"))))), 0, "testField", (row, field) -> row.getMap(field, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.arrayOf((SqlType)SqlType.string()))), (row, index) -> row.getMap(index, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.arrayOf((SqlType)SqlType.string()))), new HashMap<ByteString, List<String>>(){
                {
                    this.put(ByteString.copyFromUtf8((String)"key1"), Arrays.asList("1.1", "1.2"));
                    this.put(ByteString.copyFromUtf8((String)"key2"), Collections.singletonList("2.1"));
                }
            }}, {Collections.singletonList(SqlProtoFactory.columnMetadata("historicalField", SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.arrayType(SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))))), Collections.singletonList(SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("qual"), SqlProtoFactory.arrayValue(SqlProtoFactory.structValue(SqlProtoFactory.timestampValue(10000L, 100), SqlProtoFactory.bytesValue("test1")), SqlProtoFactory.structValue(SqlProtoFactory.timestampValue(20000L, 100), SqlProtoFactory.bytesValue("test2")))))), 0, "historicalField", (row, field) -> row.getMap(field, SqlType.historicalMap()), (row, index) -> row.getMap(index, SqlType.historicalMap()), new HashMap<ByteString, List<Struct>>(){
                {
                    this.put(ByteString.copyFromUtf8((String)"qual"), Arrays.asList(ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.timestampValue(10000L, 100), SqlProtoFactory.bytesValue("test1")).getArrayValue()), ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.timestampValue(20000L, 100), SqlProtoFactory.bytesValue("test2")).getArrayValue())));
                }
            }});
        }

        private TestProtoStruct getTestRow() {
            return TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(this.schema.toArray(new ColumnMetadata[0])).getMetadata()), this.values);
        }

        @Test
        public void getByColumnName_convertsValues() {
            Truth.assertThat((Object)this.getByColumn.apply(this.getTestRow(), this.columnName)).isEqualTo(this.expectedJavaValue);
        }

        @Test
        public void getByIndex_convertsValues() {
            Truth.assertThat((Object)this.getByIndex.apply(this.getTestRow(), this.index)).isEqualTo(this.expectedJavaValue);
        }

        @Test
        public void getByColumnName_throwsExceptionOnNonExistentColumn() {
            Assert.assertThrows(IllegalArgumentException.class, () -> this.getByColumn.apply(this.getTestRow(), "invalid"));
        }

        @Test
        public void getByColumnIndex_throwsExceptionOnNonExistentColumn() {
            Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.getByIndex.apply(this.getTestRow(), 10000));
        }

        @Test
        public void getByColumnIndex_throwsNullPointerOnNullValue() {
            TestProtoStruct row = TestProtoStruct.create(this.getTestRow().metadata(), this.schema.stream().map(t -> SqlProtoFactory.nullValue()).collect(Collectors.toList()));
            Assert.assertThrows(NullPointerException.class, () -> this.getByIndex.apply(row, this.index));
        }

        @Test
        public void getByColumnName_throwsNullPointerOnNullValue() {
            TestProtoStruct row = TestProtoStruct.create(this.getTestRow().metadata(), this.schema.stream().map(t -> SqlProtoFactory.nullValue()).collect(Collectors.toList()));
            Assert.assertThrows(NullPointerException.class, () -> this.getByColumn.apply(row, this.columnName));
        }

        @Test
        public void getByColumnIndex_throwsExceptionOnWrongType() {
            Type updatedType = SqlProtoFactory.stringType();
            Value updatedValue = SqlProtoFactory.stringValue("test");
            if (this.schema.get(this.index).getType().getKindCase().equals((Object)Type.KindCase.STRING_TYPE)) {
                updatedType = SqlProtoFactory.int64Type();
                updatedValue = SqlProtoFactory.int64Value(1000L);
            }
            ArrayList<ColumnMetadata> updatedSchema = new ArrayList<ColumnMetadata>(this.schema);
            updatedSchema.set(this.index, SqlProtoFactory.columnMetadata(this.columnName, updatedType));
            ArrayList<Value> updatedValues = new ArrayList<Value>(this.values);
            updatedValues.set(this.index, updatedValue);
            TestProtoStruct row = TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(updatedSchema.toArray(new ColumnMetadata[0])).getMetadata()), updatedValues);
            Assert.assertThrows(IllegalStateException.class, () -> this.getByIndex.apply(row, this.index));
        }

        @Test
        public void getByColumnName_throwsExceptionOnWrongType() {
            Type updatedType = SqlProtoFactory.stringType();
            Value updatedValue = SqlProtoFactory.stringValue("test");
            if (this.schema.get(this.index).getType().getKindCase().equals((Object)Type.KindCase.STRING_TYPE)) {
                updatedType = SqlProtoFactory.int64Type();
                updatedValue = SqlProtoFactory.int64Value(1000L);
            }
            ArrayList<ColumnMetadata> updatedSchema = new ArrayList<ColumnMetadata>(this.schema);
            updatedSchema.set(this.index, SqlProtoFactory.columnMetadata(this.columnName, updatedType));
            ArrayList<Value> updatedValues = new ArrayList<Value>(this.values);
            updatedValues.set(this.index, updatedValue);
            TestProtoStruct row = TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(updatedSchema.toArray(new ColumnMetadata[0])).getMetadata()), updatedValues);
            Assert.assertThrows(IllegalStateException.class, () -> this.getByColumn.apply(row, this.columnName));
        }

        @Test
        public void isNull_worksForNullValues() {
            TestProtoStruct row = TestProtoStruct.create(this.getTestRow().metadata(), this.schema.stream().map(t -> SqlProtoFactory.nullValue()).collect(Collectors.toList()));
            Assert.assertTrue((boolean)row.isNull(this.columnName));
            Assert.assertTrue((boolean)row.isNull(this.index));
        }

        @Test
        public void isNull_worksForNonNullValues() {
            Assert.assertFalse((boolean)this.getTestRow().isNull(this.columnName));
            Assert.assertFalse((boolean)this.getTestRow().isNull(this.index));
        }

        @Test
        public void getColumnTypeByName() {
            Truth.assertThat((Object)SqlType.fromProto((Type)this.schema.get(this.index).getType())).isEqualTo((Object)this.getTestRow().getColumnType(this.columnName));
        }

        @Test
        public void getByColumnName_throwsExceptionForDuplicateColumnName() {
            ArrayList<ColumnMetadata> duplicatedSchema = new ArrayList<ColumnMetadata>(this.schema);
            duplicatedSchema.addAll(this.schema);
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(duplicatedSchema.toArray(new ColumnMetadata[0])).getMetadata());
            ArrayList<Value> duplicatedValues = new ArrayList<Value>(this.values);
            duplicatedValues.addAll(this.values);
            TestProtoStruct row = TestProtoStruct.create(metadata, duplicatedValues);
            Assert.assertThrows(IllegalArgumentException.class, () -> this.getByColumn.apply(row, this.columnName));
        }

        @Test
        public void getByIndex_worksWithDuplicateColumnName() {
            ArrayList<ColumnMetadata> duplicatedSchema = new ArrayList<ColumnMetadata>(this.schema);
            duplicatedSchema.addAll(this.schema);
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(duplicatedSchema.toArray(new ColumnMetadata[0])).getMetadata());
            ArrayList<Value> duplicatedValues = new ArrayList<Value>(this.values);
            duplicatedValues.addAll(this.values);
            TestProtoStruct row = TestProtoStruct.create(metadata, duplicatedValues);
            Truth.assertThat((Object)this.expectedJavaValue).isEqualTo(this.getByIndex.apply(row, this.index));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class OneOffTests {
        @Test
        public void simpleMapField_validatesType() {
            TestProtoStruct structWithMap = TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.stringType()))).getMetadata()), Collections.singletonList(SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("foo"), SqlProtoFactory.stringValue("bar")), SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("key"), SqlProtoFactory.stringValue("val")))));
            HashMap<ByteString, String> expectedMap = new HashMap<ByteString, String>();
            expectedMap.put(ByteString.copyFromUtf8((String)"foo"), "bar");
            expectedMap.put(ByteString.copyFromUtf8((String)"key"), "val");
            Truth.assertThat((Map)structWithMap.getMap("testField", SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string()))).isEqualTo(expectedMap);
            Truth.assertThat((Map)structWithMap.getMap(0, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string()))).isEqualTo(expectedMap);
            Assert.assertThrows(IllegalStateException.class, () -> structWithMap.getMap("testField", SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())));
            Assert.assertThrows(IllegalStateException.class, () -> structWithMap.getMap("testField", SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())));
            Assert.assertThrows(IllegalStateException.class, () -> structWithMap.getMap(0, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())));
            Assert.assertThrows(IllegalStateException.class, () -> structWithMap.getMap(0, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())));
        }

        @Test
        public void nestedMapField_validatesType() {
            TestProtoStruct historicalMap = TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.arrayType(SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))))).getMetadata()), Collections.singletonList(SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.bytesValue("qual"), SqlProtoFactory.arrayValue(SqlProtoFactory.structValue(SqlProtoFactory.timestampValue(10000L, 100), SqlProtoFactory.bytesValue("test1")), SqlProtoFactory.structValue(SqlProtoFactory.timestampValue(20000L, 100), SqlProtoFactory.bytesValue("test2")))))));
            HashMap<ByteString, List<Struct>> expectedMap = new HashMap<ByteString, List<Struct>>();
            expectedMap.put(ByteString.copyFromUtf8((String)"qual"), Arrays.asList(ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.timestampValue(10000L, 100), SqlProtoFactory.bytesValue("test1")).getArrayValue()), ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.timestampValue(20000L, 100), SqlProtoFactory.bytesValue("test2")).getArrayValue())));
            Truth.assertThat((Map)historicalMap.getMap("testField", SqlType.historicalMap())).isEqualTo(expectedMap);
            Truth.assertThat((Map)historicalMap.getMap(0, SqlType.historicalMap())).isEqualTo(expectedMap);
            Assert.assertThrows(IllegalStateException.class, () -> historicalMap.getMap("testField", SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())));
            Assert.assertThrows(IllegalStateException.class, () -> historicalMap.getMap("testField", SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.arrayOf((SqlType)SqlType.string()))));
            Assert.assertThrows(IllegalStateException.class, () -> historicalMap.getMap(0, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())));
            Assert.assertThrows(IllegalStateException.class, () -> historicalMap.getMap(0, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.arrayOf((SqlType)SqlType.string()))));
        }

        @Test
        public void arrayField_validatesType() {
            TestProtoStruct structWithList = TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.arrayType(SqlProtoFactory.stringType()))).getMetadata()), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"))));
            List<String> expectedList = Arrays.asList("foo", "bar");
            Truth.assertThat((Iterable)structWithList.getList("testField", SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(expectedList);
            Truth.assertThat((Iterable)structWithList.getList(0, SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(expectedList);
            Assert.assertThrows(IllegalStateException.class, () -> structWithList.getList("testField", SqlType.arrayOf((SqlType)SqlType.bytes())));
            Assert.assertThrows(IllegalStateException.class, () -> structWithList.getList(0, SqlType.arrayOf((SqlType)SqlType.bytes())));
        }

        @Test
        public void arrayField_accessingFloat() {
            TestProtoStruct structWithList = TestProtoStruct.create(ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("testField", SqlProtoFactory.arrayType(SqlProtoFactory.float32Type()))).getMetadata()), Collections.singletonList(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.1f), SqlProtoFactory.floatValue(1.2f))));
            List floatList = structWithList.getList("testField", SqlType.arrayOf((SqlType)SqlType.float32()));
            Truth.assertThat((Float)((Float)floatList.get(0))).isEqualTo((Object)Float.valueOf(1.1f));
            Truth.assertThat((Float)((Float)floatList.get(1))).isEqualTo((Object)Float.valueOf(1.2f));
        }
    }

    @AutoValue
    public static abstract class TestProtoStruct
    extends AbstractProtoStructReader {
        public static TestProtoStruct create(com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata, List<Value> values) {
            return new AutoValue_AbstractProtoStructReaderTest_TestProtoStruct(values, metadata);
        }

        abstract com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata();

        public int getColumnIndex(String columnName) {
            return this.metadata().getColumnIndex(columnName);
        }

        public SqlType<?> getColumnType(int columnIndex) {
            return this.metadata().getColumnType(columnIndex);
        }
    }
}

