/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.v2.ProtoSchema;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.v2.Type;
import com.google.cloud.bigtable.data.v2.internal.ColumnMetadataImpl;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoResultSetMetadataTest {
    @Test
    public void getColumnIndex_returnsCorrectIndex() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"0", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"1", (SqlType)SqlType.int64()), ColumnMetadataImpl.create((String)"2", (SqlType)SqlType.int64()), ColumnMetadataImpl.create((String)"3", (SqlType)SqlType.int64()), ColumnMetadataImpl.create((String)"4", (SqlType)SqlType.int64())));
        Truth.assertThat((Integer)metadata.getColumnIndex("0")).isEqualTo((Object)0);
        Truth.assertThat((Integer)metadata.getColumnIndex("1")).isEqualTo((Object)1);
        Truth.assertThat((Integer)metadata.getColumnIndex("2")).isEqualTo((Object)2);
        Truth.assertThat((Integer)metadata.getColumnIndex("3")).isEqualTo((Object)3);
        Truth.assertThat((Integer)metadata.getColumnIndex("4")).isEqualTo((Object)4);
    }

    @Test
    public void getColumnType_worksByName() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"col0", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"col1", (SqlType)SqlType.int64()), ColumnMetadataImpl.create((String)"col2", (SqlType)SqlType.timestamp()), ColumnMetadataImpl.create((String)"col3", (SqlType)SqlType.date()), ColumnMetadataImpl.create((String)"col4", (SqlType)SqlType.int64())));
        Truth.assertThat((Object)metadata.getColumnType("col0")).isEqualTo((Object)SqlType.string());
        Truth.assertThat((Object)metadata.getColumnType("col1")).isEqualTo((Object)SqlType.int64());
        Truth.assertThat((Object)metadata.getColumnType("col2")).isEqualTo((Object)SqlType.timestamp());
        Truth.assertThat((Object)metadata.getColumnType("col3")).isEqualTo((Object)SqlType.date());
        Truth.assertThat((Object)metadata.getColumnType("col4")).isEqualTo((Object)SqlType.int64());
    }

    @Test
    public void getColumnType_worksByIndex() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"col0", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"col1", (SqlType)SqlType.int64()), ColumnMetadataImpl.create((String)"col2", (SqlType)SqlType.timestamp()), ColumnMetadataImpl.create((String)"col3", (SqlType)SqlType.date()), ColumnMetadataImpl.create((String)"col4", (SqlType)SqlType.int64())));
        Truth.assertThat((Object)metadata.getColumnType(0)).isEqualTo((Object)SqlType.string());
        Truth.assertThat((Object)metadata.getColumnType(1)).isEqualTo((Object)SqlType.int64());
        Truth.assertThat((Object)metadata.getColumnType(2)).isEqualTo((Object)SqlType.timestamp());
        Truth.assertThat((Object)metadata.getColumnType(3)).isEqualTo((Object)SqlType.date());
        Truth.assertThat((Object)metadata.getColumnType(4)).isEqualTo((Object)SqlType.int64());
    }

    @Test
    public void getColumns_returnsColumnsUnchanged() {
        List<ColumnMetadata> columns = Arrays.asList(ColumnMetadataImpl.create((String)"col0", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"col1", (SqlType)SqlType.int64()), ColumnMetadataImpl.create((String)"col2", (SqlType)SqlType.timestamp()), ColumnMetadataImpl.create((String)"col3", (SqlType)SqlType.date()), ColumnMetadataImpl.create((String)"col4", (SqlType)SqlType.int64()));
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(columns);
        Truth.assertThat((Iterable)metadata.getColumns()).isEqualTo(columns);
    }

    @Test
    public void getColumnTypeByNonExistentName_throwsException() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"a", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"b", (SqlType)SqlType.int64())));
        Assert.assertThrows(IllegalArgumentException.class, () -> metadata.getColumnType("c"));
    }

    @Test
    public void getColumnTypeByNonExistentIndex_throwsException() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"a", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"b", (SqlType)SqlType.int64())));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> metadata.getColumnType(2));
    }

    @Test
    public void getColumnIndexForNonExistentName_throwsException() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"a", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"b", (SqlType)SqlType.int64())));
        Assert.assertThrows(IllegalArgumentException.class, () -> metadata.getColumnIndex("c"));
    }

    @Test
    public void getColumnType_throwsExceptionForDuplicateName() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"test", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"test", (SqlType)SqlType.int64())));
        Assert.assertThrows(IllegalArgumentException.class, () -> metadata.getColumnType("test"));
    }

    @Test
    public void getColumnType_allowsGetByIndexWithDuplicateType() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"test", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"test", (SqlType)SqlType.int64())));
        Truth.assertThat((Object)metadata.getColumnType(0)).isEqualTo((Object)SqlType.string());
        Truth.assertThat((Object)metadata.getColumnType(1)).isEqualTo((Object)SqlType.int64());
    }

    @Test
    public void getColumnIndex_throwsExceptionForDuplicateName() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.create(Arrays.asList(ColumnMetadataImpl.create((String)"test", (SqlType)SqlType.string()), ColumnMetadataImpl.create((String)"test", (SqlType)SqlType.int64())));
        Assert.assertThrows(IllegalArgumentException.class, () -> metadata.getColumnIndex("test"));
    }

    @Test
    public void fromProto_throwsExceptionWithEmptySchema() {
        ResultSetMetadata invalidProto = ResultSetMetadata.newBuilder().build();
        Assert.assertThrows(IllegalStateException.class, () -> ProtoResultSetMetadata.fromProto((ResultSetMetadata)invalidProto));
    }

    @Test
    public void fromProto_withEmptyTypeInSchema_throwsException() {
        ResultSetMetadata invalidProto = ResultSetMetadata.newBuilder().setProtoSchema(ProtoSchema.newBuilder().addColumns(com.google.bigtable.v2.ColumnMetadata.newBuilder().setName("test").setType(Type.newBuilder().build()))).build();
        Assert.assertThrows(IllegalStateException.class, () -> ProtoResultSetMetadata.fromProto((ResultSetMetadata)invalidProto));
    }

    @Test
    public void fromProto_allowsColumnWithNoName() {
        ResultSetMetadata proto = ResultSetMetadata.newBuilder().setProtoSchema(ProtoSchema.newBuilder().addColumns(com.google.bigtable.v2.ColumnMetadata.newBuilder().setType(SqlProtoFactory.stringType()).build())).build();
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)proto);
        Truth.assertThat((Integer)metadata.getColumns().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)((ColumnMetadata)metadata.getColumns().get(0)).type()).isEqualTo((Object)SqlType.string());
        Truth.assertThat((String)((ColumnMetadata)metadata.getColumns().get(0)).name()).isEqualTo((Object)"");
        Truth.assertThat((Integer)metadata.getColumnIndex("")).isEqualTo((Object)0);
        Truth.assertThat((Object)metadata.getColumnType("")).isEqualTo((Object)SqlType.string());
    }
}

