/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.v2.ArrayValue;
import com.google.bigtable.v2.Type;
import com.google.bigtable.v2.Value;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.ProtoStruct;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoStructTest {
    static ProtoStruct struct = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("bytesField", SqlProtoFactory.bytesType()), SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType()), SqlProtoFactory.structField("longField", SqlProtoFactory.int64Type()), SqlProtoFactory.structField("doubleField", SqlProtoFactory.float64Type()), SqlProtoFactory.structField("floatField", SqlProtoFactory.float32Type()), SqlProtoFactory.structField("booleanField", SqlProtoFactory.boolType()), SqlProtoFactory.structField("timestampField", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("dateField", SqlProtoFactory.dateType()), SqlProtoFactory.structField("structField", SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType()))), SqlProtoFactory.structField("listField", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.structField("mapField", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.stringType()))))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.bytesValue("testBytes"), SqlProtoFactory.stringValue("testString"), SqlProtoFactory.int64Value(123L), SqlProtoFactory.floatValue(1.23), SqlProtoFactory.floatValue(1.23), SqlProtoFactory.boolValue(true), SqlProtoFactory.timestampValue(100000L, 100), SqlProtoFactory.dateValue(2024, 6, 1), SqlProtoFactory.structValue(SqlProtoFactory.stringValue("string")), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")), SqlProtoFactory.arrayValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")), SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key"), SqlProtoFactory.stringValue("val")))).getArrayValue());

    @Test
    public void getByIndex_supportsAllTypes() {
        Truth.assertThat((Iterable)struct.getBytes(0)).isEqualTo((Object)ByteString.copyFromUtf8((String)"testBytes"));
        Truth.assertThat((String)struct.getString(1)).isEqualTo((Object)"testString");
        Truth.assertThat((Long)struct.getLong(2)).isEqualTo((Object)123);
        Truth.assertThat((Double)struct.getDouble(3)).isEqualTo((Object)1.23);
        Truth.assertThat((Float)Float.valueOf(struct.getFloat(4))).isEqualTo((Object)Float.valueOf(1.23f));
        Truth.assertThat((Boolean)struct.getBoolean(5)).isTrue();
        Truth.assertThat((Comparable)struct.getTimestamp(6)).isEqualTo((Object)Instant.ofEpochSecond(100000L, 100L));
        Truth.assertThat((Comparable)struct.getDate(7)).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)1));
        Truth.assertThat((Object)struct.getStruct(8)).isEqualTo((Object)ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.structValue(SqlProtoFactory.stringValue("string")).getArrayValue()));
        Truth.assertThat((Iterable)struct.getList(9, SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(Arrays.asList("foo", "bar"));
        Truth.assertThat((Map)struct.getMap(10, SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()))).isEqualTo((Object)new HashMap<String, String>(){
            {
                this.put("foo", "bar");
                this.put("key", "val");
            }
        });
    }

    @Test
    public void getByNameSupportsAllTypes() {
        Truth.assertThat((Iterable)struct.getBytes("bytesField")).isEqualTo((Object)ByteString.copyFromUtf8((String)"testBytes"));
        Truth.assertThat((String)struct.getString("stringField")).isEqualTo((Object)"testString");
        Truth.assertThat((Long)struct.getLong("longField")).isEqualTo((Object)123);
        Truth.assertThat((Double)struct.getDouble("doubleField")).isEqualTo((Object)1.23);
        Truth.assertThat((Float)Float.valueOf(struct.getFloat("floatField"))).isEqualTo((Object)Float.valueOf(1.23f));
        Truth.assertThat((Boolean)struct.getBoolean("booleanField")).isTrue();
        Truth.assertThat((Comparable)struct.getTimestamp("timestampField")).isEqualTo((Object)Instant.ofEpochSecond(100000L, 100L));
        Truth.assertThat((Comparable)struct.getDate("dateField")).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)1));
        Truth.assertThat((Object)struct.getStruct("structField")).isEqualTo((Object)ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.structValue(SqlProtoFactory.stringValue("string")).getArrayValue()));
        Truth.assertThat((Iterable)struct.getList("listField", SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(Arrays.asList("foo", "bar"));
        Truth.assertThat((Map)struct.getMap("mapField", SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()))).isEqualTo((Object)new HashMap<String, String>(){
            {
                this.put("foo", "bar");
                this.put("key", "val");
            }
        });
    }

    @Test
    public void getColumnType_byName() {
        Truth.assertThat((Object)struct.getColumnType("bytesField")).isEqualTo((Object)SqlType.bytes());
        Truth.assertThat((Object)struct.getColumnType("stringField")).isEqualTo((Object)SqlType.string());
        Truth.assertThat((Object)struct.getColumnType("longField")).isEqualTo((Object)SqlType.int64());
        Truth.assertThat((Object)struct.getColumnType("doubleField")).isEqualTo((Object)SqlType.float64());
        Truth.assertThat((Object)struct.getColumnType("floatField")).isEqualTo((Object)SqlType.float32());
        Truth.assertThat((Object)struct.getColumnType("booleanField")).isEqualTo((Object)SqlType.bool());
        Truth.assertThat((Object)struct.getColumnType("timestampField")).isEqualTo((Object)SqlType.timestamp());
        Truth.assertThat((Object)struct.getColumnType("dateField")).isEqualTo((Object)SqlType.date());
        Truth.assertThat((Object)struct.getColumnType("structField")).isEqualTo((Object)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType()))));
        Truth.assertThat((Object)struct.getColumnType("listField")).isEqualTo((Object)SqlType.arrayOf((SqlType)SqlType.string()));
        Truth.assertThat((Object)struct.getColumnType("mapField")).isEqualTo((Object)SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()));
    }

    @Test
    public void getColumnType_byIndex() {
        Truth.assertThat((Object)struct.getColumnType(0)).isEqualTo((Object)SqlType.bytes());
        Truth.assertThat((Object)struct.getColumnType(1)).isEqualTo((Object)SqlType.string());
        Truth.assertThat((Object)struct.getColumnType(2)).isEqualTo((Object)SqlType.int64());
        Truth.assertThat((Object)struct.getColumnType(3)).isEqualTo((Object)SqlType.float64());
        Truth.assertThat((Object)struct.getColumnType(4)).isEqualTo((Object)SqlType.float32());
        Truth.assertThat((Object)struct.getColumnType(5)).isEqualTo((Object)SqlType.bool());
        Truth.assertThat((Object)struct.getColumnType(6)).isEqualTo((Object)SqlType.timestamp());
        Truth.assertThat((Object)struct.getColumnType(7)).isEqualTo((Object)SqlType.date());
        Truth.assertThat((Object)struct.getColumnType(8)).isEqualTo((Object)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("stringField", SqlProtoFactory.stringType()))));
        Truth.assertThat((Object)struct.getColumnType(9)).isEqualTo((Object)SqlType.arrayOf((SqlType)SqlType.string()));
        Truth.assertThat((Object)struct.getColumnType(10)).isEqualTo((Object)SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()));
    }

    @Test
    public void getColumnIndex_worksForExistingColumns() {
        Truth.assertThat((Integer)struct.getColumnIndex("bytesField")).isEqualTo((Object)0);
        Truth.assertThat((Integer)struct.getColumnIndex("stringField")).isEqualTo((Object)1);
        Truth.assertThat((Integer)struct.getColumnIndex("longField")).isEqualTo((Object)2);
        Truth.assertThat((Integer)struct.getColumnIndex("doubleField")).isEqualTo((Object)3);
        Truth.assertThat((Integer)struct.getColumnIndex("floatField")).isEqualTo((Object)4);
        Truth.assertThat((Integer)struct.getColumnIndex("booleanField")).isEqualTo((Object)5);
        Truth.assertThat((Integer)struct.getColumnIndex("timestampField")).isEqualTo((Object)6);
        Truth.assertThat((Integer)struct.getColumnIndex("dateField")).isEqualTo((Object)7);
        Truth.assertThat((Integer)struct.getColumnIndex("structField")).isEqualTo((Object)8);
        Truth.assertThat((Integer)struct.getColumnIndex("listField")).isEqualTo((Object)9);
        Truth.assertThat((Integer)struct.getColumnIndex("mapField")).isEqualTo((Object)10);
    }

    @Test
    public void getColumnIndex_throwsExceptionForNonExistentIndex() {
        Assert.assertThrows(IllegalArgumentException.class, () -> struct.getColumnIndex("nonexistent"));
    }

    @Test
    public void values_populatedFromFieldValues() {
        List<Value> values = Arrays.asList(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"));
        ProtoStruct s = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("stringField1", SqlProtoFactory.stringType()), SqlProtoFactory.structField("stringField2", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.arrayValue(values.toArray(new Value[0])).getArrayValue());
        Truth.assertThat((Iterable)s.values()).isEqualTo(values);
    }

    @Test
    public void getByColumnIndex_supportsUnnamedColumn() {
        ProtoStruct s = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.stringType(), SqlProtoFactory.stringType()))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")).getArrayValue());
        Truth.assertThat((String)s.getString(0)).isEqualTo((Object)"foo");
        Truth.assertThat((String)s.getString(1)).isEqualTo((Object)"bar");
    }

    @Test
    public void getByColumnName_supportsUnnamedColumn() {
        ProtoStruct s = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.stringType()))), (ArrayValue)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo")).getArrayValue());
        Truth.assertThat((String)s.getString("")).isEqualTo((Object)"foo");
    }

    @Test
    public void emptyStruct_behavesCorrectly() {
        ProtoStruct empty = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)Type.newBuilder().setStructType(Type.Struct.newBuilder().build()).build())), (ArrayValue)ArrayValue.newBuilder().build());
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> empty.getString(0));
        Assert.assertThrows(IllegalArgumentException.class, () -> empty.getString(""));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> empty.getColumnType(0));
        Assert.assertThrows(IllegalArgumentException.class, () -> empty.getColumnType(""));
    }

    @Test
    public void getColumnIndexOnDuplicateField_throwsException() {
        List<Value> values = Arrays.asList(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"));
        ProtoStruct s = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("dup", SqlProtoFactory.stringType()), SqlProtoFactory.structField("dup", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.arrayValue(values.toArray(new Value[0])).getArrayValue());
        Assert.assertThrows(IllegalArgumentException.class, () -> s.getColumnIndex("dup"));
    }

    @Test
    public void getByFieldNameOnDuplicateField_throwsException() {
        List<Value> values = Arrays.asList(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"));
        ProtoStruct s = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("dup", SqlProtoFactory.stringType()), SqlProtoFactory.structField("dup", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.arrayValue(values.toArray(new Value[0])).getArrayValue());
        Assert.assertThrows(IllegalArgumentException.class, () -> s.getString("dup"));
    }

    @Test
    public void getByIndex_worksWithDuplicateFieldNames() {
        List<Value> values = Arrays.asList(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"));
        ProtoStruct s = ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("dup", SqlProtoFactory.stringType()), SqlProtoFactory.structField("dup", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.arrayValue(values.toArray(new Value[0])).getArrayValue());
        Truth.assertThat((String)s.getString(0)).isEqualTo((Object)"foo");
        Truth.assertThat((String)s.getString(1)).isEqualTo((Object)"bar");
    }
}

