/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.v2.ArrayValue;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.v2.Type;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.internal.ProtoStruct;
import com.google.cloud.bigtable.data.v2.internal.ResultSetImpl;
import com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSet;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStream;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStreamImpl;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResultSetImplTest {
    private static ResultSet resultSetWithFakeStream(com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata, SqlRow ... rows) {
        FakeStreamingApi.ServerStreamingStashCallable stream = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(rows));
        SettableApiFuture future = SettableApiFuture.create();
        future.set((Object)metadata);
        ExecuteQueryCallContext fakeCallContext = ExecuteQueryCallContext.create((ExecuteQueryRequest)ExecuteQueryRequest.newBuilder().build(), (SettableApiFuture)future);
        return ResultSetImpl.create((SqlServerStream)SqlServerStreamImpl.create((ApiFuture)future, (ServerStream)stream.call(fakeCallContext)));
    }

    @Test
    public void testSingleRow() throws ExecutionException, InterruptedException {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType()), SqlProtoFactory.columnMetadata("long", SqlProtoFactory.int64Type()), SqlProtoFactory.columnMetadata("double", SqlProtoFactory.float64Type()), SqlProtoFactory.columnMetadata("float", SqlProtoFactory.float32Type()), SqlProtoFactory.columnMetadata("boolean", SqlProtoFactory.boolType()), SqlProtoFactory.columnMetadata("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.columnMetadata("date", SqlProtoFactory.dateType()), SqlProtoFactory.columnMetadata("struct", SqlProtoFactory.structType(SqlProtoFactory.structField("string", SqlProtoFactory.stringType()))), SqlProtoFactory.columnMetadata("list", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.columnMetadata("map", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.stringType()))).getMetadata());
        ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Arrays.asList(SqlProtoFactory.stringValue("test"), SqlProtoFactory.bytesValue("bytes"), SqlProtoFactory.int64Value(100L), SqlProtoFactory.floatValue(1.23), SqlProtoFactory.floatValue(1.23), SqlProtoFactory.boolValue(true), SqlProtoFactory.timestampValue(10000000L, 100), SqlProtoFactory.dateValue(2024, 6, 5), SqlProtoFactory.structValue(SqlProtoFactory.stringValue("foo")), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key"), SqlProtoFactory.stringValue("val")))))});
        int rows = 0;
        while (resultSet.next()) {
            ++rows;
            Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"test");
            Truth.assertThat((String)resultSet.getString("string")).isEqualTo((Object)"test");
            Truth.assertThat((Iterable)resultSet.getBytes(1)).isEqualTo((Object)ByteString.copyFromUtf8((String)"bytes"));
            Truth.assertThat((Iterable)resultSet.getBytes("bytes")).isEqualTo((Object)ByteString.copyFromUtf8((String)"bytes"));
            Truth.assertThat((Long)resultSet.getLong(2)).isEqualTo((Object)100);
            Truth.assertThat((Long)resultSet.getLong("long")).isEqualTo((Object)100);
            Truth.assertThat((Double)resultSet.getDouble(3)).isEqualTo((Object)1.23);
            Truth.assertThat((Double)resultSet.getDouble("double")).isEqualTo((Object)1.23);
            Truth.assertThat((Float)Float.valueOf(resultSet.getFloat(4))).isEqualTo((Object)Float.valueOf(1.23f));
            Truth.assertThat((Float)Float.valueOf(resultSet.getFloat("float"))).isEqualTo((Object)Float.valueOf(1.23f));
            Truth.assertThat((Boolean)resultSet.getBoolean(5)).isTrue();
            Truth.assertThat((Boolean)resultSet.getBoolean("boolean")).isTrue();
            Truth.assertThat((Comparable)resultSet.getTimestamp(6)).isEqualTo((Object)Instant.ofEpochSecond(10000000L, 100L));
            Truth.assertThat((Comparable)resultSet.getTimestamp("timestamp")).isEqualTo((Object)Instant.ofEpochSecond(10000000L, 100L));
            Truth.assertThat((Comparable)resultSet.getDate(7)).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)5));
            Truth.assertThat((Comparable)resultSet.getDate("date")).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)5));
            Truth.assertThat((Object)resultSet.getStruct(8)).isEqualTo((Object)ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("string", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.structValue(SqlProtoFactory.stringValue("foo")).getArrayValue()));
            Truth.assertThat((Object)resultSet.getStruct("struct")).isEqualTo((Object)ProtoStruct.create((SqlType.Struct)((SqlType.Struct)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.structField("string", SqlProtoFactory.stringType())))), (ArrayValue)SqlProtoFactory.structValue(SqlProtoFactory.stringValue("foo")).getArrayValue()));
            Truth.assertThat((Iterable)resultSet.getList(9, SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(Arrays.asList("foo", "bar"));
            Truth.assertThat((Iterable)resultSet.getList("list", SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(Arrays.asList("foo", "bar"));
            Truth.assertThat((Map)resultSet.getMap(10, SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()))).isEqualTo((Object)new HashMap<String, String>(){
                {
                    this.put("key", "val");
                }
            });
            Truth.assertThat((Map)resultSet.getMap("map", SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()))).isEqualTo((Object)new HashMap<String, String>(){
                {
                    this.put("key", "val");
                }
            });
        }
        Truth.assertThat((Integer)rows).isEqualTo((Object)1);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Object)resultSet.getMetadata()).isEqualTo((Object)metadata);
        resultSet.close();
    }

    @Test
    public void testIteration() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        try (ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("foo"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("bar"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("baz"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("a"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("b")))});){
            Truth.assertThat((Boolean)resultSet.next()).isTrue();
            Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"foo");
            Truth.assertThat((Boolean)resultSet.next()).isTrue();
            Truth.assertThat((Boolean)resultSet.next()).isTrue();
            Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"baz");
            Truth.assertThat((Boolean)resultSet.next()).isTrue();
            Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"a");
            Truth.assertThat((Boolean)resultSet.next()).isTrue();
            Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"b");
            Truth.assertThat((Boolean)resultSet.next()).isFalse();
        }
    }

    @Test
    public void testEmptyResultSet() throws ExecutionException, InterruptedException {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        try (ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[0]);){
            Truth.assertThat((Boolean)resultSet.next()).isFalse();
            Truth.assertThat((Object)resultSet.getMetadata()).isEqualTo((Object)metadata);
        }
    }

    @Test
    public void getCallsPrevented_afterNextReturnsFalse() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("foo"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("bar")))});
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"foo");
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"bar");
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Assert.assertThrows(IllegalStateException.class, () -> resultSet.getString(0));
        resultSet.close();
    }

    @Test
    public void close_preventsGetCalls() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("foo")))});
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        resultSet.close();
        Assert.assertThrows(IllegalStateException.class, () -> resultSet.getString(0));
    }

    @Test
    public void close_cancelsStreamWhenResultsNotConsumed() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        FakeStreamingApi.ServerStreamingStashCallable stream = new FakeStreamingApi.ServerStreamingStashCallable(Collections.singletonList(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("foo")))));
        SqlServerStreamImpl sqlServerStream = SqlServerStreamImpl.create((ApiFuture)SettableApiFuture.create(), (ServerStream)stream.call(ExecuteQueryRequest.newBuilder().build()));
        ResultSet resultSet = ResultSetImpl.create((SqlServerStream)sqlServerStream);
        resultSet.close();
        Throwable lastCallError = stream.popLastCall().getError();
        Truth.assertThat((Throwable)lastCallError).isInstanceOf(CancellationException.class);
    }

    @Test
    public void close_doesNotCancelStreamWhenResultsConsumed() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        FakeStreamingApi.ServerStreamingStashCallable stream = new FakeStreamingApi.ServerStreamingStashCallable(Collections.singletonList(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("foo")))));
        SqlServerStreamImpl sqlServerStream = SqlServerStreamImpl.create((ApiFuture)SettableApiFuture.create(), (ServerStream)stream.call(ExecuteQueryRequest.newBuilder().build()));
        ResultSet resultSet = ResultSetImpl.create((SqlServerStream)sqlServerStream);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        resultSet.close();
        Throwable lastCallError = stream.popLastCall().getError();
        Truth.assertThat((Throwable)lastCallError).isNull();
    }

    @Test
    public void getBeforeNext_throwsException() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("string", SqlProtoFactory.stringType())).getMetadata());
        try (ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Collections.singletonList(SqlProtoFactory.stringValue("foo")))});){
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getString(0));
        }
    }

    @Test
    public void getOnColumnWithDuplicateName_throwsException() {
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("name", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("name", SqlProtoFactory.stringType())).getMetadata());
        try (ResultSet resultSet = ResultSetImplTest.resultSetWithFakeStream(metadata, new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Arrays.asList(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")))});){
            Truth.assertThat((Boolean)resultSet.next()).isTrue();
            Assert.assertThrows(IllegalArgumentException.class, () -> resultSet.getString("name"));
        }
    }

    @Test
    public void getMetadata_unwrapsExecutionExceptions() {
        SettableApiFuture metadataFuture = SettableApiFuture.create();
        FakeStreamingApi.ServerStreamingStashCallable stream = new FakeStreamingApi.ServerStreamingStashCallable(Collections.emptyList());
        ExecuteQueryCallContext fakeCallContext = ExecuteQueryCallContext.create((ExecuteQueryRequest)ExecuteQueryRequest.newBuilder().build(), (SettableApiFuture)metadataFuture);
        ResultSet rs = ResultSetImpl.create((SqlServerStream)SqlServerStreamImpl.create((ApiFuture)metadataFuture, (ServerStream)stream.call(fakeCallContext)));
        metadataFuture.setException((Throwable)new IllegalStateException("test"));
        Assert.assertThrows(IllegalStateException.class, () -> ((ResultSet)rs).getMetadata());
    }

    @Test
    public void getMetadata_returnsNonRuntimeExecutionExceptionsWrapped() {
        SettableApiFuture metadataFuture = SettableApiFuture.create();
        FakeStreamingApi.ServerStreamingStashCallable stream = new FakeStreamingApi.ServerStreamingStashCallable(Collections.emptyList());
        ExecuteQueryCallContext fakeCallContext = ExecuteQueryCallContext.create((ExecuteQueryRequest)ExecuteQueryRequest.newBuilder().build(), (SettableApiFuture)metadataFuture);
        ResultSet rs = ResultSetImpl.create((SqlServerStream)SqlServerStreamImpl.create((ApiFuture)metadataFuture, (ServerStream)stream.call(fakeCallContext)));
        metadataFuture.setException(new Throwable("test"));
        Assert.assertThrows(RuntimeException.class, () -> ((ResultSet)rs).getMetadata());
    }
}

