/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.internal.RowMergerUtil;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMergerUtilTest
extends TestCase {
    @Test
    public void testEmpty() {
        RowMergerUtil util = new RowMergerUtil();
        util.close();
        util = new RowMergerUtil();
        try {
            util.parseReadRowsResponses((Iterable)ImmutableList.of());
        }
        finally {
            util.close();
        }
    }

    @Test
    public void testSingle() {
        ImmutableList responses = ImmutableList.of((Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"key")).setFamilyName(StringValue.newBuilder().setValue("family")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"qualifier"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(true)).build());
        try (RowMergerUtil util = new RowMergerUtil();){
            List rows = util.parseReadRowsResponses((Iterable)responses);
            Truth.assertThat((Iterable)rows).containsExactly(new Object[]{Row.create((ByteString)ByteString.copyFromUtf8((String)"key"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value"))))});
        }
    }

    @Test
    public void testMultiple() {
        ImmutableList responses = ImmutableList.of((Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"key")).setFamilyName(StringValue.newBuilder().setValue("family")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"qualifier"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(true)).build(), (Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"key2")).setFamilyName(StringValue.newBuilder().setValue("family")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"qualifier"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(true)).build());
        try (RowMergerUtil util = new RowMergerUtil();){
            Truth.assertThat((Iterable)util.parseReadRowsResponses((Iterable)responses)).containsExactly(new Object[]{Row.create((ByteString)ByteString.copyFromUtf8((String)"key"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value")))), Row.create((ByteString)ByteString.copyFromUtf8((String)"key2"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value"))))});
        }
    }

    @Test
    public void testPartial() {
        ImmutableList responses = ImmutableList.of((Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"key")).setFamilyName(StringValue.newBuilder().setValue("family")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"qualifier"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(false)).build());
        RowMergerUtil util = new RowMergerUtil();
        util.parseReadRowsResponses((Iterable)responses);
        Assert.assertThrows(IllegalStateException.class, () -> ((RowMergerUtil)util).close());
    }
}

