/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.internal.RowSetUtil;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowSetUtilTest {
    @Test
    public void testSplitFullScan() {
        RowSet input = RowSet.getDefaultInstance();
        RowSet right = RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"g"), (boolean)true);
        Truth.assertThat((Object)right).isEqualTo((Object)RowSetUtilTest.parse("(g-"));
        RowSet left = RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"g"), (boolean)false);
        Truth.assertThat((Object)left).isEqualTo((Object)RowSetUtilTest.parse("-g)"));
    }

    @Test
    public void testSplitAllLeft() {
        RowSet input = RowSetUtilTest.parse("a,(a1-c),[a2-c),(a3-c),[a4-c)");
        RowSet left = RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"c"), (boolean)false);
        RowSet right = RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"c"), (boolean)true);
        Truth.assertThat((Object)left).isEqualTo((Object)input);
        Truth.assertThat((Object)right).isNull();
    }

    @Test
    public void testSplitAllRight() {
        RowSet input = RowSetUtilTest.parse("a1,c,(a-c],[a2-c],(a3-c),[a4-c)");
        Truth.assertThat((Object)RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"a"), (boolean)true)).isEqualTo((Object)input);
        Truth.assertThat((Object)RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"a"), (boolean)false)).isNull();
    }

    @Test
    public void testSplit() {
        RowSet input = RowSetUtilTest.parse("a1,c,(a1-c],[a2-c],(a3-c),[a4-c),[b-z],(b-y]");
        RowSet before = RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"b"), (boolean)false);
        RowSet after = RowSetUtil.erase((RowSet)input, (ByteString)ByteString.copyFromUtf8((String)"b"), (boolean)true);
        Truth.assertThat((Object)before).isEqualTo((Object)RowSetUtilTest.parse("a1,(a1-b),[a2-b),(a3-b),[a4-b)"));
        Truth.assertThat((Object)after).isEqualTo((Object)RowSetUtilTest.parse("c,(b-c],(b-c],(b-c),(b-c),(b-z],(b-y]"));
    }

    @Test
    public void testShardNoop() {
        RowSetUtilTest.assertShardNoSplit("a,[p-q)", new String[0]);
        RowSetUtilTest.assertShardNoSplit("0_key,[1_range_start-2_range_end)", "3_split");
        RowSetUtilTest.assertShardNoSplit("-1_range_end)", "5_split");
        RowSetUtilTest.assertShardNoSplit("0_key,[1_range_start-2_range_end)", "2_range_end");
        RowSetUtilTest.assertShardNoSplit("9_row_key,(5_range_start-7_range_end)", "3_split");
        RowSetUtilTest.assertShardNoSplit("(5_range_start-", "3_split");
        RowSetUtilTest.assertShardNoSplit("3_split,[3_split-5_split)", "3_split", "5_split");
        RowSetUtilTest.assertShardNoSplit("[3_split-", "3_split");
    }

    private static void assertShardNoSplit(String rowStr, String ... splits) {
        RowSet input = RowSetUtilTest.parse(rowStr);
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, RowSetUtilTest.splitPoints(splits))).containsExactly(new Object[]{input});
    }

    @Test
    public void testShardFullTableScan() {
        RowSet input = RowSet.getDefaultInstance();
        SortedSet<ByteString> splitPoints = RowSetUtilTest.splitPoints("a");
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, splitPoints)).containsExactly(new Object[]{RowSetUtilTest.parse("-a)"), RowSetUtilTest.parse("[a-")}).inOrder();
    }

    @Test
    public void testShardMultipleKeys() {
        RowSet input = RowSetUtilTest.parse("1_beforeSplit,2_onSplit,3_afterSplit");
        SortedSet<ByteString> splitPoints = RowSetUtilTest.splitPoints("2_onSplit");
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, splitPoints)).containsExactly(new Object[]{RowSetUtilTest.parse("1_beforeSplit"), RowSetUtilTest.parse("2_onSplit,3_afterSplit")}).inOrder();
    }

    @Test
    public void testShardKeysEmptyLeft() {
        RowSet input = RowSetUtilTest.parse("5_test,8_test");
        SortedSet<ByteString> splitPoints = RowSetUtilTest.splitPoints("0_split", "6-split");
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, splitPoints)).containsExactly(new Object[]{RowSetUtilTest.parse("5_test"), RowSetUtilTest.parse("8_test")}).inOrder();
    }

    @Test
    public void testShardKeysEmptyRight() {
        RowSet input = RowSetUtilTest.parse("0_test,2_test");
        SortedSet<ByteString> splitPoints = RowSetUtilTest.splitPoints("1_split", "5_split");
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, splitPoints)).containsExactly(new Object[]{RowSetUtilTest.parse("0_test"), RowSetUtilTest.parse("2_test")}).inOrder();
    }

    @Test
    public void testShardMixedSplit() {
        RowSet input = RowSetUtilTest.parse("0,a,c,-a],-b],(c-e],(d-f],(m-");
        SortedSet<ByteString> splitPoints = RowSetUtilTest.splitPoints("a", "d", "j", "o");
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, splitPoints)).containsExactly(new Object[]{RowSetUtilTest.parse("0,-a)"), RowSetUtilTest.parse("a,c,[a-a],-b],(c-d)"), RowSetUtilTest.parse("[d-e],(d-f]"), RowSetUtilTest.parse("(m-o)"), RowSetUtilTest.parse("[o-")}).inOrder();
    }

    @Test
    public void testShardUnsortedRequest() {
        RowSet input = RowSetUtilTest.parse("7_row_key_1,2_row_key_2,[8_range_1_start-9_range_1_end),[3_range_2_start-4_range_2_end)");
        SortedSet<ByteString> splitPoints = RowSetUtilTest.splitPoints("5-split");
        Truth.assertThat((Iterable)RowSetUtil.shard((RowSet)input, splitPoints)).containsExactly(new Object[]{RowSetUtilTest.parse("2_row_key_2,[3_range_2_start-4_range_2_end)"), RowSetUtilTest.parse("7_row_key_1,[8_range_1_start-9_range_1_end)")}).inOrder();
    }

    private static SortedSet<ByteString> splitPoints(String ... s) {
        return Arrays.stream(s).map(ByteString::copyFromUtf8).collect(Collectors.toCollection(() -> new TreeSet(ByteStringComparator.INSTANCE)));
    }

    private static RowSet parse(String encodedRowSet) {
        RowSet.Builder builder = RowSet.newBuilder();
        for (String s : encodedRowSet.split(",")) {
            if (s.contains("-")) {
                builder.addRowRanges(RowSetUtilTest.parseRange(s));
                continue;
            }
            builder.addRowKeys(ByteString.copyFromUtf8((String)s));
        }
        return builder.build();
    }

    private static RowRange parseRange(String s) {
        String encodedEnd;
        String[] parts = s.split("-", 2);
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)("Ranges must have exactly 2 parts: " + s));
        RowRange.Builder builder = RowRange.newBuilder();
        String encodedStart = parts[0];
        if (!"".equals(encodedStart)) {
            String value;
            if (encodedStart.startsWith("(")) {
                value = encodedStart.substring(1);
                builder.setStartKeyOpen(ByteString.copyFromUtf8((String)value));
            } else if (encodedStart.startsWith("[")) {
                value = encodedStart.substring(1);
                builder.setStartKeyClosed(ByteString.copyFromUtf8((String)value));
            } else {
                throw new IllegalArgumentException("unexpected range start format");
            }
        }
        if (!(encodedEnd = parts[1]).isEmpty()) {
            if (encodedEnd.endsWith(")")) {
                String value = encodedEnd.substring(0, encodedEnd.length() - 1);
                builder.setEndKeyOpen(ByteString.copyFromUtf8((String)value));
            } else if (encodedEnd.endsWith("]")) {
                String value = encodedEnd.substring(0, encodedEnd.length() - 1);
                builder.setEndKeyClosed(ByteString.copyFromUtf8((String)value));
            } else {
                throw new IllegalArgumentException("unexpected range end format");
            }
        }
        return builder.build();
    }

    @Test
    public void emptyBoundTest() {
        RowSet rowSet = RowSet.getDefaultInstance();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)Range.ByteStringRange.unbounded());
    }

    @Test
    public void singleKeyBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowKeys(ByteString.copyFromUtf8((String)"a")).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed("a")).endClosed("a"));
    }

    @Test
    public void multiKeyBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowKeys(ByteString.copyFromUtf8((String)"a")).addRowKeys(ByteString.copyFromUtf8((String)"d")).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed("a")).endClosed("d"));
    }

    @Test
    public void singleClosedClosedRangeBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyClosed(ByteString.copyFromUtf8((String)"b"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed("a")).endClosed("b"));
    }

    @Test
    public void singleClosedOpenRangeBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"b"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed("a")).endOpen("b"));
    }

    @Test
    public void singleOpenOpenRangeBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"b"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen("a")).endOpen("b"));
    }

    @Test
    public void singleRangeOpenClosedBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"a")).setEndKeyClosed(ByteString.copyFromUtf8((String)"b"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen("a")).endClosed("b"));
    }

    @Test
    public void singleRangeUnbounded1BoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)Range.ByteStringRange.unbounded().startClosed("a"));
    }

    @Test
    public void singleRangeUnbounded2BoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setEndKeyClosed(ByteString.copyFromUtf8((String)"z"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)Range.ByteStringRange.unbounded().endClosed("z"));
    }

    @Test
    public void multipleRangeBoundTest() {
        RowSet rowSet = RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"m"))).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"q")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z"))).build();
        Range.ByteStringRange actual = RowSetUtil.getBound((RowSet)rowSet);
        Truth.assertThat((Object)actual).isEqualTo((Object)Range.ByteStringRange.create((String)"a", (String)"z"));
    }

    private static void verifyShard(RowSet input, SortedSet<ByteString> splits, RowSet ... expected) {
        List actualWithNull = RowSetUtil.shard((RowSet)input, splits);
        Truth.assertThat((Iterable)actualWithNull).containsExactlyElementsIn(Arrays.asList(expected)).inOrder();
    }
}

