/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.v2.ColumnMetadata;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.internal.SqlRowMergerUtil;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlRowMergerUtilTest {
    @Test
    public void close_succeedsWhenEmpty() {
        SqlRowMergerUtil util = new SqlRowMergerUtil();
        util.close();
        util = new SqlRowMergerUtil();
        try {
            List list = util.parseExecuteQueryResponses(ImmutableList.of((Object)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType()))));
        }
        finally {
            util.close();
        }
    }

    @Test
    public void parseExecuteQueryResponses_failsWithoutMetadata_serializedProtoRows() {
        try (SqlRowMergerUtil util = new SqlRowMergerUtil();){
            Assert.assertThrows(IllegalStateException.class, () -> util.parseExecuteQueryResponses(ImmutableList.of((Object)SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("val")))));
        }
    }

    @Test
    public void parseExecuteQueryResponses_handlesSingleValue_serializedProtoRows() {
        ExecuteQueryResponse metadata = SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()));
        ImmutableList responses = ImmutableList.of((Object)metadata, (Object)SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("val")));
        try (SqlRowMergerUtil util = new SqlRowMergerUtil();){
            List rows = util.parseExecuteQueryResponses(responses);
            Truth.assertThat((Iterable)rows).containsExactly(new Object[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType())).getMetadata()), (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("val")))});
        }
    }

    @Test
    public void parseExecuteQueryResponses_handlesMultipleValuesAccrossMultipleRows_serializedProtoRows() {
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType()), SqlProtoFactory.columnMetadata("strArr", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.columnMetadata("map", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType()))};
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(columns).getMetadata());
        ImmutableList responses = ImmutableList.of((Object)SqlProtoFactory.metadata(columns), (Object)SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("str1"), SqlProtoFactory.bytesValue("bytes1"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr1")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key1"), SqlProtoFactory.bytesValue("val1"))), SqlProtoFactory.stringValue("str2")), (Object)SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.bytesValue("bytes2"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr2")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.bytesValue("val2")))), (Object)SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("str3"), SqlProtoFactory.bytesValue("bytes3"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr3")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key3"), SqlProtoFactory.bytesValue("val3")))));
        try (SqlRowMergerUtil util = new SqlRowMergerUtil();){
            List rows = util.parseExecuteQueryResponses(responses);
            Truth.assertThat((Iterable)rows).containsExactly(new Object[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("str1"), (Object)SqlProtoFactory.bytesValue("bytes1"), (Object)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr1")), (Object)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key1"), SqlProtoFactory.bytesValue("val1"))))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("str2"), (Object)SqlProtoFactory.bytesValue("bytes2"), (Object)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr2")), (Object)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.bytesValue("val2"))))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("str3"), (Object)SqlProtoFactory.bytesValue("bytes3"), (Object)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr3")), (Object)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key3"), SqlProtoFactory.bytesValue("val3")))))});
        }
    }

    @Test
    public void parseExecuteQueryResponses_throwsOnCloseWithPartialBatch_serializedProtoRows() {
        ImmutableList responses = ImmutableList.of((Object)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType())), (Object)SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("str1")));
        SqlRowMergerUtil util = new SqlRowMergerUtil();
        List unused = util.parseExecuteQueryResponses(responses);
        Assert.assertThrows(IllegalStateException.class, () -> ((SqlRowMergerUtil)util).close());
    }

    @Test
    public void parseExecuteQueryResponses_throwsOnParseWithPartialRowsInCompleteBatch_serializedProtoRows() {
        ImmutableList responses = ImmutableList.of((Object)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())), (Object)SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("str1"), SqlProtoFactory.bytesValue("bytes1"), SqlProtoFactory.stringValue("str2")));
        SqlRowMergerUtil util = new SqlRowMergerUtil();
        Assert.assertThrows(IllegalStateException.class, () -> util.parseExecuteQueryResponses(responses));
    }

    @Test
    public void parseExecuteQueryResponses_worksWithIncrementalSetsOfResponses_serializedProtoRows() {
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType()), SqlProtoFactory.columnMetadata("strArr", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.columnMetadata("map", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType()))};
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(columns).getMetadata());
        ImmutableList responses = ImmutableList.of((Object)SqlProtoFactory.metadata(columns), (Object)SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("str1"), SqlProtoFactory.bytesValue("bytes1"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr1")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key1"), SqlProtoFactory.bytesValue("val1"))), SqlProtoFactory.stringValue("str2")), (Object)SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.bytesValue("bytes2"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr2")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.bytesValue("val2")))), (Object)SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("str3"), SqlProtoFactory.bytesValue("bytes3"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr3")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key3"), SqlProtoFactory.bytesValue("val3")))));
        try (SqlRowMergerUtil util = new SqlRowMergerUtil();){
            ArrayList rows = new ArrayList();
            rows.addAll(util.parseExecuteQueryResponses(responses.subList(0, 1)));
            rows.addAll(util.parseExecuteQueryResponses(responses.subList(1, 2)));
            rows.addAll(util.parseExecuteQueryResponses(responses.subList(2, 3)));
            rows.addAll(util.parseExecuteQueryResponses(responses.subList(3, 4)));
            Truth.assertThat(rows).containsExactly(new Object[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("str1"), (Object)SqlProtoFactory.bytesValue("bytes1"), (Object)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr1")), (Object)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key1"), SqlProtoFactory.bytesValue("val1"))))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("str2"), (Object)SqlProtoFactory.bytesValue("bytes2"), (Object)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr2")), (Object)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.bytesValue("val2"))))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("str3"), (Object)SqlProtoFactory.bytesValue("bytes3"), (Object)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("arr3")), (Object)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key3"), SqlProtoFactory.bytesValue("val3")))))});
        }
    }
}

