/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.client.util.Lists;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTestUtils;
import com.google.cloud.bigtable.data.v2.stub.metrics.CustomOpenTelemetryMetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.cloud.bigtable.test_helpers.env.CloudEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.common.base.Stopwatch;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Ignore(value="Temporarily disable flaky test")
@RunWith(value=JUnit4.class)
public class BuiltinMetricsIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    private static final Logger logger = Logger.getLogger(BuiltinMetricsIT.class.getName());
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)900L);
    private Table tableCustomOtel;
    private Table tableDefault;
    private BigtableDataClient clientCustomOtel;
    private BigtableDataClient clientDefault;
    private BigtableTableAdminClient tableAdminClient;
    private MetricServiceClient metricClient;
    private InMemoryMetricReader metricReader;
    public static String[] VIEWS = new String[]{"operation_latencies", "attempt_latencies", "connectivity_error_count", "application_blocking_latencies"};

    @Before
    public void setup() throws IOException {
        TruthJUnit.assume().withMessage("Builtin metrics integration test is not supported by emulator").that((Object)testEnvRule.env()).isInstanceOf(CloudEnv.class);
        String appProfileId = testEnvRule.env().getDataClientSettings().getAppProfileId();
        TruthJUnit.assume().withMessage("Builtin metrics integration test needs to be able to use a custom app profile and the app profile is currently forced to " + appProfileId).that(appProfileId).isEmpty();
        this.metricClient = MetricServiceClient.create();
        this.tableAdminClient = testEnvRule.env().getTableAdminClient();
        this.metricReader = InMemoryMetricReader.create();
        SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)this.metricReader);
        CustomOpenTelemetryMetricsProvider.setupSdkMeterProvider((SdkMeterProviderBuilder)meterProvider);
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        BigtableDataSettings.Builder settings = testEnvRule.env().getDataClientSettings().toBuilder();
        this.clientCustomOtel = BigtableDataClient.create((BigtableDataSettings)settings.setMetricsProvider((MetricsProvider)CustomOpenTelemetryMetricsProvider.create((OpenTelemetry)openTelemetry)).build());
        this.clientDefault = BigtableDataClient.create((BigtableDataSettings)settings.build());
    }

    @After
    public void tearDown() {
        if (this.metricClient != null) {
            this.metricClient.close();
        }
        if (this.tableCustomOtel != null) {
            this.tableAdminClient.deleteTable(this.tableCustomOtel.getId());
        }
        if (this.tableDefault != null) {
            this.tableAdminClient.deleteTable(this.tableDefault.getId());
        }
        if (this.clientCustomOtel != null) {
            this.clientCustomOtel.close();
        }
        if (this.clientDefault != null) {
            this.clientDefault.close();
        }
    }

    @Test
    public void testBuiltinMetricsWithDefaultOTEL() throws Exception {
        logger.info("Started testing builtin metrics with default OTEL");
        this.tableDefault = this.tableAdminClient.createTable(CreateTableRequest.of((String)PrefixGenerator.newPrefix("BuiltinMetricsIT#test1")).addFamily("cf"));
        logger.info("Create default table: " + this.tableDefault.getId());
        Instant start = Instant.now().minus(java.time.Duration.ofSeconds(10L));
        this.clientDefault.mutateRow(RowMutation.create((String)this.tableDefault.getId(), (String)"a-new-key").setCell("cf", "q", "abc"));
        ArrayList rows = Lists.newArrayList((Iterable)this.clientDefault.readRows(Query.create((String)this.tableDefault.getId()).limit(10L)));
        Stopwatch metricsPollingStopwatch = Stopwatch.createStarted();
        ProjectName name = ProjectName.of((String)testEnvRule.env().getProjectId());
        Instant end = Instant.now().plus(java.time.Duration.ofMinutes(3L));
        TimeInterval interval = TimeInterval.newBuilder().setStartTime(Timestamps.fromMillis((long)start.toEpochMilli())).setEndTime(Timestamps.fromMillis((long)end.toEpochMilli())).build();
        for (String view : VIEWS) {
            String metricFilter = String.format("metric.type=\"bigtable.googleapis.com/client/%s\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Bigtable.MutateRow\" AND resource.labels.table=\"%s\"", view, testEnvRule.env().getInstanceId(), this.tableDefault.getId());
            ListTimeSeriesRequest.Builder requestBuilder = ListTimeSeriesRequest.newBuilder().setName(name.toString()).setFilter(metricFilter).setInterval(interval).setView(ListTimeSeriesRequest.TimeSeriesView.FULL);
            this.verifyMetricsArePublished(requestBuilder.build(), metricsPollingStopwatch, view);
            metricFilter = String.format("metric.type=\"bigtable.googleapis.com/client/%s\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Bigtable.ReadRows\" AND resource.labels.table=\"%s\"", view, testEnvRule.env().getInstanceId(), this.tableDefault.getId());
            requestBuilder.setFilter(metricFilter);
            this.verifyMetricsArePublished(requestBuilder.build(), metricsPollingStopwatch, view);
        }
    }

    @Test
    public void testBuiltinMetricsWithCustomOTEL() throws Exception {
        logger.info("Started testing builtin metrics with custom OTEL");
        this.tableCustomOtel = this.tableAdminClient.createTable(CreateTableRequest.of((String)PrefixGenerator.newPrefix("BuiltinMetricsIT#test2")).addFamily("cf"));
        logger.info("Create custom table: " + this.tableCustomOtel.getId());
        Instant start = Instant.now().minus(java.time.Duration.ofSeconds(10L));
        this.clientCustomOtel.mutateRow(RowMutation.create((String)this.tableCustomOtel.getId(), (String)"a-new-key").setCell("cf", "q", "abc"));
        ArrayList rows = Lists.newArrayList((Iterable)this.clientCustomOtel.readRows(Query.create((String)this.tableCustomOtel.getId()).limit(10L)));
        Stopwatch metricsPollingStopwatch = Stopwatch.createStarted();
        ProjectName name = ProjectName.of((String)testEnvRule.env().getProjectId());
        Instant end = start.plus(java.time.Duration.ofMinutes(3L));
        TimeInterval interval = TimeInterval.newBuilder().setStartTime(Timestamps.fromMillis((long)start.toEpochMilli())).setEndTime(Timestamps.fromMillis((long)end.toEpochMilli())).build();
        String[] stringArray = VIEWS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String view;
            String otelMetricName = view = stringArray[i];
            if (view.equals("application_blocking_latencies")) {
                otelMetricName = "application_latencies";
            }
            MetricData dataFromReader = BuiltinMetricsTestUtils.getMetricData(this.metricReader, otelMetricName);
            String metricFilter = String.format("metric.type=\"bigtable.googleapis.com/client/%s\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Bigtable.MutateRow\" AND resource.labels.table=\"%s\"", view, testEnvRule.env().getInstanceId(), this.tableCustomOtel.getId());
            ListTimeSeriesRequest.Builder requestBuilder = ListTimeSeriesRequest.newBuilder().setName(name.toString()).setFilter(metricFilter).setInterval(interval).setView(ListTimeSeriesRequest.TimeSeriesView.FULL);
            ListTimeSeriesResponse response = this.verifyMetricsArePublished(requestBuilder.build(), metricsPollingStopwatch, view);
            this.verifyMetricsWithMetricsReader(response, dataFromReader);
            metricFilter = String.format("metric.type=\"bigtable.googleapis.com/client/%s\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Bigtable.ReadRows\" AND resource.labels.table=\"%s\"", view, testEnvRule.env().getInstanceId(), this.tableCustomOtel.getId());
            requestBuilder.setFilter(metricFilter);
            response = this.verifyMetricsArePublished(requestBuilder.build(), metricsPollingStopwatch, view);
            this.verifyMetricsWithMetricsReader(response, dataFromReader);
        }
    }

    private ListTimeSeriesResponse verifyMetricsArePublished(ListTimeSeriesRequest request, Stopwatch metricsPollingStopwatch, String view) throws Exception {
        ListTimeSeriesResponse response = (ListTimeSeriesResponse)this.metricClient.listTimeSeriesCallable().call((Object)request);
        while (response.getTimeSeriesCount() == 0 && metricsPollingStopwatch.elapsed(TimeUnit.MINUTES) < 10L) {
            logger.log(Level.INFO, "Checking for view " + view + ", has timeseries=" + response.getTimeSeriesCount() + " stopwatch elapsed " + metricsPollingStopwatch.elapsed(TimeUnit.MINUTES));
            Thread.sleep(java.time.Duration.ofMinutes(1L).toMillis());
            response = (ListTimeSeriesResponse)this.metricClient.listTimeSeriesCallable().call((Object)request);
        }
        Truth.assertWithMessage((String)("View " + view + " didn't return any data.")).that(Integer.valueOf(response.getTimeSeriesCount())).isGreaterThan((Comparable)Integer.valueOf(0));
        return response;
    }

    private void verifyMetricsWithMetricsReader(ListTimeSeriesResponse response, MetricData dataFromReader) {
        for (TimeSeries ts : response.getTimeSeriesList()) {
            ImmutableMap attributesMap = ImmutableMap.builder().putAll(ts.getResource().getLabelsMap()).putAll(ts.getMetric().getLabelsMap()).build();
            AttributesBuilder attributesBuilder = Attributes.builder();
            String streamingKey = BuiltinMetricsConstants.STREAMING_KEY.getKey();
            attributesMap.forEach((k, v) -> {
                if (!k.equals(streamingKey)) {
                    attributesBuilder.put(k, v);
                }
            });
            if (attributesMap.containsKey(streamingKey)) {
                attributesBuilder.put(streamingKey, Boolean.parseBoolean((String)attributesMap.get(streamingKey)));
            }
            Attributes attributes = attributesBuilder.build();
            BuiltinMetricsTestUtils.verifyAttributes(dataFromReader, attributes);
            long expectedValue = BuiltinMetricsTestUtils.getAggregatedValue(dataFromReader, attributes);
            Timestamp startTime = BuiltinMetricsTestUtils.getStartTimeSeconds(dataFromReader, attributes);
            Truth.assertThat((Long)startTime.getSeconds()).isGreaterThan(0);
            List point = ts.getPointsList().stream().filter(p -> Timestamps.compare((Timestamp)p.getInterval().getStartTime(), (Timestamp)startTime) >= 0 && Timestamps.compare((Timestamp)p.getInterval().getStartTime(), (Timestamp)Timestamps.add((Timestamp)startTime, (Duration)Duration.newBuilder().setSeconds(60L).build())) < 0).collect(Collectors.toList());
            if (point.size() <= 0) continue;
            long actualValue = (long)((Point)point.get(0)).getValue().getDistributionValue().getMean();
            Truth.assertWithMessage((String)(ts.getMetric().getType() + " actual value does not match expected value, actual value " + actualValue + " expected value " + expectedValue + " actual start time " + ((Point)point.get(0)).getInterval().getStartTime() + " expected start time " + startTime)).that(Long.valueOf(actualValue)).isIn(Range.range((Comparable)Long.valueOf(expectedValue - 1L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(expectedValue + 1L), (BoundType)BoundType.CLOSED));
        }
    }
}

