/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlEventStats;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BulkMutateIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test(timeout=60000L)
    public void test() throws IOException, InterruptedException {
        BigtableDataSettings settings = testEnvRule.env().getDataClientSettings();
        String rowPrefix = UUID.randomUUID().toString();
        BigtableDataSettings.Builder builder = settings.toBuilder().enableBatchMutationLatencyBasedThrottling(2L);
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)builder.build());
             BatcherImpl batcher = (BatcherImpl)client.newBulkMutationBatcher(testEnvRule.env().getTableId());){
            FlowControlEventStats events = batcher.getFlowController().getFlowControlEventStats();
            long initialThreashold = Objects.requireNonNull(batcher.getFlowController().getCurrentElementCountLimit());
            Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isNotEqualTo((Object)batcher.getFlowController().getMinElementCountLimit());
            Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isNotEqualTo((Object)batcher.getFlowController().getMaxElementCountLimit());
            String familyId = testEnvRule.env().getFamilyId();
            long initial = batcher.getFlowController().getCurrentElementCountLimit();
            for (long i = 0L; i < initial * 3L; ++i) {
                String key = rowPrefix + "test-key" + i;
                batcher.add((Object)RowMutationEntry.create((String)key).setCell(familyId, "qualifier", i));
            }
            batcher.flush();
            Truth.assertThat((Comparable)events.getLastFlowControlEvent()).isNotNull();
            Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isNotEqualTo((Object)initialThreashold);
            Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowPrefix + "test-key" + initial));
            Truth.assertThat((Iterable)row.getCells()).hasSize(1);
        }
    }

    @Test(timeout=60000L)
    public void testOnAuthorizedView() throws IOException, InterruptedException {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataSettings settings = testEnvRule.env().getDataClientSettings();
        String rowPrefix = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        BigtableDataSettings.Builder builder = settings.toBuilder().enableBatchMutationLatencyBasedThrottling(2L);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)builder.build());
             Batcher batcher = client.newBulkMutationBatcher((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()));){
            String familyId = testEnvRule.env().getFamilyId();
            batcher.add((Object)RowMutationEntry.create((String)(rowPrefix + "test-key")).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "value"));
            batcher.flush();
            Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowPrefix + "test-key"));
            Truth.assertThat((Iterable)row.getCells()).hasSize(1);
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }

    @Test
    public void testManyMutations() throws IOException, InterruptedException {
        TruthJUnit.assume().withMessage("testManyMutations is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataSettings settings = testEnvRule.env().getDataClientSettings();
        String rowPrefix = UUID.randomUUID().toString();
        BatchingSettings batchingSettings = settings.getStubSettings().bulkMutateRowsSettings().getBatchingSettings();
        settings.toBuilder().stubSettings().bulkMutateRowsSettings().setBatchingSettings(batchingSettings.toBuilder().setDelayThreshold(Duration.ofHours((long)1L)).build());
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)settings);
             BatcherImpl batcher = (BatcherImpl)client.newBulkMutationBatcher(testEnvRule.env().getTableId());){
            String familyId = testEnvRule.env().getFamilyId();
            for (int i = 0; i < 2; ++i) {
                String key = rowPrefix + "test-key";
                RowMutationEntry rowMutationEntry = RowMutationEntry.create((String)key);
                for (long j = 0L; j < 50001L; ++j) {
                    rowMutationEntry.setCell(familyId, "q" + j + i, j);
                }
                batcher.add((Object)rowMutationEntry);
            }
            batcher.flush();
            Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowPrefix + "test-key"));
            Truth.assertThat((Iterable)row.getCells()).hasSize(100002);
        }
    }

    @Test(timeout=60000L)
    public void testManyMutationsOnAuthorizedView() throws IOException, InterruptedException {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        BigtableDataSettings settings = testEnvRule.env().getDataClientSettings();
        String rowPrefix = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        BatchingSettings batchingSettings = settings.getStubSettings().bulkMutateRowsSettings().getBatchingSettings();
        settings.toBuilder().stubSettings().bulkMutateRowsSettings().setBatchingSettings(batchingSettings.toBuilder().setDelayThreshold(Duration.ofHours((long)1L)).build());
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)settings);
             Batcher batcher = client.newBulkMutationBatcher((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()));){
            String familyId = testEnvRule.env().getFamilyId();
            for (int i = 0; i < 2; ++i) {
                String key = rowPrefix + "test-key";
                RowMutationEntry rowMutationEntry = RowMutationEntry.create((String)key);
                for (long j = 0L; j < 50001L; ++j) {
                    rowMutationEntry.setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + j + i, j);
                }
                batcher.add((Object)rowMutationEntry);
            }
            batcher.flush();
            Row row = (Row)client.readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowPrefix + "test-key"));
            Truth.assertThat((Iterable)row.getCells()).hasSize(100002);
        }
        try {
            client = BigtableDataClient.create((BigtableDataSettings)settings);
            try (Batcher batcherOutsideAuthorizedView = client.newBulkMutationBatcher((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()));){
                String keyOutsideAuthorizedView = UUID.randomUUID() + "-outside-authorized-view";
                RowMutationEntry rowMutationEntry = RowMutationEntry.create((String)keyOutsideAuthorizedView);
                rowMutationEntry.setCell(testEnvRule.env().getFamilyId(), AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "test-value");
                batcherOutsideAuthorizedView.add((Object)rowMutationEntry);
                batcherOutsideAuthorizedView.flush();
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            Assert.fail((String)"Should not be able to apply bulk mutation on rows outside authorized view");
        }
        catch (Exception exception) {
            // empty catch block
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }
}

