/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.Batcher;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BulkReadIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    private static String AUTHORIZED_VIEW_ROW_PREFIX = "row#";
    private static String AUTHORIZED_VIEW_COLUMN_QUALIFIER = "qualifier";

    @Test
    public void testBulkRead() throws InterruptedException, ExecutionException {
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String family = testEnvRule.env().getFamilyId();
        String rowPrefix = UUID.randomUUID().toString();
        int numRows = 10;
        BulkMutation bulkMutation = BulkMutation.create((String)testEnvRule.env().getTableId());
        ArrayList<Row> expectedRows = new ArrayList<Row>();
        for (int i = 0; i < numRows; ++i) {
            bulkMutation.add(RowMutationEntry.create((String)(rowPrefix + "-" + i)).setCell(family, "qualifier", 10000L, "value-" + i));
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(rowPrefix + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)family, (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)10000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)("value-" + i))))));
        }
        client.bulkMutateRows(bulkMutation);
        try (Batcher batcher = client.newBulkReadRowsBatcher(testEnvRule.env().getTableId());){
            ArrayList<ApiFuture> rowFutures = new ArrayList<ApiFuture>(numRows);
            for (int rowCount = 0; rowCount < numRows; ++rowCount) {
                ApiFuture entryResponse = batcher.add((Object)ByteString.copyFromUtf8((String)(rowPrefix + "-" + rowCount)));
                rowFutures.add(entryResponse);
            }
            batcher.flush();
            List actualRows = (List)ApiFutures.allAsList(rowFutures).get();
            Truth.assertThat((Iterable)actualRows).isEqualTo(expectedRows);
            rowFutures = new ArrayList();
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)UUID.randomUUID().toString())));
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)(rowPrefix + "-" + 0))));
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)(rowPrefix + "-" + 0))));
            batcher.flush();
            actualRows = (List)ApiFutures.allAsList(rowFutures).get();
            Truth.assertThat(actualRows.get(0)).isNull();
            Truth.assertThat(actualRows.get(1)).isEqualTo(expectedRows.get(0));
            Truth.assertThat(actualRows.get(2)).isEqualTo(expectedRows.get(0));
        }
    }

    @Test
    public void testBulkReadOnAuthorizedView() throws InterruptedException, ExecutionException {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String family = testEnvRule.env().getFamilyId();
        String rowPrefix = AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        int numRows = 10;
        BulkMutation bulkMutation = BulkMutation.create((String)testEnvRule.env().getTableId());
        ArrayList<Row> expectedRows = new ArrayList<Row>();
        for (int i = 0; i < numRows; ++i) {
            bulkMutation.add(RowMutationEntry.create((String)(rowPrefix + "-" + i)).setCell(family, AUTHORIZED_VIEW_COLUMN_QUALIFIER, 10000L, "value-" + i));
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(rowPrefix + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)family, (ByteString)ByteString.copyFromUtf8((String)AUTHORIZED_VIEW_COLUMN_QUALIFIER), (long)10000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)("value-" + i))))));
        }
        String rowPrefixForRowOutsideAuthorizedView = rowPrefix + numRows;
        bulkMutation.add(RowMutationEntry.create((String)rowPrefixForRowOutsideAuthorizedView).setCell(family, "outside-authorized-view", 10000L, "test-value"));
        client.bulkMutateRows(bulkMutation);
        try (Batcher batcher = client.newBulkReadRowsBatcher((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()));){
            ArrayList<ApiFuture> rowFutures = new ArrayList<ApiFuture>(numRows);
            for (int rowCount = 0; rowCount < numRows; ++rowCount) {
                ApiFuture entryResponse = batcher.add((Object)ByteString.copyFromUtf8((String)(rowPrefix + "-" + rowCount)));
                rowFutures.add(entryResponse);
            }
            batcher.flush();
            List actualRows = (List)ApiFutures.allAsList(rowFutures).get();
            Truth.assertThat((Iterable)actualRows).isEqualTo(expectedRows);
            rowFutures = new ArrayList();
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)UUID.randomUUID().toString())));
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)(rowPrefix + "-" + 0))));
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)(rowPrefix + "-" + 0))));
            rowFutures.add(batcher.add((Object)ByteString.copyFromUtf8((String)rowPrefixForRowOutsideAuthorizedView)));
            batcher.flush();
            actualRows = (List)ApiFutures.allAsList(rowFutures).get();
            Truth.assertThat(actualRows.get(0)).isNull();
            Truth.assertThat(actualRows.get(1)).isEqualTo(expectedRows.get(0));
            Truth.assertThat(actualRows.get(2)).isEqualTo(expectedRows.get(0));
            Truth.assertThat(actualRows.get(3)).isNull();
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }
}

