/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CheckAndMutateIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws Exception {
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String rowKey = UUID.randomUUID().toString();
        testEnvRule.env().getDataClient().mutateRowCallable().call((Object)RowMutation.create((String)tableId, (String)rowKey).setCell(familyId, "q1", "val1").setCell(familyId, "q2", "val2"));
        testEnvRule.env().getDataClient().checkAndMutateRowAsync(ConditionalRowMutation.create((String)tableId, (String)rowKey).condition(Filters.FILTERS.qualifier().exactMatch("q1")).then(Mutation.create().setCell(familyId, "q3", "q1"))).get(1L, TimeUnit.MINUTES);
        Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)tableId).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"q1"));
    }

    @Test
    public void testOnAuthorizedView() throws Exception {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String rowKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        BigtableDataClient dataClient = testEnvRule.env().getDataClient();
        dataClient.mutateRowCallable().call((Object)RowMutation.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKey).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "1", "val1").setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "2", "val2"));
        dataClient.checkAndMutateRowAsync(ConditionalRowMutation.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKey).condition(Filters.FILTERS.qualifier().exactMatch(AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "1")).then(Mutation.create().setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "3", "q1"))).get(1L, TimeUnit.MINUTES);
        Row row = (Row)dataClient.readRowsCallable().first().call((Object)Query.create((String)tableId).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"q1"));
        String rowKeyOutsideAuthorizedView = UUID.randomUUID() + "-outside-authorized-view";
        dataClient.mutateRowCallable().call((Object)RowMutation.create((String)tableId, (String)rowKeyOutsideAuthorizedView).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "value"));
        try {
            dataClient.checkAndMutateRowAsync(ConditionalRowMutation.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKeyOutsideAuthorizedView).condition(Filters.FILTERS.qualifier().exactMatch(AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER)).then(Mutation.create().setCell(familyId, "new_qualifier", "new-value"))).get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not be able to conditional mutate row outside authorized view");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(PermissionDeniedException.class);
        }
        try {
            dataClient.checkAndMutateRowAsync(ConditionalRowMutation.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKey).condition(Filters.FILTERS.qualifier().exactMatch(AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER)).then(Mutation.create().setCell(familyId, "new_qualifier", "new-value"))).get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not be able to perform mutations with cells outside the authorized view");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(PermissionDeniedException.class);
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }
}

