/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSet;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.models.sql.Statement;
import com.google.cloud.bigtable.data.v2.models.sql.Struct;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExecuteQueryIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    private static BigtableDataClient dataClient;
    private static String tableId;
    private static String cf;
    private static String uniquePrefix;

    @BeforeClass
    public static void setUpAll() throws IOException {
        TruthJUnit.assume().withMessage("ExecuteQuery is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        tableId = testEnvRule.env().getTableId();
        dataClient = testEnvRule.env().getDataClient();
        cf = testEnvRule.env().getFamilyId();
        uniquePrefix = UUID.randomUUID() + "-execute-query-it-";
        dataClient.mutateRow(RowMutation.create((TargetId)TableId.of((String)tableId), (String)(uniquePrefix + "a")).setCell(cf, ByteString.copyFromUtf8((String)"qual"), 1000L, ByteString.copyFromUtf8((String)"old")).setCell(cf, ByteString.copyFromUtf8((String)"qual2"), 1000L, ByteString.copyFromUtf8((String)"old2")));
        dataClient.mutateRow(RowMutation.create((TargetId)TableId.of((String)tableId), (String)(uniquePrefix + "a")).setCell(cf, ByteString.copyFromUtf8((String)"qual"), 10000L, ByteString.copyFromUtf8((String)"val")).setCell(cf, ByteString.copyFromUtf8((String)"qual2"), 10000L, ByteString.copyFromUtf8((String)"val2")).setCell(cf, ByteString.copyFromUtf8((String)"qual3"), 10000L, ByteString.copyFromUtf8((String)"val3")));
        dataClient.mutateRow(RowMutation.create((TargetId)TableId.of((String)tableId), (String)(uniquePrefix + "b")).setCell(cf, ByteString.copyFromUtf8((String)"qual"), 10000L, ByteString.copyFromUtf8((String)"bval")).setCell(cf, ByteString.copyFromUtf8((String)"qual2"), 10000L, ByteString.copyFromUtf8((String)"bval2")));
    }

    @Test
    public void selectStar() {
        try (ResultSet rs = dataClient.executeQuery(Statement.of((String)("SELECT * FROM " + tableId + " WHERE _key LIKE '" + uniquePrefix + "%'")));){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)rs.getBytes("_key")).isEqualTo((Object)ByteString.copyFromUtf8((String)(uniquePrefix + "a")));
            Truth.assertThat((Iterable)((Iterable)rs.getMap(cf, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())).get(ByteString.copyFromUtf8((String)"qual")))).isEqualTo((Object)ByteString.copyFromUtf8((String)"val"));
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)rs.getBytes("_key")).isEqualTo((Object)ByteString.copyFromUtf8((String)(uniquePrefix + "b")));
            Truth.assertThat((Iterable)((Iterable)rs.getMap(cf, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes())).get(ByteString.copyFromUtf8((String)"qual")))).isEqualTo((Object)ByteString.copyFromUtf8((String)"bval"));
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void withHistoryQuery() {
        try (ResultSet rs = dataClient.executeQuery(Statement.of((String)("SELECT * FROM `" + tableId + "`(with_history => true) WHERE _key LIKE '" + uniquePrefix + "%'")));){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)rs.getBytes("_key")).isEqualTo((Object)ByteString.copyFromUtf8((String)(uniquePrefix + "a")));
            Map rowACf = rs.getMap(cf, SqlType.historicalMap());
            List rowAQual = (List)rowACf.get(ByteString.copyFromUtf8((String)"qual"));
            Truth.assertThat((Integer)rowAQual.size()).isEqualTo((Object)2);
            Struct rowAQual_0 = (Struct)rowAQual.get(0);
            Truth.assertThat((Iterable)rowAQual_0.getBytes("value")).isEqualTo((Object)ByteString.copyFromUtf8((String)"val"));
            Truth.assertThat((Comparable)rowAQual_0.getTimestamp("timestamp")).isEqualTo((Object)Instant.ofEpochMilli(10L));
            Struct rowAQual_1 = (Struct)rowAQual.get(1);
            Truth.assertThat((Iterable)rowAQual_1.getBytes("value")).isEqualTo((Object)ByteString.copyFromUtf8((String)"old"));
            Truth.assertThat((Comparable)rowAQual_1.getTimestamp("timestamp")).isEqualTo((Object)Instant.ofEpochMilli(1L));
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)rs.getBytes("_key")).isEqualTo((Object)ByteString.copyFromUtf8((String)(uniquePrefix + "b")));
            Map rowBCf = rs.getMap(cf, SqlType.historicalMap());
            List rowBQual = (List)rowBCf.get(ByteString.copyFromUtf8((String)"qual"));
            Truth.assertThat((Integer)rowBQual.size()).isEqualTo((Object)1);
            Struct rowBQual_0 = (Struct)rowBQual.get(0);
            Truth.assertThat((Iterable)rowBQual_0.getBytes("value")).isEqualTo((Object)ByteString.copyFromUtf8((String)"bval"));
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void allTypes() {
        try (ResultSet rs = dataClient.executeQuery(Statement.of((String)("SELECT 'stringVal' AS strCol, b'foo' as bytesCol, 1 AS intCol, CAST(1.2 AS FLOAT32) as f32Col, CAST(1.3 AS FLOAT64) as f64Col, true as boolCol, TIMESTAMP_FROM_UNIX_MILLIS(1000) AS tsCol, DATE(2024, 06, 01) as dateCol, STRUCT(1 as a, \"foo\" as b) AS structCol, [1,2,3] AS arrCol, " + cf + " as mapCol FROM `" + tableId + "` WHERE _key='" + uniquePrefix + "a' LIMIT 1")));){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((String)rs.getString("strCol")).isEqualTo((Object)"stringVal");
            Truth.assertThat((String)rs.getString(0)).isEqualTo((Object)"stringVal");
            Truth.assertThat((Iterable)rs.getBytes("bytesCol")).isEqualTo((Object)ByteString.copyFromUtf8((String)"foo"));
            Truth.assertThat((Iterable)rs.getBytes(1)).isEqualTo((Object)ByteString.copyFromUtf8((String)"foo"));
            Truth.assertThat((Long)rs.getLong("intCol")).isEqualTo((Object)1L);
            Truth.assertThat((Long)rs.getLong(2)).isEqualTo((Object)1L);
            Truth.assertThat((Float)Float.valueOf(rs.getFloat("f32Col"))).isEqualTo((Object)Float.valueOf(1.2f));
            Truth.assertThat((Float)Float.valueOf(rs.getFloat(3))).isEqualTo((Object)Float.valueOf(1.2f));
            Truth.assertThat((Double)rs.getDouble("f64Col")).isEqualTo((Object)1.3);
            Truth.assertThat((Double)rs.getDouble(4)).isEqualTo((Object)1.3);
            Truth.assertThat((Boolean)rs.getBoolean("boolCol")).isTrue();
            Truth.assertThat((Boolean)rs.getBoolean(5)).isTrue();
            Truth.assertThat((Comparable)rs.getTimestamp("tsCol")).isEqualTo((Object)Instant.ofEpochMilli(1000L));
            Truth.assertThat((Comparable)rs.getTimestamp(6)).isEqualTo((Object)Instant.ofEpochMilli(1000L));
            Truth.assertThat((Comparable)rs.getDate("dateCol")).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)1));
            Truth.assertThat((Comparable)rs.getDate(7)).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)1));
            Truth.assertThat((Long)rs.getStruct("structCol").getLong("a")).isEqualTo((Object)1);
            Truth.assertThat((String)rs.getStruct("structCol").getString("b")).isEqualTo((Object)"foo");
            Truth.assertThat((Long)rs.getStruct(8).getLong("a")).isEqualTo((Object)1);
            Truth.assertThat((String)rs.getStruct(8).getString("b")).isEqualTo((Object)"foo");
            Truth.assertThat((Iterable)rs.getList("arrCol", SqlType.arrayOf((SqlType)SqlType.int64()))).isEqualTo(Arrays.asList(1L, 2L, 3L));
            Truth.assertThat((Iterable)rs.getList(9, SqlType.arrayOf((SqlType)SqlType.int64()))).isEqualTo(Arrays.asList(1L, 2L, 3L));
            Truth.assertThat((Map)rs.getMap("mapCol", SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes()))).isEqualTo((Object)new HashMap<ByteString, ByteString>(){
                {
                    this.put(ByteString.copyFromUtf8((String)"qual"), ByteString.copyFromUtf8((String)"val"));
                    this.put(ByteString.copyFromUtf8((String)"qual2"), ByteString.copyFromUtf8((String)"val2"));
                    this.put(ByteString.copyFromUtf8((String)"qual3"), ByteString.copyFromUtf8((String)"val3"));
                }
            });
            Truth.assertThat((Map)rs.getMap(10, SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes()))).isEqualTo((Object)new HashMap<ByteString, ByteString>(){
                {
                    this.put(ByteString.copyFromUtf8((String)"qual"), ByteString.copyFromUtf8((String)"val"));
                    this.put(ByteString.copyFromUtf8((String)"qual2"), ByteString.copyFromUtf8((String)"val2"));
                    this.put(ByteString.copyFromUtf8((String)"qual3"), ByteString.copyFromUtf8((String)"val3"));
                }
            });
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void allQueryParamsTypes() {
        ResultSet rs = dataClient.executeQuery(Statement.newBuilder((String)"SELECT @stringParam AS strCol, @bytesParam as bytesCol, @int64Param AS intCol, @doubleParam AS doubleCol, @floatParam AS floatCol, @boolParam AS boolCol, @tsParam AS tsCol, @dateParam AS dateCol, @byteArrayParam AS byteArrayCol, @stringArrayParam AS stringArrayCol, @intArrayParam AS intArrayCol, @floatArrayParam AS floatArrayCol, @doubleArrayParam AS doubleArrayCol, @boolArrayParam AS boolArrayCol, @tsArrayParam AS tsArrayCol, @dateArrayParam AS dateArrayCol").setStringParam("stringParam", "stringVal").setBytesParam("bytesParam", ByteString.copyFromUtf8((String)"foo")).setLongParam("int64Param", Long.valueOf(1L)).setDoubleParam("doubleParam", Double.valueOf(1.3)).setFloatParam("floatParam", Float.valueOf(1.4f)).setBooleanParam("boolParam", Boolean.valueOf(true)).setTimestampParam("tsParam", Instant.ofEpochMilli(1000L)).setDateParam("dateParam", Date.fromYearMonthDay((int)2024, (int)6, (int)1)).setListParam("byteArrayParam", Arrays.asList(ByteString.copyFromUtf8((String)"foo"), null, ByteString.copyFromUtf8((String)"bar")), SqlType.arrayOf((SqlType)SqlType.bytes())).setListParam("stringArrayParam", Arrays.asList("foo", null, "bar"), SqlType.arrayOf((SqlType)SqlType.string())).setListParam("intArrayParam", Arrays.asList(1L, null, 2L), SqlType.arrayOf((SqlType)SqlType.int64())).setListParam("floatArrayParam", Arrays.asList(Float.valueOf(1.2f), null, Float.valueOf(1.3f)), SqlType.arrayOf((SqlType)SqlType.float32())).setListParam("doubleArrayParam", Arrays.asList(1.4, null, 1.5), SqlType.arrayOf((SqlType)SqlType.float64())).setListParam("boolArrayParam", Arrays.asList(true, null, false), SqlType.arrayOf((SqlType)SqlType.bool())).setListParam("tsArrayParam", Arrays.asList(Instant.ofEpochSecond(1000L, 1000L), null, Instant.ofEpochSecond(2000L, 2000L)), SqlType.arrayOf((SqlType)SqlType.timestamp())).setListParam("dateArrayParam", Arrays.asList(Date.fromYearMonthDay((int)2024, (int)8, (int)1), null, Date.fromYearMonthDay((int)2024, (int)8, (int)2)), SqlType.arrayOf((SqlType)SqlType.date())).build());
        Truth.assertThat((Boolean)rs.next()).isTrue();
        Truth.assertThat((String)rs.getString("strCol")).isEqualTo((Object)"stringVal");
        Truth.assertThat((String)rs.getString(0)).isEqualTo((Object)"stringVal");
        Truth.assertThat((Iterable)rs.getBytes("bytesCol")).isEqualTo((Object)ByteString.copyFromUtf8((String)"foo"));
        Truth.assertThat((Iterable)rs.getBytes(1)).isEqualTo((Object)ByteString.copyFromUtf8((String)"foo"));
        Truth.assertThat((Long)rs.getLong("intCol")).isEqualTo((Object)1L);
        Truth.assertThat((Long)rs.getLong(2)).isEqualTo((Object)1L);
        Truth.assertThat((Double)rs.getDouble("doubleCol")).isEqualTo((Object)1.3);
        Truth.assertThat((Double)rs.getDouble(3)).isEqualTo((Object)1.3);
        Truth.assertThat((Float)Float.valueOf(rs.getFloat("floatCol"))).isEqualTo((Object)Float.valueOf(1.4f));
        Truth.assertThat((Float)Float.valueOf(rs.getFloat(4))).isEqualTo((Object)Float.valueOf(1.4f));
        Truth.assertThat((Boolean)rs.getBoolean("boolCol")).isTrue();
        Truth.assertThat((Boolean)rs.getBoolean(5)).isTrue();
        Truth.assertThat((Comparable)rs.getTimestamp("tsCol")).isEqualTo((Object)Instant.ofEpochMilli(1000L));
        Truth.assertThat((Comparable)rs.getTimestamp(6)).isEqualTo((Object)Instant.ofEpochMilli(1000L));
        Truth.assertThat((Comparable)rs.getDate("dateCol")).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)1));
        Truth.assertThat((Comparable)rs.getDate(7)).isEqualTo((Object)Date.fromYearMonthDay((int)2024, (int)6, (int)1));
        Truth.assertThat((Iterable)rs.getList("byteArrayCol", SqlType.arrayOf((SqlType)SqlType.bytes()))).isEqualTo(Arrays.asList(ByteString.copyFromUtf8((String)"foo"), null, ByteString.copyFromUtf8((String)"bar")));
        Truth.assertThat((Iterable)rs.getList(8, SqlType.arrayOf((SqlType)SqlType.bytes()))).isEqualTo(Arrays.asList(ByteString.copyFromUtf8((String)"foo"), null, ByteString.copyFromUtf8((String)"bar")));
        Truth.assertThat((Iterable)rs.getList("stringArrayCol", SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(Arrays.asList("foo", null, "bar"));
        Truth.assertThat((Iterable)rs.getList(9, SqlType.arrayOf((SqlType)SqlType.string()))).isEqualTo(Arrays.asList("foo", null, "bar"));
        Truth.assertThat((Iterable)rs.getList("intArrayCol", SqlType.arrayOf((SqlType)SqlType.int64()))).isEqualTo(Arrays.asList(1L, null, 2L));
        Truth.assertThat((Iterable)rs.getList(10, SqlType.arrayOf((SqlType)SqlType.int64()))).isEqualTo(Arrays.asList(1L, null, 2L));
        Truth.assertThat((Iterable)rs.getList("floatArrayCol", SqlType.arrayOf((SqlType)SqlType.float32()))).isEqualTo(Arrays.asList(Float.valueOf(1.2f), null, Float.valueOf(1.3f)));
        Truth.assertThat((Iterable)rs.getList(11, SqlType.arrayOf((SqlType)SqlType.float32()))).isEqualTo(Arrays.asList(Float.valueOf(1.2f), null, Float.valueOf(1.3f)));
        Truth.assertThat((Iterable)rs.getList("doubleArrayCol", SqlType.arrayOf((SqlType)SqlType.float64()))).isEqualTo(Arrays.asList(1.4, null, 1.5));
        Truth.assertThat((Iterable)rs.getList(12, SqlType.arrayOf((SqlType)SqlType.float64()))).isEqualTo(Arrays.asList(1.4, null, 1.5));
        Truth.assertThat((Iterable)rs.getList("boolArrayCol", SqlType.arrayOf((SqlType)SqlType.bool()))).isEqualTo(Arrays.asList(true, null, false));
        Truth.assertThat((Iterable)rs.getList(13, SqlType.arrayOf((SqlType)SqlType.bool()))).isEqualTo(Arrays.asList(true, null, false));
        Truth.assertThat((Iterable)rs.getList("tsArrayCol", SqlType.arrayOf((SqlType)SqlType.timestamp()))).isEqualTo(Arrays.asList(Instant.ofEpochSecond(1000L, 1000L), null, Instant.ofEpochSecond(2000L, 2000L)));
        Truth.assertThat((Iterable)rs.getList(14, SqlType.arrayOf((SqlType)SqlType.timestamp()))).isEqualTo(Arrays.asList(Instant.ofEpochSecond(1000L, 1000L), null, Instant.ofEpochSecond(2000L, 2000L)));
        Truth.assertThat((Iterable)rs.getList("dateArrayCol", SqlType.arrayOf((SqlType)SqlType.date()))).isEqualTo(Arrays.asList(Date.fromYearMonthDay((int)2024, (int)8, (int)1), null, Date.fromYearMonthDay((int)2024, (int)8, (int)2)));
        Truth.assertThat((Iterable)rs.getList(15, SqlType.arrayOf((SqlType)SqlType.date()))).isEqualTo(Arrays.asList(Date.fromYearMonthDay((int)2024, (int)8, (int)1), null, Date.fromYearMonthDay((int)2024, (int)8, (int)2)));
    }

    @Test
    public void testNullColumns() {
        try (ResultSet rs = dataClient.executeQuery(Statement.of((String)("SELECT cf['qual'] AS neverNull, cf['qual3'] AS maybeNull FROM " + tableId + " WHERE _key LIKE '" + uniquePrefix + "%'")));){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)rs.getBytes("neverNull")).isEqualTo((Object)ByteString.copyFromUtf8((String)"val"));
            Truth.assertThat((Boolean)rs.isNull("maybeNull")).isFalse();
            Truth.assertThat((Boolean)rs.isNull(1)).isFalse();
            Truth.assertThat((Iterable)rs.getBytes("maybeNull")).isEqualTo((Object)ByteString.copyFromUtf8((String)"val3"));
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)rs.getBytes("neverNull")).isEqualTo((Object)ByteString.copyFromUtf8((String)"bval"));
            Truth.assertThat((Boolean)rs.isNull("maybeNull")).isTrue();
            Truth.assertThat((Boolean)rs.isNull(1)).isTrue();
            Assert.assertThrows(NullPointerException.class, () -> rs.getBytes("maybeNull"));
            Assert.assertThrows(NullPointerException.class, () -> rs.getBytes(1));
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }
}

