/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LargeRowIT {
    private static final Logger logger = Logger.getLogger(LargeRowIT.class.getName());
    @ClassRule
    public static final TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void testWriteRead() throws Exception {
        String rowKey = UUID.randomUUID().toString();
        String familyId = testEnvRule.env().getFamilyId();
        byte[] largeValueBytes = new byte[0x6400000];
        Random random = new Random();
        random.nextBytes(largeValueBytes);
        ByteString largeValue = ByteString.copyFrom((byte[])largeValueBytes);
        logger.info("Sending large row, this will take awhile");
        for (int i = 0; i < 2; ++i) {
            testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)rowKey).setCell(familyId, ByteString.copyFromUtf8((String)("q" + i)), largeValue)).get(10L, TimeUnit.MINUTES);
        }
        logger.info("Reading large row, this will take awhile");
        Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(2);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(0)).getValue()).isEqualTo((Object)largeValue);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(1)).getValue()).isEqualTo((Object)largeValue);
    }
}

