/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutateRowIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws Exception {
        String rowKey = UUID.randomUUID().toString();
        String familyId = testEnvRule.env().getFamilyId();
        testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)rowKey).setCell(familyId, "q", "myVal").setCell(familyId, "q2", "myVal2").setCell(familyId, "q3", "myVal3").setCell(familyId, "q4", 305419896L)).get(1L, TimeUnit.MINUTES);
        testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)rowKey).deleteCells(familyId, "q2")).get(1L, TimeUnit.MINUTES);
        Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(0)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"myVal"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(1)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"myVal3"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 18, 52, 86, 120}));
    }

    @Test
    public void testOnAuthorizedView() throws Exception {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        String rowKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        String familyId = testEnvRule.env().getFamilyId();
        testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()), (String)rowKey).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "myVal").setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "2", "myVal2").setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "3", "myVal3").setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "4", 305419896L)).get(1L, TimeUnit.MINUTES);
        testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()), (String)rowKey).deleteCells(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "2")).get(1L, TimeUnit.MINUTES);
        Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(0)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"myVal"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(1)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"myVal3"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 18, 52, 86, 120}));
        try {
            String rowKeyOutsideAuthorizedView = UUID.randomUUID() + "-outside-authorized-view";
            testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((TargetId)AuthorizedViewId.of((String)testEnvRule.env().getTableId(), (String)testAuthorizedView.getId()), (String)rowKeyOutsideAuthorizedView).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "myVal")).get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not be able to mutate row outside authorized view");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(PermissionDeniedException.class);
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }
}

