/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadIT {
    private String prefix;
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Before
    public void setUp() {
        this.prefix = UUID.randomUUID().toString();
    }

    @Test
    public void isRowExists() throws Exception {
        String rowKey = this.prefix + "-test-row-key";
        String tableId = testEnvRule.env().getTableId();
        testEnvRule.env().getDataClient().mutateRow(RowMutation.create((String)tableId, (String)rowKey).setCell(testEnvRule.env().getFamilyId(), "qualifier", "value"));
        Truth.assertThat((Boolean)testEnvRule.env().getDataClient().exists(tableId, rowKey)).isTrue();
        String nonExistingKey = this.prefix + "non-existing-key";
        Truth.assertThat((Boolean)testEnvRule.env().getDataClient().exists(tableId, nonExistingKey)).isFalse();
        Truth.assertThat((Boolean)((Boolean)testEnvRule.env().getDataClient().existsAsync(tableId, rowKey).get())).isTrue();
    }

    @Test
    public void isRowExistsOnAuthorizedView() throws Exception {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataClient dataClient = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String rowKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + this.prefix + "-isRowExistsOnAuthorizedView";
        String rowKeyOutsideAuthorizedView = this.prefix + "-isRowExistsOnAuthorizedView";
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        dataClient.mutateRow(RowMutation.create((String)tableId, (String)rowKey).setCell(testEnvRule.env().getFamilyId(), AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "value"));
        dataClient.mutateRow(RowMutation.create((String)tableId, (String)rowKeyOutsideAuthorizedView).setCell(testEnvRule.env().getFamilyId(), AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "value"));
        Truth.assertThat((Boolean)dataClient.exists((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), rowKey)).isTrue();
        Truth.assertThat((Boolean)dataClient.exists((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), rowKeyOutsideAuthorizedView)).isFalse();
        Truth.assertThat((Boolean)((Boolean)dataClient.existsAsync((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), rowKey).get())).isTrue();
        Truth.assertThat((Boolean)((Boolean)dataClient.existsAsync((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), rowKeyOutsideAuthorizedView).get())).isFalse();
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(tableId, testAuthorizedView.getId());
    }

    @Test
    public void readEmpty() throws Throwable {
        String uniqueKey = this.prefix + "-readEmpty";
        Query query = Query.create((String)testEnvRule.env().getTableId()).rowKey(uniqueKey);
        ArrayList rows = Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(query));
        Truth.assertThat((Iterable)rows).isEmpty();
        AccumulatingObserver observer = new AccumulatingObserver();
        testEnvRule.env().getDataClient().readRowsAsync(query, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).isEmpty();
    }

    @Test
    public void readEmptyOnAuthorizedView() throws Throwable {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        String tableId = testEnvRule.env().getTableId();
        BigtableDataClient dataClient = testEnvRule.env().getDataClient();
        String uniqueKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + this.prefix + "-readEmptyOnAuthorizedView";
        String uniqueKeyOutsideAuthorizedView = this.prefix + "-readEmptyOnAuthorizedView";
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        Query query = Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).rowKey(uniqueKey);
        Query queryOutsideAuthorizedView = Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).rowKey(uniqueKeyOutsideAuthorizedView);
        ArrayList rows = Lists.newArrayList((Iterable)dataClient.readRows(query));
        Truth.assertThat((Iterable)rows).isEmpty();
        dataClient.mutateRow(RowMutation.create((String)tableId, (String)uniqueKeyOutsideAuthorizedView).setCell(testEnvRule.env().getFamilyId(), AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "value"));
        rows = Lists.newArrayList((Iterable)dataClient.readRows(queryOutsideAuthorizedView));
        Truth.assertThat((Iterable)rows).isEmpty();
        AccumulatingObserver observer = new AccumulatingObserver();
        testEnvRule.env().getDataClient().readRowsAsync(query, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).isEmpty();
        observer = new AccumulatingObserver();
        testEnvRule.env().getDataClient().readRowsAsync(queryOutsideAuthorizedView, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).isEmpty();
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(tableId, testAuthorizedView.getId());
    }

    @Test
    public void read() throws Throwable {
        int numRows = 5;
        ArrayList expectedRows = Lists.newArrayList();
        String uniqueKey = this.prefix + "-read";
        long timestampMicros = System.currentTimeMillis() * 1000L;
        for (int i = 0; i < numRows; ++i) {
            testEnvRule.env().getDataClient().mutateRowCallable().call((Object)RowMutation.create((String)testEnvRule.env().getTableId(), (String)(uniqueKey + "-" + i)).setCell(testEnvRule.env().getFamilyId(), "q", timestampMicros, "my-value"));
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(uniqueKey + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)"q"), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"my-value")))));
        }
        String tableId = testEnvRule.env().getTableId();
        Query query = Query.create((String)tableId).range(uniqueKey + "-0", uniqueKey + "-" + numRows);
        ArrayList actualResults = Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(query));
        Truth.assertThat((Iterable)actualResults).containsExactlyElementsIn((Iterable)expectedRows);
        AccumulatingObserver observer = new AccumulatingObserver();
        testEnvRule.env().getDataClient().readRowsAsync(query, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).containsExactlyElementsIn((Iterable)expectedRows);
        Row actualRow = testEnvRule.env().getDataClient().readRow(tableId, ((Row)expectedRows.get(0)).getKey());
        Truth.assertThat((Object)actualRow).isEqualTo(expectedRows.get(0));
        ApiFuture actualRowFuture = testEnvRule.env().getDataClient().readRowAsync(tableId, ((Row)expectedRows.get(0)).getKey());
        Truth.assertThat((Object)actualRowFuture.get()).isEqualTo(expectedRows.get(0));
    }

    @Test
    public void readOnAuthorizedView() throws Throwable {
        int i;
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        int numRows = 5;
        ArrayList expectedRows = Lists.newArrayList();
        String uniqueKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + this.prefix + "-readOnAuthorizedView";
        String uniqueKeyOutsideAuthorizedView = this.prefix + "-readOnAuthorizedView";
        String tableId = testEnvRule.env().getTableId();
        BigtableDataClient dataClient = testEnvRule.env().getDataClient();
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        long timestampMicros = System.currentTimeMillis() * 1000L;
        for (i = 0; i < numRows; ++i) {
            dataClient.mutateRowCallable().call((Object)RowMutation.create((String)tableId, (String)(uniqueKey + "-" + i)).setCell(testEnvRule.env().getFamilyId(), AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, timestampMicros, "my-value"));
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(uniqueKey + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"my-value")))));
        }
        for (i = 0; i < numRows; ++i) {
            dataClient.mutateRowCallable().call((Object)RowMutation.create((String)tableId, (String)(uniqueKeyOutsideAuthorizedView + "-" + i)).setCell(testEnvRule.env().getFamilyId(), AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, timestampMicros, "my-value"));
        }
        Query query = Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).range(uniqueKey + "-0", uniqueKey + "-" + numRows);
        Query queryOutsideAuthorizedView = Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).range(uniqueKeyOutsideAuthorizedView + "-0", uniqueKeyOutsideAuthorizedView + "-" + numRows);
        ArrayList actualResults = Lists.newArrayList((Iterable)dataClient.readRows(query));
        Truth.assertThat((Iterable)actualResults).containsExactlyElementsIn((Iterable)expectedRows);
        ArrayList results = Lists.newArrayList((Iterable)dataClient.readRows(queryOutsideAuthorizedView));
        Truth.assertThat((Iterable)results).isEmpty();
        AccumulatingObserver observer = new AccumulatingObserver();
        dataClient.readRowsAsync(query, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).containsExactlyElementsIn((Iterable)expectedRows);
        observer = new AccumulatingObserver();
        dataClient.readRowsAsync(queryOutsideAuthorizedView, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).isEmpty();
        Row actualRow = dataClient.readRow((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), ((Row)expectedRows.get(0)).getKey());
        Truth.assertThat((Object)actualRow).isEqualTo(expectedRows.get(0));
        Truth.assertThat((Object)dataClient.readRow((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), uniqueKeyOutsideAuthorizedView + "-0")).isNull();
        ApiFuture actualRowFuture = dataClient.readRowAsync((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), ((Row)expectedRows.get(0)).getKey());
        Truth.assertThat((Object)actualRowFuture.get()).isEqualTo(expectedRows.get(0));
        Truth.assertThat((Object)dataClient.readRowAsync((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), uniqueKeyOutsideAuthorizedView + "-0").get()).isNull();
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(tableId, testAuthorizedView.getId());
    }

    @Test
    public void rangeQueries() {
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String uniqueKey = this.prefix + "-range-queries";
        String keyA = uniqueKey + "-a";
        String keyZ = uniqueKey + "-z";
        long timestampMicros = System.currentTimeMillis() * 1000L;
        client.bulkMutateRows(BulkMutation.create((String)tableId).add(RowMutationEntry.create((String)keyA).setCell(familyId, "", timestampMicros, "A")).add(RowMutationEntry.create((String)keyZ).setCell(familyId, "", timestampMicros, "Z")));
        Row expectedRowA = Row.create((ByteString)ByteString.copyFromUtf8((String)keyA), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"A"))));
        Row expectedRowZ = Row.create((ByteString)ByteString.copyFromUtf8((String)keyZ), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"Z"))));
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed(keyA)).endOpen(keyZ))))).containsExactly(new Object[]{expectedRowA});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed(keyA)).endClosed(keyZ))))).containsExactly(new Object[]{expectedRowA, expectedRowZ});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen(keyA)).endClosed(keyZ))))).containsExactly(new Object[]{expectedRowZ});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen(keyA)).endOpen(keyZ))))).isEmpty();
    }

    @Test
    public void rangeQueriesOnAuthorizedView() {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String uniqueKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + this.prefix + "-rangeQueriesOnAuthorizedView";
        String keyA = uniqueKey + "-a";
        String keyZ = uniqueKey + "-z";
        String keyOutsideAuthorizedView = this.prefix;
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        long timestampMicros = System.currentTimeMillis() * 1000L;
        client.bulkMutateRows(BulkMutation.create((String)tableId).add(RowMutationEntry.create((String)keyA).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, timestampMicros, "A")).add(RowMutationEntry.create((String)keyZ).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, timestampMicros, "Z")).add(RowMutationEntry.create((String)keyOutsideAuthorizedView).setCell(familyId, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, timestampMicros, "outsideAuthorizedView")));
        Row expectedRowA = Row.create((ByteString)ByteString.copyFromUtf8((String)keyA), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"A"))));
        Row expectedRowZ = Row.create((ByteString)ByteString.copyFromUtf8((String)keyZ), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"Z"))));
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed(keyA)).endOpen(keyZ))))).containsExactly(new Object[]{expectedRowA});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed(keyA)).endClosed(keyZ))))).containsExactly(new Object[]{expectedRowA, expectedRowZ});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen(keyA)).endClosed(keyZ))))).containsExactly(new Object[]{expectedRowZ});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId())).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen(keyA)).endOpen(keyZ))))).isEmpty();
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(tableId, testAuthorizedView.getId());
    }

    @Test
    public void reversed() {
        TruthJUnit.assume().withMessage("reverse scans are not supported in the emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String uniqueKey = this.prefix + "-rev-queries";
        String keyA = uniqueKey + "-a";
        String keyB = uniqueKey + "-b";
        String keyC = uniqueKey + "-c";
        long timestampMicros = System.currentTimeMillis() * 1000L;
        client.bulkMutateRows(BulkMutation.create((String)tableId).add(RowMutationEntry.create((String)keyA).setCell(familyId, "", timestampMicros, "A")).add(RowMutationEntry.create((String)keyB).setCell(familyId, "", timestampMicros, "B")).add(RowMutationEntry.create((String)keyC).setCell(familyId, "", timestampMicros, "C")));
        Row expectedRowA = Row.create((ByteString)ByteString.copyFromUtf8((String)keyA), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"A"))));
        Row expectedRowB = Row.create((ByteString)ByteString.copyFromUtf8((String)keyB), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"B"))));
        Row expectedRowC = Row.create((ByteString)ByteString.copyFromUtf8((String)keyC), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"C"))));
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).reversed(true).range(Range.ByteStringRange.prefix((String)uniqueKey))))).containsExactly(new Object[]{expectedRowC, expectedRowB, expectedRowA}).inOrder();
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).reversed(true).range(Range.ByteStringRange.prefix((String)uniqueKey)).limit(2L)))).containsExactly(new Object[]{expectedRowC, expectedRowB}).inOrder();
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).reversed(true).range((Range.ByteStringRange)Range.ByteStringRange.unbounded().endOpen(keyC)).limit(2L)))).containsExactly(new Object[]{expectedRowB, expectedRowA}).inOrder();
    }

    @Test
    @Ignore(value="Test taking too long to run, ignore for now")
    public void reversedWithForcedResumption() throws IOException, InterruptedException {
        ArrayList<Row> expectedResults;
        Random random;
        TruthJUnit.assume().withMessage("reverse scans are not supported in the emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String uniqueKey = this.prefix + "-rev-queries2";
        try (Batcher batcher = client.newBulkMutationBatcher(tableId);){
            byte[] valueBytes = new byte[1024];
            random = new Random();
            expectedResults = new ArrayList<Row>();
            for (int i = 0; i < 2048; ++i) {
                ByteString key = ByteString.copyFromUtf8((String)String.format("%s-%05d", uniqueKey, i));
                ByteString qualifier = ByteString.copyFromUtf8((String)"q");
                long timestamp = System.currentTimeMillis() * 1000L;
                random.nextBytes(valueBytes);
                ByteString value = ByteString.copyFrom((byte[])valueBytes);
                batcher.add((Object)RowMutationEntry.create((ByteString)key).setCell(familyId, qualifier, timestamp, value));
                expectedResults.add(Row.create((ByteString)key, (List)ImmutableList.of((Object)RowCell.create((String)familyId, (ByteString)qualifier, (long)timestamp, (List)ImmutableList.of(), (ByteString)value))));
            }
        }
        Collections.reverse(expectedResults);
        BigtableDataSettings.Builder settingsBuilder = testEnvRule.env().getDataClientSettings().toBuilder();
        settingsBuilder.stubSettings().readRowsSettings().retrySettings().setMaxAttempts(100);
        InstantiatingGrpcChannelProvider.Builder transport = ((InstantiatingGrpcChannelProvider)settingsBuilder.stubSettings().getTransportChannelProvider()).toBuilder();
        ApiFunction oldConfigurator = transport.getChannelConfigurator();
        transport.setChannelConfigurator(c -> {
            if (oldConfigurator != null) {
                c = (ManagedChannelBuilder)oldConfigurator.apply(c);
            }
            return c.intercept(new ClientInterceptor[]{new ClientInterceptor(){

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    if (method.getBareMethodName().equals("ReadRows")) {
                        callOptions = callOptions.withDeadlineAfter((long)random.nextInt(200), TimeUnit.MILLISECONDS);
                    }
                    return next.newCall(method, callOptions);
                }
            }});
        });
        settingsBuilder.stubSettings().setTransportChannelProvider((TransportChannelProvider)transport.build());
        try (BigtableDataClient patchedClient = BigtableDataClient.create((BigtableDataSettings)settingsBuilder.build());){
            for (int i = 0; i < 10; ++i) {
                ArrayList<Row> actualResults = new ArrayList<Row>();
                for (Row row : patchedClient.readRows(Query.create((String)tableId).prefix(uniqueKey).reversed(true))) {
                    actualResults.add(row);
                    Thread.sleep(1L);
                }
                Truth.assertThat(actualResults).containsExactlyElementsIn(expectedResults).inOrder();
            }
        }
    }

    @Test
    public void readSingleNonexistentAsyncCallback() throws Exception {
        ApiFuture future = testEnvRule.env().getDataClient().readRowAsync(testEnvRule.env().getTableId(), "somenonexistentkey");
        final AtomicReference unexpectedError = new AtomicReference();
        final AtomicBoolean found = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new ApiFutureCallback<Row>(){

            public void onFailure(Throwable t) {
                unexpectedError.set(t);
                latch.countDown();
            }

            public void onSuccess(Row result) {
                found.set(true);
                latch.countDown();
            }
        }, (Executor)MoreExecutors.directExecutor());
        latch.await(1L, TimeUnit.MINUTES);
        if (unexpectedError.get() != null) {
            throw new RuntimeException("Unexpected async error", (Throwable)unexpectedError.get());
        }
        Truth.assertThat((Boolean)found.get()).isTrue();
    }

    static class AccumulatingObserver
    implements ResponseObserver<Row> {
        final List<Row> responses = Lists.newArrayList();
        final SettableApiFuture<Void> completionFuture = SettableApiFuture.create();

        AccumulatingObserver() {
        }

        void awaitCompletion() throws Throwable {
            try {
                this.completionFuture.get(10L, TimeUnit.MINUTES);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }

        public void onStart(StreamController controller) {
        }

        public void onResponse(Row row) {
            this.responses.add(row);
        }

        public void onError(Throwable t) {
            this.completionFuture.setException(t);
        }

        public void onComplete() {
            this.completionFuture.set(null);
        }
    }
}

