/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadModifyWriteIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws InterruptedException, ExecutionException, TimeoutException {
        String tableId = testEnvRule.env().getTableId();
        String family = testEnvRule.env().getFamilyId();
        String rowKey = UUID.randomUUID().toString();
        Row row = (Row)testEnvRule.env().getDataClient().readModifyWriteRowAsync(ReadModifyWriteRow.create((String)tableId, (String)rowKey).append(family, "q1", "a").increment(family, "q2", 3L).increment(family, "q3", 305419897L)).get(1L, TimeUnit.MINUTES);
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(0)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(1)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 3}));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 18, 52, 86, 121}));
    }

    @Test
    public void testOnAuthorizedView() throws InterruptedException, ExecutionException, TimeoutException {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        String tableId = testEnvRule.env().getTableId();
        String family = testEnvRule.env().getFamilyId();
        String rowKey = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        Row row = (Row)testEnvRule.env().getDataClient().readModifyWriteRowAsync(ReadModifyWriteRow.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKey).append(family, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "1", "a").increment(family, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "2", 3L).increment(family, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER + "3", 305419897L)).get(1L, TimeUnit.MINUTES);
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(0)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(1)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 3}));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 18, 52, 86, 121}));
        String rowKeyOutsideAuthorizedView = UUID.randomUUID() + "-outside-authorized-view";
        try {
            testEnvRule.env().getDataClient().readModifyWriteRowAsync(ReadModifyWriteRow.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKeyOutsideAuthorizedView).append(family, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, "a")).get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not be able to modify a row outside authorized view");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(PermissionDeniedException.class);
        }
        try {
            testEnvRule.env().getDataClient().readModifyWriteRowAsync(ReadModifyWriteRow.create((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()), (String)rowKey).append(family, "outside-authorized-view", "a")).get(1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not be able to perform mutations with cells outside the authorized view");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(PermissionDeniedException.class);
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }
}

