/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.misc_utilities.AuthorizedViewTestHelper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMutationEntryBatcherIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void testNewBatcher() throws Exception {
        int i;
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String family = testEnvRule.env().getFamilyId();
        String rowPrefix = UUID.randomUUID().toString();
        try (Batcher batcher = client.newBulkMutationBatcher(tableId);){
            for (i = 0; i < 10; ++i) {
                batcher.add((Object)RowMutationEntry.create((String)(rowPrefix + "-" + i)).setCell(family, "qualifier", 10000L, "value-" + i));
            }
        }
        ArrayList<Row> expectedRows = new ArrayList<Row>();
        for (i = 0; i < 10; ++i) {
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(rowPrefix + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)family, (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)10000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)("value-" + i))))));
        }
        ServerStream actualRows = client.readRows(Query.create((String)tableId).prefix(rowPrefix));
        Truth.assertThat((Iterable)actualRows).containsExactlyElementsIn(expectedRows);
    }

    @Test
    public void testNewBatcherOnAuthorizedView() throws Exception {
        int i;
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = AuthorizedViewTestHelper.createTestAuthorizedView(testEnvRule);
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String family = testEnvRule.env().getFamilyId();
        String rowPrefix = AuthorizedViewTestHelper.AUTHORIZED_VIEW_ROW_PREFIX + UUID.randomUUID();
        try (Batcher batcher = client.newBulkMutationBatcher((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()));){
            for (i = 0; i < 10; ++i) {
                batcher.add((Object)RowMutationEntry.create((String)(rowPrefix + "-" + i)).setCell(family, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, 10000L, "value-" + i));
            }
        }
        ArrayList<Row> expectedRows = new ArrayList<Row>();
        for (i = 0; i < 10; ++i) {
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(rowPrefix + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)family, (ByteString)ByteString.copyFromUtf8((String)AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER), (long)10000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)("value-" + i))))));
        }
        ServerStream actualRows = client.readRows(Query.create((String)tableId).prefix(rowPrefix));
        Truth.assertThat((Iterable)actualRows).containsExactlyElementsIn(expectedRows);
        String rowKeyOutsideAuthorizedView = UUID.randomUUID() + "-outside-authorized-view";
        try {
            try (Batcher batcher = client.newBulkMutationBatcher((TargetId)AuthorizedViewId.of((String)tableId, (String)testAuthorizedView.getId()));){
                batcher.add((Object)RowMutationEntry.create((String)rowKeyOutsideAuthorizedView).setCell(family, AuthorizedViewTestHelper.AUTHORIZED_VIEW_COLUMN_QUALIFIER, 10000L, "value"));
            }
            Assert.fail((String)"Should not be able to apply bulk mutation on rows outside authorized view");
        }
        catch (Exception exception) {
            // empty catch block
        }
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testEnvRule.env().getTableId(), testAuthorizedView.getId());
    }
}

