/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.CreateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SampleRowsIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws InterruptedException, ExecutionException, TimeoutException {
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String rowPrefix = UUID.randomUUID().toString();
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            ApiFuture future = client.mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)(rowPrefix + "-" + i)).setCell(testEnvRule.env().getFamilyId(), "", "value"));
            futures.add(future);
        }
        ApiFutures.allAsList((Iterable)futures).get(1L, TimeUnit.MINUTES);
        ApiFuture future = client.sampleRowKeysAsync(testEnvRule.env().getTableId());
        List results = (List)future.get(1L, TimeUnit.MINUTES);
        Truth.assertThat((Iterable)results).isNotEmpty();
        Truth.assertThat((Long)((KeyOffset)results.get(results.size() - 1)).getOffsetBytes()).isGreaterThan((Comparable)Long.valueOf(0L));
    }

    @Test
    public void testOnAuthorizedView() throws InterruptedException, ExecutionException, TimeoutException {
        TruthJUnit.assume().withMessage("AuthorizedView is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        AuthorizedView testAuthorizedView = SampleRowsIT.createPreSplitTableAndAuthorizedView();
        BigtableDataClient client = testEnvRule.env().getDataClient();
        ApiFuture future = client.sampleRowKeysAsync((TargetId)AuthorizedViewId.of((String)testAuthorizedView.getTableId(), (String)testAuthorizedView.getId()));
        List results = (List)future.get(1L, TimeUnit.MINUTES);
        ArrayList<ByteString> resultKeys = new ArrayList<ByteString>();
        for (KeyOffset keyOffset : results) {
            resultKeys.add(keyOffset.getKey());
        }
        Truth.assertThat(resultKeys).containsExactly(new Object[]{ByteString.copyFromUtf8((String)"food"), ByteString.copyFromUtf8((String)"fool"), ByteString.copyFromUtf8((String)"fop")});
        testEnvRule.env().getTableAdminClient().deleteAuthorizedView(testAuthorizedView.getTableId(), testAuthorizedView.getId());
    }

    private static AuthorizedView createPreSplitTableAndAuthorizedView() {
        String tableId = PrefixGenerator.newPrefix("SampleRowsIT#AuthorizedView");
        String authorizedViewId = UUID.randomUUID().toString();
        testEnvRule.env().getTableAdminClient().createTable(CreateTableRequest.of((String)tableId).addSplit(ByteString.copyFromUtf8((String)"apple")).addSplit(ByteString.copyFromUtf8((String)"food")).addSplit(ByteString.copyFromUtf8((String)"fool")).addSplit(ByteString.copyFromUtf8((String)"good")));
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.of((String)tableId, (String)authorizedViewId).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix("foo")).setDeletionProtection(false);
        return testEnvRule.env().getTableAdminClient().createAuthorizedView(request);
    }
}

