/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.it.MetricsITUtils;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.CustomOpenTelemetryMetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class UnaryMetricsMetadataIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    private BigtableDataClient client;
    private InMemoryMetricReader metricReader;

    @Before
    public void setup() throws IOException {
        TruthJUnit.assume().withMessage("UnaryMetricsMetadataIT is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataSettings.Builder settings = testEnvRule.env().getDataClientSettings().toBuilder();
        this.metricReader = InMemoryMetricReader.create();
        SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)this.metricReader);
        CustomOpenTelemetryMetricsProvider.setupSdkMeterProvider((SdkMeterProviderBuilder)meterProvider);
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        settings.setMetricsProvider((MetricsProvider)CustomOpenTelemetryMetricsProvider.create((OpenTelemetry)openTelemetry));
        this.client = BigtableDataClient.create((BigtableDataSettings)settings.build());
    }

    @After
    public void tearDown() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void testSuccess() throws Exception {
        String rowKey = UUID.randomUUID().toString();
        String familyId = testEnvRule.env().getFamilyId();
        ApiFuture future = this.client.mutateRowCallable().futureCall((Object)RowMutation.create((String)testEnvRule.env().getTableId(), (String)rowKey).setCell(familyId, "q", "myVal"));
        future.get(1L, TimeUnit.MINUTES);
        ApiFuture clustersFuture = testEnvRule.env().getInstanceAdminClient().listClustersAsync(testEnvRule.env().getInstanceId());
        List clusters = (List)clustersFuture.get(1L, TimeUnit.MINUTES);
        Collection allMetricData = this.metricReader.collectAllMetrics();
        List metrics = allMetricData.stream().filter(m -> m.getName().contains("operation_latencies")).collect(Collectors.toList());
        Truth.assertThat((Iterable)allMetricData).comparingElementsUsing(MetricsITUtils.METRIC_DATA_NAME_CONTAINS).contains((Object)"operation_latencies");
        Truth.assertThat(metrics).hasSize(1);
        MetricData metricData = (MetricData)metrics.get(0);
        ArrayList pointData = new ArrayList(metricData.getData().getPoints());
        List clusterAttributes = pointData.stream().map(pd -> (String)pd.getAttributes().get(BuiltinMetricsConstants.CLUSTER_ID_KEY)).collect(Collectors.toList());
        List zoneAttributes = pointData.stream().map(pd -> (String)pd.getAttributes().get(BuiltinMetricsConstants.ZONE_ID_KEY)).collect(Collectors.toList());
        Truth.assertThat(pointData).comparingElementsUsing(MetricsITUtils.POINT_DATA_CLUSTER_ID_CONTAINS).contains((Object)((Cluster)clusters.get(0)).getId());
        Truth.assertThat(pointData).comparingElementsUsing(MetricsITUtils.POINT_DATA_ZONE_ID_CONTAINS).contains((Object)((Cluster)clusters.get(0)).getZone());
        Truth.assertThat(clusterAttributes).contains((Object)((Cluster)clusters.get(0)).getId());
        Truth.assertThat(zoneAttributes).contains((Object)((Cluster)clusters.get(0)).getZone());
    }

    @Test
    public void testFailure() throws Exception {
        block3: {
            String rowKey = UUID.randomUUID().toString();
            String familyId = testEnvRule.env().getFamilyId();
            ApiFuture future = this.client.mutateRowCallable().futureCall((Object)RowMutation.create((String)"non-exist-table", (String)rowKey).setCell(familyId, "q", "myVal"));
            try {
                future.get(1L, TimeUnit.MINUTES);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof NotFoundException) break block3;
                throw e;
            }
        }
        Collection allMetricData = this.metricReader.collectAllMetrics();
        MetricData metricData = null;
        for (MetricData md : allMetricData) {
            if (!md.getName().equals("bigtable.googleapis.com/internal/client/attempt_latencies")) continue;
            metricData = md;
            break;
        }
        Truth.assertThat((Iterable)allMetricData).comparingElementsUsing(MetricsITUtils.METRIC_DATA_NAME_CONTAINS).contains((Object)"attempt_latencies");
        Truth.assertThat(metricData).isNotNull();
        ArrayList pointData = new ArrayList(metricData.getData().getPoints());
        Truth.assertThat(pointData).comparingElementsUsing(MetricsITUtils.POINT_DATA_CLUSTER_ID_CONTAINS).contains((Object)"<unspecified>");
        Truth.assertThat(pointData).comparingElementsUsing(MetricsITUtils.POINT_DATA_ZONE_ID_CONTAINS).contains((Object)"global");
        List clusterAttributes = pointData.stream().map(pd -> (String)pd.getAttributes().get(BuiltinMetricsConstants.CLUSTER_ID_KEY)).collect(Collectors.toList());
        List zoneAttributes = pointData.stream().map(pd -> (String)pd.getAttributes().get(BuiltinMetricsConstants.ZONE_ID_KEY)).collect(Collectors.toList());
        Truth.assertThat(clusterAttributes).contains((Object)"<unspecified>");
        Truth.assertThat(zoneAttributes).contains((Object)"global");
    }
}

