/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AuthorizedViewIdTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String TABLE_ID = "my-table";
    private static final String AUTHORIZED_VIEW_ID = "my-authorized-view";

    @Test
    public void testToResourceName() {
        AuthorizedViewId authorizedViewId = AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        Truth.assertThat((String)authorizedViewId.toResourceName(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)"projects/my-project/instances/my-instance/tables/my-table/authorizedViews/my-authorized-view");
    }

    @Test
    public void testEquality() {
        AuthorizedViewId authorizedViewId = AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        Truth.assertThat((Object)authorizedViewId).isEqualTo((Object)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        Truth.assertThat((Object)authorizedViewId).isNotEqualTo((Object)AuthorizedViewId.of((String)TABLE_ID, (String)"another-authorized-view"));
        Truth.assertThat((Object)authorizedViewId).isNotEqualTo((Object)TableId.of((String)TABLE_ID));
    }

    @Test
    public void testHashCode() {
        AuthorizedViewId authorizedViewId = AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        Truth.assertThat((Integer)authorizedViewId.hashCode()).isEqualTo((Object)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID).hashCode());
        Truth.assertThat((Integer)authorizedViewId.hashCode()).isNotEqualTo((Object)AuthorizedViewId.of((String)TABLE_ID, (String)"another-authorized-view").hashCode());
        Truth.assertThat((Integer)authorizedViewId.hashCode()).isNotEqualTo((Object)TableId.of((String)TABLE_ID).hashCode());
    }

    @Test
    public void testToString() {
        AuthorizedViewId authorizedViewId = AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID);
        Truth.assertThat((String)authorizedViewId.toString()).isEqualTo((Object)"AuthorizedViewId{tableId=my-table, authorizedViewId=my-authorized-view}");
    }
}

