/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BulkMutationTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String AUTHORIZED_VIEW_ID = "fake-authorized-view";
    private static final String APP_PROFILE = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");

    @Test
    public void test() throws TextFormat.ParseException {
        BulkMutation m = BulkMutation.create((String)TABLE_ID).add("key-a", Mutation.create().setCell("fake-family1", "fake-qualifier1", 1000L, "fake-value1").setCell("fake-family2", "fake-qualifier2", 2000L, "fake-value2")).add(ByteString.copyFromUtf8((String)"key-b"), Mutation.create().setCell("fake-family3", "fake-qualifier3", 3000L, "fake-value3"));
        MutateRowsRequest actual = m.toProto(REQUEST_CONTEXT);
        MutateRowsRequest.Builder expected = MutateRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE);
        TextFormat.merge((CharSequence)"entries {  row_key: 'key-a'  mutations {    set_cell {      family_name: 'fake-family1'      column_qualifier: 'fake-qualifier1'      timestamp_micros: 1000      value: 'fake-value1'    }  }  mutations {    set_cell {      family_name: 'fake-family2'      column_qualifier: 'fake-qualifier2'      timestamp_micros: 2000      value: 'fake-value2'    }  }}entries {  row_key: 'key-b'  mutations {    set_cell {      family_name: 'fake-family3'      column_qualifier: 'fake-qualifier3'      timestamp_micros: 3000      value: 'fake-value3'    }  }}", (Message.Builder)expected);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected.build());
        m = BulkMutation.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).add("key-a", Mutation.create().setCell("fake-family1", "fake-qualifier1", 1000L, "fake-value1").setCell("fake-family2", "fake-qualifier2", 2000L, "fake-value2")).add(ByteString.copyFromUtf8((String)"key-b"), Mutation.create().setCell("fake-family3", "fake-qualifier3", 3000L, "fake-value3"));
        actual = m.toProto(REQUEST_CONTEXT);
        expected.clearTableName().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected.build());
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        BulkMutation expected = BulkMutation.create((String)TABLE_ID).add("key-a", Mutation.create().setCell("fake-family1", "fake-qualifier1", 1000L, "fake-value1"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        BulkMutation actual = (BulkMutation)ois.readObject();
        Truth.assertThat((Object)actual.toProto(REQUEST_CONTEXT)).isEqualTo((Object)expected.toProto(REQUEST_CONTEXT));
        expected = BulkMutation.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).add("key-a", Mutation.create().setCell("fake-family1", "fake-qualifier1", 1000L, "fake-value1"));
        bos = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        actual = (BulkMutation)ois.readObject();
        Truth.assertThat((Object)actual.toProto(REQUEST_CONTEXT)).isEqualTo((Object)expected.toProto(REQUEST_CONTEXT));
    }

    @Test
    public void cloneTest() {
        BulkMutation originalTableBulkMutation = BulkMutation.create((String)TABLE_ID).add("test-rowKey", Mutation.create().setCell("fake-family1", "fake-qualifier1", 12345L, "fake-value1"));
        MutateRowsRequest originalTableRequest = originalTableBulkMutation.toProto(REQUEST_CONTEXT);
        BulkMutation clonedTableMutation = originalTableBulkMutation.clone();
        MutateRowsRequest clonedTableRequest = clonedTableMutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Object)clonedTableRequest).isEqualTo((Object)originalTableRequest);
        Truth.assertThat((String)clonedTableRequest.getTableName()).isEqualTo((Object)originalTableRequest.getTableName());
        Truth.assertThat((String)clonedTableRequest.getAuthorizedViewName()).isEqualTo((Object)originalTableRequest.getAuthorizedViewName());
        Truth.assertThat((Iterable)clonedTableRequest.getEntriesList()).isEqualTo((Object)originalTableRequest.getEntriesList());
        clonedTableMutation.add("another-rowKey", Mutation.create().deleteCells("delete-family", "delete-qualifier"));
        Truth.assertThat((Object)clonedTableMutation.toProto(REQUEST_CONTEXT)).isNotEqualTo((Object)originalTableRequest);
        BulkMutation originalAuthorizedViewBulkMutation = BulkMutation.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).add("test-rowKey", Mutation.create().setCell("fake-family1", "fake-qualifier1", 12345L, "fake-value1"));
        MutateRowsRequest originalAuthorizedViewRequest = originalAuthorizedViewBulkMutation.toProto(REQUEST_CONTEXT);
        BulkMutation clonedAuthorizedViewMutation = originalAuthorizedViewBulkMutation.clone();
        MutateRowsRequest clonedAuthorizedViewRequest = clonedAuthorizedViewMutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Object)clonedAuthorizedViewRequest).isEqualTo((Object)originalAuthorizedViewRequest);
        Truth.assertThat((String)clonedAuthorizedViewRequest.getTableName()).isEqualTo((Object)originalAuthorizedViewRequest.getTableName());
        Truth.assertThat((String)clonedAuthorizedViewRequest.getAuthorizedViewName()).isEqualTo((Object)originalAuthorizedViewRequest.getAuthorizedViewName());
        Truth.assertThat((Iterable)clonedAuthorizedViewRequest.getEntriesList()).isEqualTo((Object)originalAuthorizedViewRequest.getEntriesList());
        clonedAuthorizedViewMutation.add("another-rowKey", Mutation.create().deleteCells("delete-family", "delete-qualifier"));
        Truth.assertThat((Object)clonedAuthorizedViewMutation.toProto(REQUEST_CONTEXT)).isNotEqualTo((Object)originalAuthorizedViewRequest);
        Truth.assertThat((Object)originalAuthorizedViewRequest).isNotEqualTo((Object)originalTableRequest);
        Truth.assertThat((Object)clonedAuthorizedViewRequest).isNotEqualTo((Object)clonedTableRequest);
    }

    @Test
    public void addRowMutationEntry() {
        RowMutationEntry entry = RowMutationEntry.create((String)"test-rowKey").setCell("fake-family1", "fake-qualifier1", "fake-value1");
        BulkMutation bulkMutation = BulkMutation.create((String)TABLE_ID);
        bulkMutation.add(entry);
        Truth.assertThat((Iterable)bulkMutation.toProto(REQUEST_CONTEXT).getEntriesList()).contains((Object)entry.toProto());
        bulkMutation = BulkMutation.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        bulkMutation.add(entry);
        Truth.assertThat((Iterable)bulkMutation.toProto(REQUEST_CONTEXT).getEntriesList()).contains((Object)entry.toProto());
    }

    @Test
    public void fromProtoTest() {
        BulkMutation expected = BulkMutation.create((String)TABLE_ID).add("key", Mutation.create().setCell("fake-family", "fake-qualifier", 10000L, "fake-value"));
        MutateRowsRequest protoRequest = expected.toProto(REQUEST_CONTEXT);
        BulkMutation actualBulkMutation = BulkMutation.fromProto((MutateRowsRequest)protoRequest);
        Truth.assertThat((Object)actualBulkMutation.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        String projectId = "fresh-project";
        String instanceId = "fresh-instance";
        String appProfile = "fresh-app-profile";
        MutateRowsRequest overriddenRequest = actualBulkMutation.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).matches(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)TABLE_ID));
        Truth.assertThat((String)overriddenRequest.getAuthorizedViewName()).isEmpty();
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
        expected = BulkMutation.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).add("key", Mutation.create().setCell("fake-family", "fake-qualifier", 10000L, "fake-value"));
        protoRequest = expected.toProto(REQUEST_CONTEXT);
        actualBulkMutation = BulkMutation.fromProto((MutateRowsRequest)protoRequest);
        Truth.assertThat((Object)actualBulkMutation.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        overriddenRequest = actualBulkMutation.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).isEmpty();
        Truth.assertThat((String)overriddenRequest.getAuthorizedViewName()).matches(NameUtil.formatAuthorizedViewName((String)projectId, (String)instanceId, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
    }

    @Test
    public void testManyMutations() {
        BulkMutation bulkMutation = BulkMutation.create((String)TABLE_ID);
        try {
            for (int i = 0; i < 3; ++i) {
                String key = "key" + i;
                Mutation mutation = Mutation.create();
                for (int j = 0; j < 50000; ++j) {
                    mutation.setCell("f", "q" + j, "value");
                }
                bulkMutation.add(key, mutation);
            }
            Assert.fail((String)"Test should fail with IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Too many mutations");
        }
        bulkMutation = BulkMutation.create((String)TABLE_ID);
        Mutation mutation = Mutation.create();
        for (int i = 0; i < 100000; ++i) {
            mutation.setCell("f", "q" + i, "value");
        }
        bulkMutation.add("key", mutation);
    }
}

