/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.StreamContinuationToken;
import com.google.bigtable.v2.StreamPartition;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChangeStreamContinuationTokenTest {
    private final String TOKEN = "token";

    private Range.ByteStringRange createFakeByteStringRange() {
        return Range.ByteStringRange.create((String)"a", (String)"b");
    }

    private RowRange rowRangeFromPartition(Range.ByteStringRange partition) {
        return RowRange.newBuilder().setStartKeyClosed((ByteString)partition.getStart()).setEndKeyOpen((ByteString)partition.getEnd()).build();
    }

    @Test
    public void basicTest() throws Exception {
        Range.ByteStringRange byteStringRange = this.createFakeByteStringRange();
        ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.create((Range.ByteStringRange)byteStringRange, (String)"token");
        Truth.assertThat((Object)changeStreamContinuationToken.getPartition()).isEqualTo((Object)byteStringRange);
        Truth.assertThat((String)changeStreamContinuationToken.getToken()).isEqualTo((Object)"token");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(changeStreamContinuationToken);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ChangeStreamContinuationToken actual = (ChangeStreamContinuationToken)ois.readObject();
        Truth.assertThat((Object)actual).isEqualTo((Object)changeStreamContinuationToken);
    }

    @Test
    public void fromProtoTest() {
        Range.ByteStringRange byteStringRange = this.createFakeByteStringRange();
        StreamContinuationToken proto = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(this.rowRangeFromPartition(byteStringRange)).build()).setToken("token").build();
        ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.fromProto((StreamContinuationToken)proto);
        Truth.assertThat((Object)changeStreamContinuationToken.getPartition()).isEqualTo((Object)byteStringRange);
        Truth.assertThat((String)changeStreamContinuationToken.getToken()).isEqualTo((Object)"token");
        Truth.assertThat((Object)changeStreamContinuationToken).isEqualTo((Object)ChangeStreamContinuationToken.fromProto((StreamContinuationToken)changeStreamContinuationToken.getTokenProto()));
    }

    @Test
    public void toByteStringTest() throws Exception {
        Range.ByteStringRange byteStringRange = this.createFakeByteStringRange();
        ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.create((Range.ByteStringRange)byteStringRange, (String)"token");
        Truth.assertThat((Object)changeStreamContinuationToken.getPartition()).isEqualTo((Object)byteStringRange);
        Truth.assertThat((String)changeStreamContinuationToken.getToken()).isEqualTo((Object)"token");
        Truth.assertThat((Object)changeStreamContinuationToken).isEqualTo((Object)ChangeStreamContinuationToken.fromByteString((ByteString)changeStreamContinuationToken.toByteString()));
    }
}

