/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.Value;
import com.google.common.primitives.Longs;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChangeStreamMutationTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String APP_PROFILE_ID = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    private static final Instant FAKE_COMMIT_TIMESTAMP = Instant.ofEpochSecond(0L, 1000L);
    private static final Instant FAKE_LOW_WATERMARK = Instant.ofEpochSecond(0L, 2000L);
    private static final org.threeten.bp.Instant FAKE_COMMIT_TIMESTAMP_THREETEN = TimeConversionUtils.toThreetenInstant((Instant)FAKE_COMMIT_TIMESTAMP);
    private static final org.threeten.bp.Instant FAKE_LOW_WATERMARK_THREETEN = TimeConversionUtils.toThreetenInstant((Instant)FAKE_LOW_WATERMARK);

    @Test
    public void userInitiatedMutationTest() throws IOException, ClassNotFoundException {
        ChangeStreamMutation changeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFromUtf8((String)"fake-value")).deleteFamily("fake-family").deleteCells("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), Range.TimestampRange.create((long)1000L, (long)2000L)).addToCell("agg-family", Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"col1")), Value.rawTimestamp((long)1000L), Value.intValue((long)1234L)).mergeToCell("agg-family", Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"col2")), Value.rawTimestamp((long)1000L), Value.rawValue((ByteString)ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L)))).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        Truth.assertThat((Iterable)changeStreamMutation.getRowKey()).isEqualTo((Object)ByteString.copyFromUtf8((String)"key"));
        Truth.assertThat((Comparable)changeStreamMutation.getType()).isEqualTo((Object)ChangeStreamMutation.MutationType.USER);
        Truth.assertThat((String)changeStreamMutation.getSourceClusterId()).isEqualTo((Object)"fake-source-cluster-id");
        Truth.assertThat((Comparable)changeStreamMutation.getCommitTime()).isEqualTo((Object)FAKE_COMMIT_TIMESTAMP);
        Truth.assertThat((Comparable)changeStreamMutation.getCommitTimestamp()).isEqualTo((Object)FAKE_COMMIT_TIMESTAMP_THREETEN);
        Truth.assertThat((Integer)changeStreamMutation.getTieBreaker()).isEqualTo((Object)0);
        Truth.assertThat((String)changeStreamMutation.getToken()).isEqualTo((Object)"fake-token");
        Truth.assertThat((Comparable)changeStreamMutation.getEstimatedLowWatermarkTime()).isEqualTo((Object)FAKE_LOW_WATERMARK);
        Truth.assertThat((Comparable)changeStreamMutation.getEstimatedLowWatermark()).isEqualTo((Object)FAKE_LOW_WATERMARK_THREETEN);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(changeStreamMutation);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ChangeStreamMutation actual = (ChangeStreamMutation)ois.readObject();
        Truth.assertThat((Object)actual).isEqualTo((Object)changeStreamMutation);
    }

    @Test
    public void gcMutationTest() throws IOException, ClassNotFoundException {
        ChangeStreamMutation changeStreamMutation = ChangeStreamMutation.createGcMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFromUtf8((String)"fake-value")).deleteFamily("fake-family").deleteCells("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), Range.TimestampRange.create((long)1000L, (long)2000L)).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        Truth.assertThat((Iterable)changeStreamMutation.getRowKey()).isEqualTo((Object)ByteString.copyFromUtf8((String)"key"));
        Truth.assertThat((Comparable)changeStreamMutation.getType()).isEqualTo((Object)ChangeStreamMutation.MutationType.GARBAGE_COLLECTION);
        Assert.assertTrue((boolean)changeStreamMutation.getSourceClusterId().isEmpty());
        Truth.assertThat((Comparable)changeStreamMutation.getCommitTime()).isEqualTo((Object)FAKE_COMMIT_TIMESTAMP);
        Truth.assertThat((Comparable)changeStreamMutation.getCommitTimestamp()).isEqualTo((Object)FAKE_COMMIT_TIMESTAMP_THREETEN);
        Truth.assertThat((Integer)changeStreamMutation.getTieBreaker()).isEqualTo((Object)0);
        Truth.assertThat((String)changeStreamMutation.getToken()).isEqualTo((Object)"fake-token");
        Truth.assertThat((Comparable)changeStreamMutation.getEstimatedLowWatermarkTime()).isEqualTo((Object)FAKE_LOW_WATERMARK);
        Truth.assertThat((Comparable)changeStreamMutation.getEstimatedLowWatermark()).isEqualTo((Object)FAKE_LOW_WATERMARK_THREETEN);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(changeStreamMutation);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ChangeStreamMutation actual = (ChangeStreamMutation)ois.readObject();
        Truth.assertThat((Object)actual).isEqualTo((Object)changeStreamMutation);
    }

    @Test
    public void toRowMutationTest() {
        ChangeStreamMutation changeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFromUtf8((String)"fake-value")).deleteFamily("fake-family").deleteCells("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), Range.TimestampRange.create((long)1000L, (long)2000L)).addToCell("agg-family", Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual1")), Value.rawTimestamp((long)1000L), Value.intValue((long)1234L)).mergeToCell("agg-family", Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual2")), Value.rawTimestamp((long)1000L), Value.rawValue((ByteString)ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L)))).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        RowMutation rowMutation = changeStreamMutation.toRowMutation(TABLE_ID);
        MutateRowRequest mutateRowRequest = rowMutation.toProto(REQUEST_CONTEXT);
        String tableName = NameUtil.formatTableName((String)REQUEST_CONTEXT.getProjectId(), (String)REQUEST_CONTEXT.getInstanceId(), (String)TABLE_ID);
        Truth.assertThat((String)mutateRowRequest.getTableName()).isEqualTo((Object)tableName);
        Truth.assertThat((Iterable)mutateRowRequest.getMutationsList()).hasSize(5);
        Truth.assertThat((Iterable)mutateRowRequest.getMutations(0).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((String)mutateRowRequest.getMutations(1).getDeleteFromFamily().getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((String)mutateRowRequest.getMutations(2).getDeleteFromColumn().getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((Iterable)mutateRowRequest.getMutations(2).getDeleteFromColumn().getColumnQualifier()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-qualifier"));
        Truth.assertThat((Object)mutateRowRequest.getMutations(3).getAddToCell()).isEqualTo((Object)Mutation.AddToCell.newBuilder().setFamilyName("agg-family").setColumnQualifier(Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual1")).toProto()).setTimestamp(Value.rawTimestamp((long)1000L).toProto()).setInput(Value.intValue((long)1234L).toProto()).build());
        Truth.assertThat((Object)mutateRowRequest.getMutations(4).getMergeToCell()).isEqualTo((Object)Mutation.MergeToCell.newBuilder().setFamilyName("agg-family").setColumnQualifier(Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual2")).toProto()).setTimestamp(Value.rawTimestamp((long)1000L).toProto()).setInput(Value.rawValue((ByteString)ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L))).toProto()).build());
    }

    @Test
    public void toRowMutationWithoutTokenShouldFailTest() {
        ChangeStreamMutation.Builder builder = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK);
        Assert.assertThrows(IllegalStateException.class, () -> ((ChangeStreamMutation.Builder)builder).build());
    }

    @Test
    public void toRowMutationWithoutLowWatermarkShouldFailTest() {
        ChangeStreamMutation.Builder builder = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setToken("fake-token");
        Assert.assertThrows(IllegalStateException.class, () -> ((ChangeStreamMutation.Builder)builder).build());
    }

    @Test
    public void toRowMutationEntryTest() {
        ChangeStreamMutation changeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFromUtf8((String)"fake-value")).deleteFamily("fake-family").deleteCells("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), Range.TimestampRange.create((long)1000L, (long)2000L)).addToCell("agg-family", Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual1")), Value.rawTimestamp((long)1000L), Value.intValue((long)1234L)).mergeToCell("agg-family", Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual2")), Value.rawTimestamp((long)1000L), Value.rawValue((ByteString)ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L)))).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        RowMutationEntry rowMutationEntry = changeStreamMutation.toRowMutationEntry();
        MutateRowsRequest.Entry mutateRowsRequestEntry = rowMutationEntry.toProto();
        Truth.assertThat((Iterable)mutateRowsRequestEntry.getRowKey()).isEqualTo((Object)ByteString.copyFromUtf8((String)"key"));
        Truth.assertThat((Iterable)mutateRowsRequestEntry.getMutationsList()).hasSize(5);
        Truth.assertThat((Iterable)mutateRowsRequestEntry.getMutations(0).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((String)mutateRowsRequestEntry.getMutations(1).getDeleteFromFamily().getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((String)mutateRowsRequestEntry.getMutations(2).getDeleteFromColumn().getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((Iterable)mutateRowsRequestEntry.getMutations(2).getDeleteFromColumn().getColumnQualifier()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-qualifier"));
        Truth.assertThat((Object)mutateRowsRequestEntry.getMutations(3).getAddToCell()).isEqualTo((Object)Mutation.AddToCell.newBuilder().setFamilyName("agg-family").setColumnQualifier(Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual1")).toProto()).setTimestamp(Value.rawTimestamp((long)1000L).toProto()).setInput(Value.intValue((long)1234L).toProto()).build());
        Truth.assertThat((Object)mutateRowsRequestEntry.getMutations(4).getMergeToCell()).isEqualTo((Object)Mutation.MergeToCell.newBuilder().setFamilyName("agg-family").setColumnQualifier(Value.rawValue((ByteString)ByteString.copyFromUtf8((String)"qual2")).toProto()).setTimestamp(Value.rawTimestamp((long)1000L).toProto()).setInput(Value.rawValue((ByteString)ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L))).toProto()).build());
    }

    @Test
    public void toRowMutationEntryWithoutTokenShouldFailTest() {
        ChangeStreamMutation.Builder builder = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK);
        Assert.assertThrows(IllegalStateException.class, () -> ((ChangeStreamMutation.Builder)builder).build());
    }

    @Test
    public void toRowMutationEntryWithoutLowWatermarkShouldFailTest() {
        ChangeStreamMutation.Builder builder = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setToken("fake-token");
        Assert.assertThrows(IllegalStateException.class, () -> ((ChangeStreamMutation.Builder)builder).build());
    }

    @Test
    public void testWithLongValue() {
        ChangeStreamMutation changeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFrom((byte[])Longs.toByteArray((long)1L))).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        RowMutation rowMutation = changeStreamMutation.toRowMutation(TABLE_ID);
        MutateRowRequest mutateRowRequest = rowMutation.toProto(REQUEST_CONTEXT);
        String tableName = NameUtil.formatTableName((String)REQUEST_CONTEXT.getProjectId(), (String)REQUEST_CONTEXT.getInstanceId(), (String)TABLE_ID);
        Truth.assertThat((String)mutateRowRequest.getTableName()).isEqualTo((Object)tableName);
        Truth.assertThat((Iterable)mutateRowRequest.getMutationsList()).hasSize(1);
        Truth.assertThat((Iterable)mutateRowRequest.getMutations(0).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001"));
    }
}

