/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.StreamContinuationToken;
import com.google.bigtable.v2.StreamPartition;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.Heartbeat;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChangeStreamRecordTest {
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Test
    public void heartbeatSerializationTest() throws IOException, ClassNotFoundException {
        ReadChangeStreamResponse.Heartbeat heartbeatProto = ReadChangeStreamResponse.Heartbeat.newBuilder().setEstimatedLowWatermark(Timestamp.newBuilder().setSeconds(1000L).build()).setContinuationToken(StreamContinuationToken.newBuilder().setToken("random-token").build()).build();
        Heartbeat heartbeat = Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)heartbeatProto);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(heartbeat);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Heartbeat actual = (Heartbeat)ois.readObject();
        Truth.assertThat((Object)actual).isEqualTo((Object)heartbeat);
    }

    @Test
    public void closeStreamSerializationTest() throws IOException, ClassNotFoundException {
        Status status = Status.newBuilder().setCode(11).build();
        RowRange rowRange1 = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"apple")).build();
        String token1 = "close-stream-token-1";
        RowRange rowRange2 = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"apple")).setEndKeyOpen(ByteString.copyFromUtf8((String)"")).build();
        String token2 = "close-stream-token-2";
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange1).build()).setToken(token1).build()).addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange2).build()).setToken(token2).build()).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange1)).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange2)).setStatus(status).build();
        CloseStream closeStream = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)closeStreamProto);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(closeStream);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        CloseStream actual = (CloseStream)ois.readObject();
        Truth.assertThat((Iterable)actual.getChangeStreamContinuationTokens()).isEqualTo((Object)closeStream.getChangeStreamContinuationTokens());
        Truth.assertThat((Object)actual.getStatus()).isEqualTo((Object)closeStream.getStatus());
        Truth.assertThat((Iterable)actual.getNewPartitions()).isEqualTo((Object)closeStream.getNewPartitions());
    }

    @Test
    public void heartbeatTest() {
        Timestamp lowWatermark = Timestamp.newBuilder().setSeconds(1000L).build();
        RowRange rowRange = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"apple")).setEndKeyOpen(ByteString.copyFromUtf8((String)"banana")).build();
        String token = "heartbeat-token";
        ReadChangeStreamResponse.Heartbeat heartbeatProto = ReadChangeStreamResponse.Heartbeat.newBuilder().setEstimatedLowWatermark(lowWatermark).setContinuationToken(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange).build()).setToken(token).build()).build();
        Heartbeat actualHeartbeat = Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)heartbeatProto);
        Truth.assertThat((Comparable)actualHeartbeat.getEstimatedLowWatermarkTime()).isEqualTo((Object)Instant.ofEpochSecond(lowWatermark.getSeconds(), lowWatermark.getNanos()));
        Truth.assertThat((Object)actualHeartbeat.getChangeStreamContinuationToken().getPartition()).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange.getStartKeyClosed(), (ByteString)rowRange.getEndKeyOpen()));
        Truth.assertThat((String)actualHeartbeat.getChangeStreamContinuationToken().getToken()).isEqualTo((Object)token);
    }

    @Test
    public void closeStreamTest() {
        Status status = Status.newBuilder().setCode(11).build();
        RowRange rowRange1 = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"apple")).build();
        String token1 = "close-stream-token-1";
        RowRange rowRange2 = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"apple")).setEndKeyOpen(ByteString.copyFromUtf8((String)"")).build();
        String token2 = "close-stream-token-2";
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange1).build()).setToken(token1).build()).addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange2).build()).setToken(token2).build()).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange1)).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange2)).setStatus(status).build();
        CloseStream actualCloseStream = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)closeStreamProto);
        Truth.assertThat((Object)status).isEqualTo((Object)actualCloseStream.getStatus().toProto());
        Truth.assertThat((Object)((ChangeStreamContinuationToken)actualCloseStream.getChangeStreamContinuationTokens().get(0)).getPartition()).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange1.getStartKeyClosed(), (ByteString)rowRange1.getEndKeyOpen()));
        Truth.assertThat((String)token1).isEqualTo((Object)((ChangeStreamContinuationToken)actualCloseStream.getChangeStreamContinuationTokens().get(0)).getToken());
        Truth.assertThat((Object)((ChangeStreamContinuationToken)actualCloseStream.getChangeStreamContinuationTokens().get(1)).getPartition()).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange2.getStartKeyClosed(), (ByteString)rowRange2.getEndKeyOpen()));
        Truth.assertThat((String)token2).isEqualTo((Object)((ChangeStreamContinuationToken)actualCloseStream.getChangeStreamContinuationTokens().get(1)).getToken());
        Truth.assertThat(actualCloseStream.getNewPartitions().get(0)).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange1.getStartKeyClosed(), (ByteString)rowRange1.getEndKeyOpen()));
        Truth.assertThat(actualCloseStream.getNewPartitions().get(1)).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange2.getStartKeyClosed(), (ByteString)rowRange2.getEndKeyOpen()));
    }

    @Test(expected=IllegalStateException.class)
    public void closeStreamOkWithContinuationTokenShouldFail() {
        Status status = Status.newBuilder().setCode(0).build();
        RowRange rowRange = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"apple")).build();
        String token = "close-stream-token-1";
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange)).setToken(token)).setStatus(status).build();
        Assert.assertThrows(IllegalStateException.class, (ThrowingRunnable)((ThrowingRunnable)CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)closeStreamProto)));
    }

    @Test(expected=IllegalStateException.class)
    public void closeStreamErrorWithoutContinuationTokenShouldFail() {
        Status status = Status.newBuilder().setCode(11).build();
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().setStatus(status).build();
        Assert.assertThrows(IllegalStateException.class, (ThrowingRunnable)((ThrowingRunnable)CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)closeStreamProto)));
    }

    @Test(expected=IllegalStateException.class)
    public void closeStreamTokenAndNewPartitionCountMismatchedTest() {
        Status status = Status.newBuilder().setCode(11).build();
        RowRange rowRange = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"apple")).build();
        String token = "close-stream-token-1";
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange)).setToken(token)).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange)).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange)).setStatus(status).build();
        Assert.assertThrows(IllegalStateException.class, (ThrowingRunnable)((ThrowingRunnable)CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)closeStreamProto)));
    }

    @Test
    public void closeStreamTokenAndZeroNewPartitionMismatchNoExceptionTest() throws IOException, ClassNotFoundException {
        Status status = Status.newBuilder().setCode(11).build();
        RowRange rowRange = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"apple")).build();
        String token = "close-stream-token-1";
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().addContinuationTokens(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange)).setToken(token)).setStatus(status).build();
        CloseStream closeStream = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)closeStreamProto);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(closeStream);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        CloseStream actual = (CloseStream)ois.readObject();
        Truth.assertThat((Iterable)actual.getChangeStreamContinuationTokens()).isEqualTo((Object)closeStream.getChangeStreamContinuationTokens());
        Truth.assertThat((Object)actual.getStatus()).isEqualTo((Object)closeStream.getStatus());
        Truth.assertThat((Iterable)actual.getNewPartitions()).isEqualTo((Object)closeStream.getNewPartitions());
    }
}

